/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.support.AbstractObjectFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDObjectFactory
extends AbstractObjectFactory {
    private static UIDObjectFactory theFactory;
    private static final int FIRST_INDEX = 14;
    private static final int UID_PROJECT_UID = 14;
    private static final int UID_NAMESPACE_UID = 15;
    private static final int UID_FILE_UID = 16;
    private static final int UID_TYPEDEF_UID = 17;
    private static final int UID_CLASSIFIER_UID = 18;
    private static final int UID_UNNAMED_CLASSIFIER_UID = 19;
    private static final int UID_MACRO_UID = 20;
    private static final int UID_INCLUDE_UID = 21;
    private static final int UID_PARAM_LIST_UID = 22;
    private static final int UID_UNNAMED_OFFSETABLE_DECLARATION_UID = 23;
    private static final int UID_DECLARATION_UID = 24;
    private static final int UID_BUILT_IN_UID = 25;
    private static final int UID_INSTANTIATION_UID = 26;
    private static final int UID_UNRESOLVED_CLASS = 27;
    private static final int UID_UNRESOLVED_FILE = 28;
    private static final int UID_UNRESOLVED_NAMESPACE = 29;
    public static final int LAST_INDEX = 29;
    private static final Comparator<FileImpl.OffsetSortedKey> OSKComparator;
    private static final Comparator<FileImpl.NameSortedKey> NSKComparator;

    protected UIDObjectFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UIDObjectFactory getDefaultFactory() {
        UIDObjectFactory uIDObjectFactory = theFactory;
        if (uIDObjectFactory != null) return theFactory;
        uIDObjectFactory = theFactory;
        Class<UIDObjectFactory> clazz = UIDObjectFactory.class;
        synchronized (UIDObjectFactory.class) {
            uIDObjectFactory = theFactory;
            if (uIDObjectFactory != null) return theFactory;
            theFactory = uIDObjectFactory = new UIDObjectFactory();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return theFactory;
        }
    }

    public void writeUID(CsmUID<?> csmUID, DataOutput dataOutput) throws IOException {
        if (csmUID != null && !(csmUID instanceof SelfPersistent)) assert (false) : csmUID + ", " + csmUID.getObject();
        super.writeSelfPersistent((SelfPersistent)csmUID, dataOutput);
    }

    public <T> CsmUID<T> readUID(DataInput dataInput) throws IOException {
        assert (dataInput != null);
        SelfPersistent selfPersistent = super.readSelfPersistent(dataInput);
        assert (selfPersistent == null || selfPersistent instanceof CsmUID);
        return (CsmUID)selfPersistent;
    }

    public <T> void writeUIDCollection(Collection<CsmUID<T>> collection, DataOutput dataOutput, boolean bl) throws IOException {
        assert (dataOutput != null);
        if (collection == null) {
            dataOutput.writeInt(-1);
        } else {
            collection = bl ? UIDObjectFactory.copySyncCollection(collection) : collection;
            int n = collection.size();
            dataOutput.writeInt(n);
            for (CsmUID<T> csmUID : collection) {
                assert (csmUID != null);
                this.writeUID(csmUID, dataOutput);
            }
        }
    }

    public <A, T extends Collection<CsmUID<A>>> T readUIDCollection(T t, DataInput dataInput) throws IOException {
        assert (t != null);
        assert (dataInput != null);
        int n = dataInput.readInt();
        return this.readUIDCollection(t, dataInput, n);
    }

    public <A, T extends Collection<CsmUID<A>>> T readUIDCollection(T t, DataInput dataInput, int n) throws IOException {
        if (n == -1) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            CsmUID<T> csmUID = this.readUID(dataInput);
            assert (csmUID != null);
            t.add(csmUID);
        }
        return t;
    }

    public <T> void writeStringToUIDMap(Map<CharSequence, CsmUID<T>> map, DataOutput dataOutput, boolean bl) throws IOException {
        assert (map != null);
        assert (dataOutput != null);
        map = bl ? UIDObjectFactory.copySyncMap(map) : map;
        int n = map.size();
        dataOutput.writeInt(n);
        for (Map.Entry<CharSequence, CsmUID<T>> entry : map.entrySet()) {
            CharSequence charSequence = entry.getKey();
            assert (charSequence != null);
            PersistentUtils.writeUTF(charSequence, dataOutput);
            CsmUID<T> csmUID = entry.getValue();
            assert (csmUID != null);
            this.writeUID(csmUID, dataOutput);
        }
    }

    public <T> void writeOffsetSortedToUIDMap(Map<FileImpl.OffsetSortedKey, CsmUID<T>> map, DataOutput dataOutput, boolean bl) throws IOException {
        assert (map != null);
        assert (dataOutput != null);
        map = bl ? UIDObjectFactory.copySyncMap(map) : map;
        int n = map.size();
        dataOutput.writeInt(n);
        for (Map.Entry<FileImpl.OffsetSortedKey, CsmUID<T>> entry : map.entrySet()) {
            entry.getKey().write(dataOutput);
            CsmUID<T> csmUID = entry.getValue();
            assert (csmUID != null);
            this.writeUID(csmUID, dataOutput);
        }
    }

    public <T> void writeNameSortedToUIDMap(Map<FileImpl.NameSortedKey, CsmUID<T>> map, DataOutput dataOutput, boolean bl) throws IOException {
        assert (map != null);
        assert (dataOutput != null);
        map = bl ? UIDObjectFactory.copySyncMap(map) : map;
        int n = map.size();
        dataOutput.writeInt(n);
        for (Map.Entry<FileImpl.NameSortedKey, CsmUID<T>> entry : map.entrySet()) {
            entry.getKey().write(dataOutput);
            CsmUID<T> csmUID = entry.getValue();
            assert (csmUID != null);
            this.writeUID(csmUID, dataOutput);
        }
    }

    public <T> void writeNameSortedToUIDMap2(Map<NamespaceImpl.FileNameSortedKey, CsmUID<T>> map, DataOutput dataOutput, boolean bl) throws IOException {
        assert (map != null);
        assert (dataOutput != null);
        map = bl ? UIDObjectFactory.copySyncMap(map) : map;
        int n = map.size();
        dataOutput.writeInt(n);
        for (Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<T>> entry : map.entrySet()) {
            entry.getKey().write(dataOutput);
            CsmUID<T> csmUID = entry.getValue();
            assert (csmUID != null);
            this.writeUID(csmUID, dataOutput);
        }
    }

    public void writeStringToArrayUIDMap(Map<CharSequence, Object> map, DataOutput dataOutput, boolean bl) throws IOException {
        assert (map != null);
        assert (dataOutput != null);
        map = bl ? UIDObjectFactory.copySyncMap(map) : map;
        int n = map.size();
        dataOutput.writeInt(n);
        for (Map.Entry<CharSequence, Object> entry : map.entrySet()) {
            CharSequence charSequence = entry.getKey();
            assert (charSequence != null);
            PersistentUtils.writeUTF(charSequence, dataOutput);
            Object object = entry.getValue();
            if (object instanceof CsmUID) {
                dataOutput.writeInt(1);
                this.writeUID((CsmUID)object, dataOutput);
                continue;
            }
            CsmUID[] csmUIDArray = (CsmUID[])object;
            dataOutput.writeInt(csmUIDArray.length);
            for (CsmUID csmUID : csmUIDArray) {
                assert (csmUID != null);
                this.writeUID(csmUID, dataOutput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Collection<CsmUID<T>> copySyncCollection(Collection<CsmUID<T>> collection) {
        ArrayList<CsmUID<T>> arrayList;
        Collection<CsmUID<T>> collection2 = collection;
        synchronized (collection2) {
            arrayList = new ArrayList<CsmUID<T>>(collection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> Map<K, V> copySyncMap(Map<K, V> map) {
        HashMap<K, V> hashMap;
        Map<K, V> map2 = map;
        synchronized (map2) {
            hashMap = new HashMap<K, V>(map);
        }
        return hashMap;
    }

    public <T> void readStringToUIDMap(Map<CharSequence, CsmUID<T>> map, DataInput dataInput, APTStringManager aPTStringManager, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence = PersistentUtils.readUTF(dataInput, aPTStringManager);
            assert (charSequence != null);
            CsmUID<T> csmUID = this.readUID(dataInput);
            assert (csmUID != null);
            map.put(charSequence, csmUID);
        }
    }

    public TreeMap<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> readOffsetSortedToUIDMap(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        assert (dataInput != null);
        HelperDeclarationsSortedMap helperDeclarationsSortedMap = new HelperDeclarationsSortedMap(this, dataInput, aPTStringManager);
        return new TreeMap<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>(helperDeclarationsSortedMap);
    }

    public TreeMap<FileImpl.NameSortedKey, CsmUID<CsmMacro>> readNameSortedToUIDMap(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        assert (dataInput != null);
        HelperMacrosSortedMap helperMacrosSortedMap = new HelperMacrosSortedMap(this, dataInput, aPTStringManager);
        return new TreeMap<FileImpl.NameSortedKey, CsmUID<CsmMacro>>(helperMacrosSortedMap);
    }

    public TreeMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> readNameSortedToUIDMap2(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        assert (dataInput != null);
        HelperNamespaceDefinitionSortedMap helperNamespaceDefinitionSortedMap = new HelperNamespaceDefinitionSortedMap(this, dataInput, aPTStringManager);
        return new TreeMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>(helperNamespaceDefinitionSortedMap);
    }

    public TreeMap<CharSequence, Object> readStringToArrayUIDMap(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        assert (dataInput != null);
        HelperCharSequencesSortedMap helperCharSequencesSortedMap = new HelperCharSequencesSortedMap(this, dataInput, aPTStringManager);
        return new TreeMap<CharSequence, Object>(helperCharSequencesSortedMap);
    }

    public TreeMap<CharSequence, CsmUID<CsmNamespaceDefinition>> readStringToUIDMap(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        assert (dataInput != null);
        HelperCharSequencesSortedMap2 helperCharSequencesSortedMap2 = new HelperCharSequencesSortedMap2(this, dataInput, aPTStringManager);
        return new TreeMap<CharSequence, CsmUID<CsmNamespaceDefinition>>(helperCharSequencesSortedMap2);
    }

    protected int getHandler(Object object) {
        int n;
        if (object instanceof UIDUtilities.ProjectUID) {
            n = 14;
        } else if (object instanceof UIDUtilities.NamespaceUID) {
            n = 15;
        } else if (object instanceof UIDUtilities.FileUID) {
            n = 16;
        } else if (object instanceof UIDUtilities.TypedefUID) {
            n = 17;
        } else if (object instanceof UIDUtilities.ClassifierUID) {
            n = 18;
        } else if (object instanceof UIDUtilities.UnnamedClassifierUID) {
            n = 19;
        } else if (object instanceof UIDUtilities.MacroUID) {
            n = 20;
        } else if (object instanceof UIDUtilities.IncludeUID) {
            n = 21;
        } else if (object instanceof UIDUtilities.ParamListUID) {
            n = 22;
        } else if (object instanceof UIDUtilities.UnnamedOffsetableDeclarationUID) {
            n = 23;
        } else if (object instanceof UIDUtilities.DeclarationUID) {
            n = 24;
        } else if (object instanceof BuiltinTypes.BuiltInUID) {
            n = 25;
        } else if (object instanceof Instantiation.InstantiationUID) {
            n = 26;
        } else if (object instanceof UIDUtilities.UnresolvedClassUID) {
            n = 27;
        } else if (object instanceof UIDUtilities.UnresolvedFileUID) {
            n = 28;
        } else if (object instanceof UIDUtilities.UnresolvedNamespaceUID) {
            n = 29;
        } else {
            throw new IllegalArgumentException("The UID is an instance of unknow class");
        }
        return n;
    }

    protected SelfPersistent createObject(int n, DataInput dataInput) throws IOException {
        Object object;
        boolean bl = false;
        switch (n) {
            case 14: {
                bl = true;
                object = new UIDUtilities.ProjectUID(dataInput);
                break;
            }
            case 15: {
                bl = true;
                object = new UIDUtilities.NamespaceUID(dataInput);
                break;
            }
            case 16: {
                bl = true;
                object = new UIDUtilities.FileUID(dataInput);
                break;
            }
            case 17: {
                object = new UIDUtilities.TypedefUID(dataInput);
                break;
            }
            case 18: {
                object = new UIDUtilities.ClassifierUID(dataInput);
                break;
            }
            case 19: {
                object = new UIDUtilities.UnnamedClassifierUID(dataInput);
                break;
            }
            case 20: {
                bl = true;
                object = new UIDUtilities.MacroUID(dataInput);
                break;
            }
            case 21: {
                bl = true;
                object = new UIDUtilities.IncludeUID(dataInput);
                break;
            }
            case 22: {
                object = new UIDUtilities.ParamListUID(dataInput);
                break;
            }
            case 23: {
                object = new UIDUtilities.UnnamedOffsetableDeclarationUID(dataInput);
                break;
            }
            case 24: {
                object = new UIDUtilities.DeclarationUID(dataInput);
                break;
            }
            case 25: {
                object = BuiltinTypes.readUID(dataInput);
                bl = false;
                break;
            }
            case 26: {
                object = new Instantiation.InstantiationUID(dataInput);
                bl = false;
                break;
            }
            case 27: {
                object = new UIDUtilities.UnresolvedClassUID(dataInput);
                break;
            }
            case 28: {
                object = new UIDUtilities.UnresolvedFileUID(dataInput);
                break;
            }
            case 29: {
                object = new UIDUtilities.UnresolvedNamespaceUID(dataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException("The UID is an instance of unknown class: " + n);
            }
        }
        if (bl) {
            assert (object != null);
            assert (object instanceof CsmUID);
            CsmUID csmUID = UIDManager.instance().getSharedUID(object);
            assert (csmUID != null);
            assert (csmUID instanceof SelfPersistent);
            object = (SelfPersistent)csmUID;
        }
        return object;
    }

    static {
        OSKComparator = new Comparator<FileImpl.OffsetSortedKey>(){

            @Override
            public int compare(FileImpl.OffsetSortedKey offsetSortedKey, FileImpl.OffsetSortedKey offsetSortedKey2) {
                return offsetSortedKey.compareTo(offsetSortedKey2);
            }
        };
        NSKComparator = new Comparator<FileImpl.NameSortedKey>(){

            @Override
            public int compare(FileImpl.NameSortedKey nameSortedKey, FileImpl.NameSortedKey nameSortedKey2) {
                return nameSortedKey.compareTo(nameSortedKey2);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HelperCharSequencesSortedMap2
    implements SortedMap<CharSequence, CsmUID<CsmNamespaceDefinition>> {
        private final DataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperCharSequencesSortedMap2(UIDObjectFactory uIDObjectFactory, DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
            this.size = dataInput.readInt();
            this.aStream = dataInput;
            this.factory = uIDObjectFactory;
            this.manager = aPTStringManager;
        }

        @Override
        public Comparator<? super CharSequence> comparator() {
            return CharSequenceKey.Comparator;
        }

        @Override
        public SortedMap<CharSequence, CsmUID<CsmNamespaceDefinition>> subMap(CharSequence charSequence, CharSequence charSequence2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<CharSequence, CsmUID<CsmNamespaceDefinition>> headMap(CharSequence charSequence) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<CharSequence, CsmUID<CsmNamespaceDefinition>> tailMap(CharSequence charSequence) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CharSequence firstKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CharSequence lastKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> get(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> put(CharSequence charSequence, CsmUID<CsmNamespaceDefinition> csmUID) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> remove(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putAll(Map<? extends CharSequence, ? extends CsmUID<CsmNamespaceDefinition>> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<CharSequence> keySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<CsmUID<CsmNamespaceDefinition>> values() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>> entrySet() {
            return new Set<Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>>(){

                @Override
                public int size() {
                    return HelperCharSequencesSortedMap2.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperCharSequencesSortedMap2.this.size == 0;
                }

                @Override
                public boolean contains(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Iterator<Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>> iterator() {
                    return new Iterator<Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>>(){
                        private int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperCharSequencesSortedMap2.this.size;
                        }

                        @Override
                        public Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>> next() {
                            if (this.current < HelperCharSequencesSortedMap2.this.size) {
                                ++this.current;
                                try {
                                    final CharSequence charSequence = PersistentUtils.readUTF(HelperCharSequencesSortedMap2.this.aStream, HelperCharSequencesSortedMap2.this.manager);
                                    assert (charSequence != null);
                                    final CsmUID csmUID = HelperCharSequencesSortedMap2.this.factory.readUID(HelperCharSequencesSortedMap2.this.aStream);
                                    assert (csmUID != null);
                                    return new Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>(){

                                        @Override
                                        public CharSequence getKey() {
                                            return charSequence;
                                        }

                                        @Override
                                        public CsmUID<CsmNamespaceDefinition> getValue() {
                                            return csmUID;
                                        }

                                        @Override
                                        public CsmUID<CsmNamespaceDefinition> setValue(CsmUID<CsmNamespaceDefinition> csmUID2) {
                                            throw new UnsupportedOperationException("Not supported yet.");
                                        }
                                    };
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                            return null;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public <T> T[] toArray(T[] TArray) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean add(Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>> entry) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean remove(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean containsAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean retainAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean removeAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HelperCharSequencesSortedMap
    implements SortedMap<CharSequence, Object> {
        private final DataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperCharSequencesSortedMap(UIDObjectFactory uIDObjectFactory, DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
            this.size = dataInput.readInt();
            this.aStream = dataInput;
            this.factory = uIDObjectFactory;
            this.manager = aPTStringManager;
        }

        @Override
        public Comparator<? super CharSequence> comparator() {
            return CharSequenceKey.Comparator;
        }

        @Override
        public SortedMap<CharSequence, Object> subMap(CharSequence charSequence, CharSequence charSequence2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<CharSequence, Object> headMap(CharSequence charSequence) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<CharSequence, Object> tailMap(CharSequence charSequence) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CharSequence firstKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CharSequence lastKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object get(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object put(CharSequence charSequence, Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putAll(Map<? extends CharSequence, ? extends Object> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<CharSequence> keySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Map.Entry<CharSequence, Object>> entrySet() {
            return new Set<Map.Entry<CharSequence, Object>>(){

                @Override
                public int size() {
                    return HelperCharSequencesSortedMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperCharSequencesSortedMap.this.size == 0;
                }

                @Override
                public boolean contains(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Iterator<Map.Entry<CharSequence, Object>> iterator() {
                    return new Iterator<Map.Entry<CharSequence, Object>>(){
                        private int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperCharSequencesSortedMap.this.size;
                        }

                        @Override
                        public Map.Entry<CharSequence, Object> next() {
                            if (this.current < HelperCharSequencesSortedMap.this.size) {
                                ++this.current;
                                try {
                                    CsmUID[] csmUIDArray;
                                    final CharSequence charSequence = PersistentUtils.readUTF(HelperCharSequencesSortedMap.this.aStream, HelperCharSequencesSortedMap.this.manager);
                                    assert (charSequence != null);
                                    int n = HelperCharSequencesSortedMap.this.aStream.readInt();
                                    if (n == 1) {
                                        csmUIDArray = HelperCharSequencesSortedMap.this.factory.readUID(HelperCharSequencesSortedMap.this.aStream);
                                        assert (csmUIDArray != null);
                                    } else {
                                        CsmUID[] csmUIDArray2 = new CsmUID[n];
                                        for (int i = 0; i < n; ++i) {
                                            CsmUID csmUID = HelperCharSequencesSortedMap.this.factory.readUID(HelperCharSequencesSortedMap.this.aStream);
                                            assert (csmUID != null);
                                            csmUIDArray2[i] = csmUID;
                                        }
                                        csmUIDArray = csmUIDArray2;
                                    }
                                    return new Map.Entry<CharSequence, Object>(){

                                        @Override
                                        public CharSequence getKey() {
                                            return charSequence;
                                        }

                                        @Override
                                        public Object getValue() {
                                            return csmUIDArray;
                                        }

                                        @Override
                                        public Object setValue(Object object) {
                                            throw new UnsupportedOperationException("Not supported yet.");
                                        }
                                    };
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                            return null;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public <T> T[] toArray(T[] TArray) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean add(Map.Entry<CharSequence, Object> entry) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean remove(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean containsAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<CharSequence, Object>> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean retainAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean removeAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HelperNamespaceDefinitionSortedMap
    implements SortedMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> {
        private final DataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperNamespaceDefinitionSortedMap(UIDObjectFactory uIDObjectFactory, DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
            this.size = dataInput.readInt();
            this.aStream = dataInput;
            this.factory = uIDObjectFactory;
            this.manager = aPTStringManager;
        }

        @Override
        public Comparator<? super NamespaceImpl.FileNameSortedKey> comparator() {
            return NamespaceImpl.defenitionComparator;
        }

        @Override
        public SortedMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> subMap(NamespaceImpl.FileNameSortedKey fileNameSortedKey, NamespaceImpl.FileNameSortedKey fileNameSortedKey2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> headMap(NamespaceImpl.FileNameSortedKey fileNameSortedKey) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> tailMap(NamespaceImpl.FileNameSortedKey fileNameSortedKey) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public NamespaceImpl.FileNameSortedKey firstKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public NamespaceImpl.FileNameSortedKey lastKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> get(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> put(NamespaceImpl.FileNameSortedKey fileNameSortedKey, CsmUID<CsmNamespaceDefinition> csmUID) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> remove(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putAll(Map<? extends NamespaceImpl.FileNameSortedKey, ? extends CsmUID<CsmNamespaceDefinition>> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<NamespaceImpl.FileNameSortedKey> keySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<CsmUID<CsmNamespaceDefinition>> values() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>> entrySet() {
            return new Set<Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>>(){

                @Override
                public int size() {
                    return HelperNamespaceDefinitionSortedMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperNamespaceDefinitionSortedMap.this.size == 0;
                }

                @Override
                public boolean contains(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Iterator<Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>> iterator() {
                    return new Iterator<Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>>(){
                        int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperNamespaceDefinitionSortedMap.this.size;
                        }

                        @Override
                        public Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> next() {
                            if (this.current < HelperNamespaceDefinitionSortedMap.this.size) {
                                ++this.current;
                                try {
                                    final NamespaceImpl.FileNameSortedKey fileNameSortedKey = new NamespaceImpl.FileNameSortedKey(HelperNamespaceDefinitionSortedMap.this.aStream);
                                    final CsmUID csmUID = HelperNamespaceDefinitionSortedMap.this.factory.readUID(HelperNamespaceDefinitionSortedMap.this.aStream);
                                    assert (csmUID != null);
                                    return new Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>(){

                                        @Override
                                        public NamespaceImpl.FileNameSortedKey getKey() {
                                            return fileNameSortedKey;
                                        }

                                        @Override
                                        public CsmUID<CsmNamespaceDefinition> getValue() {
                                            return csmUID;
                                        }

                                        @Override
                                        public CsmUID<CsmNamespaceDefinition> setValue(CsmUID<CsmNamespaceDefinition> csmUID2) {
                                            throw new UnsupportedOperationException("Not supported yet.");
                                        }
                                    };
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                            return null;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public <T> T[] toArray(T[] TArray) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean add(Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> entry) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean remove(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean containsAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean retainAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean removeAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HelperMacrosSortedMap
    implements SortedMap<FileImpl.NameSortedKey, CsmUID<CsmMacro>> {
        private final DataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperMacrosSortedMap(UIDObjectFactory uIDObjectFactory, DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
            this.size = dataInput.readInt();
            this.aStream = dataInput;
            this.factory = uIDObjectFactory;
            this.manager = aPTStringManager;
        }

        @Override
        public Comparator<? super FileImpl.NameSortedKey> comparator() {
            return NSKComparator;
        }

        @Override
        public SortedMap<FileImpl.NameSortedKey, CsmUID<CsmMacro>> subMap(FileImpl.NameSortedKey nameSortedKey, FileImpl.NameSortedKey nameSortedKey2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<FileImpl.NameSortedKey, CsmUID<CsmMacro>> headMap(FileImpl.NameSortedKey nameSortedKey) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<FileImpl.NameSortedKey, CsmUID<CsmMacro>> tailMap(FileImpl.NameSortedKey nameSortedKey) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public FileImpl.NameSortedKey firstKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public FileImpl.NameSortedKey lastKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size > 0;
        }

        @Override
        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmMacro> get(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmMacro> put(FileImpl.NameSortedKey nameSortedKey, CsmUID<CsmMacro> csmUID) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmMacro> remove(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putAll(Map<? extends FileImpl.NameSortedKey, ? extends CsmUID<CsmMacro>> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<FileImpl.NameSortedKey> keySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<CsmUID<CsmMacro>> values() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Map.Entry<FileImpl.NameSortedKey, CsmUID<CsmMacro>>> entrySet() {
            return new Set<Map.Entry<FileImpl.NameSortedKey, CsmUID<CsmMacro>>>(){

                @Override
                public int size() {
                    return HelperMacrosSortedMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperMacrosSortedMap.this.size > 0;
                }

                @Override
                public boolean contains(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Iterator<Map.Entry<FileImpl.NameSortedKey, CsmUID<CsmMacro>>> iterator() {
                    return new Iterator<Map.Entry<FileImpl.NameSortedKey, CsmUID<CsmMacro>>>(){
                        private int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperMacrosSortedMap.this.size;
                        }

                        @Override
                        public Map.Entry<FileImpl.NameSortedKey, CsmUID<CsmMacro>> next() {
                            if (this.current < HelperMacrosSortedMap.this.size) {
                                ++this.current;
                                try {
                                    final FileImpl.NameSortedKey nameSortedKey = new FileImpl.NameSortedKey(HelperMacrosSortedMap.this.aStream);
                                    assert (nameSortedKey != null);
                                    final CsmUID csmUID = HelperMacrosSortedMap.this.factory.readUID(HelperMacrosSortedMap.this.aStream);
                                    assert (csmUID != null);
                                    return new Map.Entry<FileImpl.NameSortedKey, CsmUID<CsmMacro>>(){

                                        @Override
                                        public FileImpl.NameSortedKey getKey() {
                                            return nameSortedKey;
                                        }

                                        @Override
                                        public CsmUID<CsmMacro> getValue() {
                                            return csmUID;
                                        }

                                        @Override
                                        public CsmUID<CsmMacro> setValue(CsmUID<CsmMacro> csmUID2) {
                                            throw new UnsupportedOperationException("Not supported yet.");
                                        }
                                    };
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                            return null;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public <T> T[] toArray(T[] TArray) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean add(Map.Entry<FileImpl.NameSortedKey, CsmUID<CsmMacro>> entry) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean remove(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean containsAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<FileImpl.NameSortedKey, CsmUID<CsmMacro>>> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean retainAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean removeAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HelperDeclarationsSortedMap
    implements SortedMap<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> {
        private final DataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperDeclarationsSortedMap(UIDObjectFactory uIDObjectFactory, DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
            this.size = dataInput.readInt();
            this.aStream = dataInput;
            this.factory = uIDObjectFactory;
            this.manager = aPTStringManager;
        }

        @Override
        public Comparator<? super FileImpl.OffsetSortedKey> comparator() {
            return OSKComparator;
        }

        @Override
        public SortedMap<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> subMap(FileImpl.OffsetSortedKey offsetSortedKey, FileImpl.OffsetSortedKey offsetSortedKey2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> headMap(FileImpl.OffsetSortedKey offsetSortedKey) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SortedMap<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> tailMap(FileImpl.OffsetSortedKey offsetSortedKey) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public FileImpl.OffsetSortedKey firstKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public FileImpl.OffsetSortedKey lastKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmOffsetableDeclaration> get(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmOffsetableDeclaration> put(FileImpl.OffsetSortedKey offsetSortedKey, CsmUID<CsmOffsetableDeclaration> csmUID) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CsmUID<CsmOffsetableDeclaration> remove(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putAll(Map<? extends FileImpl.OffsetSortedKey, ? extends CsmUID<CsmOffsetableDeclaration>> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<FileImpl.OffsetSortedKey> keySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<CsmUID<CsmOffsetableDeclaration>> values() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Map.Entry<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>> entrySet() {
            return new Set<Map.Entry<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>>(){

                @Override
                public int size() {
                    return HelperDeclarationsSortedMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperDeclarationsSortedMap.this.size == 0;
                }

                @Override
                public boolean contains(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Iterator<Map.Entry<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>> iterator() {
                    return new Iterator<Map.Entry<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>>(){
                        private int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperDeclarationsSortedMap.this.size;
                        }

                        @Override
                        public Map.Entry<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> next() {
                            if (this.current < HelperDeclarationsSortedMap.this.size) {
                                ++this.current;
                                try {
                                    final FileImpl.OffsetSortedKey offsetSortedKey = new FileImpl.OffsetSortedKey(HelperDeclarationsSortedMap.this.aStream);
                                    assert (offsetSortedKey != null);
                                    final CsmUID csmUID = HelperDeclarationsSortedMap.this.factory.readUID(HelperDeclarationsSortedMap.this.aStream);
                                    assert (csmUID != null);
                                    return new Map.Entry<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>(){

                                        @Override
                                        public FileImpl.OffsetSortedKey getKey() {
                                            return offsetSortedKey;
                                        }

                                        @Override
                                        public CsmUID<CsmOffsetableDeclaration> getValue() {
                                            return csmUID;
                                        }

                                        @Override
                                        public CsmUID<CsmOffsetableDeclaration> setValue(CsmUID<CsmOffsetableDeclaration> csmUID2) {
                                            throw new UnsupportedOperationException("Not supported yet.");
                                        }
                                    };
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                            return null;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public <T> T[] toArray(T[] TArray) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean add(Map.Entry<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> entry) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean remove(Object object) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean containsAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<FileImpl.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean retainAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public boolean removeAll(Collection<?> collection) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
    }
}

