/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IncludeHierarchyResolverImpl
extends CsmIncludeHierarchyResolver {
    public Collection<CsmFile> getFiles(CsmFile csmFile) {
        CsmProject csmProject = csmFile.getProject();
        if (csmProject instanceof ProjectBase) {
            return this.getReferences((ProjectBase)csmProject, csmFile);
        }
        return Collections.emptyList();
    }

    public Collection<CsmReference> getIncludes(CsmFile csmFile) {
        CsmProject csmProject = csmFile.getProject();
        if (csmProject instanceof ProjectBase) {
            ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
            for (CsmFile csmFile2 : this.getReferences((ProjectBase)csmProject, csmFile)) {
                for (CsmInclude csmInclude : csmFile2.getIncludes()) {
                    if (!csmFile.equals(csmInclude.getIncludeFile())) continue;
                    arrayList.add(CsmReferenceSupport.createObjectReference((CsmObject)csmInclude.getIncludeFile(), (CsmOffsetable)csmInclude));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private Collection<CsmFile> getReferences(ProjectBase projectBase, CsmFile csmFile) {
        Set<CsmFile> set = projectBase.getGraph().getInLinks(csmFile);
        for (ProjectBase projectBase2 : projectBase.getDependentProjects()) {
            set.addAll(projectBase2.getGraph().getInLinks(csmFile));
        }
        return set;
    }
}

