/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.modelimpl");
    private static final int LOG_LEVEL = Integer.getInteger("org.netbeans.modules.cnd.modelimpl.level", -1);

    private Utils() {
    }

    public static CsmOffsetable createOffsetable(CsmFile csmFile, int n, int n2) {
        return new OffsetableBase(csmFile, n, n2);
    }

    public static String getQualifiedName(String string, CsmNamespace csmNamespace) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (csmNamespace != null && !csmNamespace.isGlobal()) {
            stringBuilder.insert(0, "::");
            stringBuilder.insert(0, csmNamespace.getQualifiedName());
        }
        return stringBuilder.toString();
    }

    public static CharSequence[] splitQualifiedName(String string) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ": \t\n\r\f", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(NameCache.getManager().getString((CharSequence)stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new CharSequence[arrayList.size()]);
    }

    public static void disposeAll(Collection<? extends CsmObject> collection) {
        for (CsmObject csmObject : collection) {
            if (csmObject instanceof Disposable) {
                Disposable disposable = (Disposable)csmObject;
                if (TraceFlags.TRACE_DISPOSE) {
                    System.err.println("disposing with UID " + ((CsmIdentifiable)csmObject).getUID());
                }
                disposable.dispose();
                continue;
            }
            if (!TraceFlags.TRACE_DISPOSE) continue;
            System.err.println("non disposable with UID " + ((CsmIdentifiable)csmObject).getUID());
        }
    }

    public static void setSelfUID(CsmObject csmObject) {
        if (!(csmObject instanceof OffsetableIdentifiableBase)) {
            throw new IllegalArgumentException("unexpected object:" + csmObject);
        }
        ((OffsetableIdentifiableBase)csmObject).setSelfUID();
    }

    public static String getCsmIncludeKindKey() {
        return "I";
    }

    public static String getCsmParamListKindKey() {
        return "P";
    }

    public static CharSequence[] getAllClassifiersUniqueNames(CharSequence charSequence) {
        CharSequence charSequence2 = charSequence.subSequence(1, charSequence.length());
        CharSequence[] charSequenceArray = new CharSequence[]{Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.CLASS) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.STRUCT) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.UNION) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.ENUM) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.TYPEDEF) + charSequence2, Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION) + charSequence2};
        return charSequenceArray;
    }

    public static String getCsmDeclarationKindkey(CsmDeclaration.Kind kind) {
        switch (kind) {
            case ASM: {
                return "A";
            }
            case BUILT_IN: {
                return "B";
            }
            case CLASS: {
                return "C";
            }
            case ENUM: {
                return "E";
            }
            case FUNCTION: {
                return "F";
            }
            case MACRO: {
                return "M";
            }
            case NAMESPACE_DEFINITION: {
                return "N";
            }
            case STRUCT: {
                return "S";
            }
            case TEMPLATE_DECLARATION: {
                return "T";
            }
            case UNION: {
                return "U";
            }
            case VARIABLE: {
                return "V";
            }
            case NAMESPACE_ALIAS: {
                return "a";
            }
            case ENUMERATOR: {
                return "e";
            }
            case FUNCTION_DEFINITION: {
                return "f";
            }
            case USING_DIRECTIVE: {
                return "g";
            }
            case TEMPLATE_PARAMETER: {
                return "p";
            }
            case CLASS_FRIEND_DECLARATION: {
                return "r";
            }
            case TEMPLATE_SPECIALIZATION: {
                return "s";
            }
            case TYPEDEF: {
                return "t";
            }
            case USING_DECLARATION: {
                return "u";
            }
            case VARIABLE_DEFINITION: {
                return "v";
            }
            case CLASS_FORWARD_DECLARATION: {
                return "w";
            }
            case FUNCTION_FRIEND: {
                return "D";
            }
            case FUNCTION_FRIEND_DEFINITION: {
                return "d";
            }
        }
        throw new IllegalArgumentException("Unexpected value of CsmDeclaration.Kind:" + kind);
    }

    public static CsmDeclaration.Kind getCsmDeclarationKind(char c) {
        switch (c) {
            case 'A': {
                return CsmDeclaration.Kind.ASM;
            }
            case 'B': {
                return CsmDeclaration.Kind.BUILT_IN;
            }
            case 'C': {
                return CsmDeclaration.Kind.CLASS;
            }
            case 'E': {
                return CsmDeclaration.Kind.ENUM;
            }
            case 'F': {
                return CsmDeclaration.Kind.FUNCTION;
            }
            case 'M': {
                return CsmDeclaration.Kind.MACRO;
            }
            case 'N': {
                return CsmDeclaration.Kind.NAMESPACE_DEFINITION;
            }
            case 'S': {
                return CsmDeclaration.Kind.STRUCT;
            }
            case 'T': {
                return CsmDeclaration.Kind.TEMPLATE_DECLARATION;
            }
            case 'U': {
                return CsmDeclaration.Kind.UNION;
            }
            case 'V': {
                return CsmDeclaration.Kind.VARIABLE;
            }
            case 'a': {
                return CsmDeclaration.Kind.NAMESPACE_ALIAS;
            }
            case 'e': {
                return CsmDeclaration.Kind.ENUMERATOR;
            }
            case 'f': {
                return CsmDeclaration.Kind.FUNCTION_DEFINITION;
            }
            case 'g': {
                return CsmDeclaration.Kind.USING_DIRECTIVE;
            }
            case 'p': {
                return CsmDeclaration.Kind.TEMPLATE_PARAMETER;
            }
            case 'r': {
                return CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION;
            }
            case 's': {
                return CsmDeclaration.Kind.TEMPLATE_SPECIALIZATION;
            }
            case 't': {
                return CsmDeclaration.Kind.TYPEDEF;
            }
            case 'u': {
                return CsmDeclaration.Kind.USING_DECLARATION;
            }
            case 'v': {
                return CsmDeclaration.Kind.VARIABLE_DEFINITION;
            }
            case 'w': {
                return CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION;
            }
            case 'D': {
                return CsmDeclaration.Kind.FUNCTION_FRIEND;
            }
            case 'd': {
                return CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION;
            }
        }
        throw new IllegalArgumentException("Unexpected char for CsmDeclaration.Kind: " + c);
    }

    static {
        if (LOG_LEVEL == -1) {
            if (TraceFlags.DEBUG) {
                LOG.setLevel(Level.ALL);
            } else {
                LOG.setLevel(Level.SEVERE);
            }
        }
    }
}

