/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeFileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectImpl
extends ProjectBase {
    private final Set<CsmFile> editedFiles = new HashSet<CsmFile>();
    private final NativeFileContainer nativeFiles = new NativeFileContainer();
    private RequestProcessor.Task task = null;

    private ProjectImpl(ModelImpl modelImpl, Object object, String string) {
        super(modelImpl, object, string);
    }

    public static ProjectImpl createInstance(ModelImpl modelImpl, String string, String string2) {
        return ProjectImpl.createInstance(modelImpl, (Object)string, string2);
    }

    public static ProjectImpl createInstance(ModelImpl modelImpl, NativeProject nativeProject, String string) {
        return ProjectImpl.createInstance(modelImpl, (Object)nativeProject, string);
    }

    private static ProjectImpl createInstance(ModelImpl modelImpl, Object object, String string) {
        ProjectBase projectBase = null;
        if (TraceFlags.PERSISTENT_REPOSITORY) {
            try {
                projectBase = ProjectImpl.readInstance(modelImpl, object, string);
            }
            catch (Exception exception) {
                ProjectImpl.cleanRepository(object, false);
                DiagnosticExceptoins.register(exception);
            }
        }
        if (projectBase == null) {
            projectBase = new ProjectImpl(modelImpl, object, string);
        }
        return (ProjectImpl)projectBase;
    }

    @Override
    protected final ParserQueue.Position getIncludedFileParserQueuePosition() {
        return ParserQueue.Position.HEAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileEditStart(final FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
        FileImpl fileImpl;
        if (!this.acceptNativeItem(nativeFileItem)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditSTART " + fileBuffer.getFile().getName());
        }
        if ((fileImpl = this.createOrFindFileImpl(fileBuffer, nativeFileItem)) != null) {
            fileImpl.setBuffer(fileBuffer);
            Set<CsmFile> set = this.editedFiles;
            synchronized (set) {
                this.editedFiles.add(fileImpl);
            }
            APTDriver.getInstance().invalidateAPT((APTFileBuffer)fileBuffer);
            APTFileCacheManager.invalidate((APTFileBuffer)fileBuffer);
            this.schedule(fileBuffer, fileImpl);
            fileBuffer.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    ProjectImpl.this.schedule(fileBuffer, fileImpl);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileEditEnd(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
        FileImpl fileImpl;
        if (!this.acceptNativeItem(nativeFileItem)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditEND " + fileBuffer.getFile().getName());
        }
        if ((fileImpl = this.getFile(fileBuffer.getFile(), false)) != null) {
            Set<CsmFile> set = this.editedFiles;
            synchronized (set) {
                if (!this.editedFiles.remove(fileImpl)) {
                    return;
                }
            }
            fileImpl.setBuffer(fileBuffer);
        }
    }

    private void addToQueue(FileBuffer fileBuffer, FileImpl fileImpl) {
        if (this.isDisposing()) {
            return;
        }
        try {
            fileImpl.scheduleParsing(true);
        }
        catch (InterruptedException interruptedException) {
            DiagnosticExceptoins.register(interruptedException);
        }
    }

    @Override
    public void onFilePropertyChanged(NativeFileItem nativeFileItem) {
        if (!this.acceptNativeItem(nativeFileItem)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFilePropertyChanged " + nativeFileItem.getFile().getName());
        }
        DeepReparsingUtils.reparseOnPropertyChanged(nativeFileItem, (ProjectBase)this);
    }

    @Override
    public void onFilePropertyChanged(List<NativeFileItem> list) {
        if (list.size() > 0) {
            DeepReparsingUtils.reparseOnPropertyChanged(list, (ProjectBase)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileRemoved(FileImpl fileImpl) {
        try {
            this.onFileRemovedImpl(fileImpl);
            if (fileImpl != null) {
                DeepReparsingUtils.reparseOnRemoved(fileImpl, (ProjectBase)this);
            }
        }
        finally {
            Notificator.instance().flush();
        }
    }

    @Override
    public void onFileImplRemoved(List<FileImpl> list) {
        for (FileImpl fileImpl : list) {
            this.onFileRemovedImpl(fileImpl);
        }
        DeepReparsingUtils.reparseOnRemoved(list, (ProjectBase)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileImpl onFileRemovedImpl(FileImpl fileImpl) {
        CndFileUtils.clearFileExistenceCache();
        if (fileImpl != null) {
            Set<CsmFile> set = this.editedFiles;
            synchronized (set) {
                this.editedFiles.remove(fileImpl);
            }
            this.removeNativeFileItem(fileImpl.getUID());
            fileImpl.dispose();
            this.removeFile(fileImpl.getAbsolutePath());
            APTDriver.getInstance().invalidateAPT((APTFileBuffer)fileImpl.getBuffer());
            APTFileCacheManager.invalidate((APTFileBuffer)fileImpl.getBuffer());
            ParserQueue.instance().remove(fileImpl);
        }
        return fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileRemoved(List<NativeFileItem> list) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            ArrayList<FileImpl> arrayList = new ArrayList<FileImpl>();
            for (NativeFileItem nativeFileItem : list) {
                File file = nativeFileItem.getFile();
                try {
                    FileImpl fileImpl = this.getFile(file, false);
                    if (fileImpl == null) continue;
                    this.onFileRemovedImpl(fileImpl);
                    arrayList.add(fileImpl);
                }
                finally {
                    Notificator.instance().flush();
                }
            }
            DeepReparsingUtils.reparseOnRemoved(arrayList, (ProjectBase)this);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    @Override
    public void onFileAdded(NativeFileItem nativeFileItem) {
        this.onFileAddedImpl(nativeFileItem, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeFileItem onFileAddedImpl(NativeFileItem nativeFileItem, boolean bl) {
        if (this.acceptNativeItem(nativeFileItem)) {
            CndFileUtils.clearFileExistenceCache();
            try {
                this.createIfNeed(nativeFileItem, this.isSourceFile(nativeFileItem));
                NativeFileItem nativeFileItem2 = nativeFileItem;
                return nativeFileItem2;
            }
            finally {
                Notificator.instance().flush();
                if (bl) {
                    DeepReparsingUtils.reparseOnAdded(nativeFileItem, (ProjectBase)this);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileAdded(List<NativeFileItem> list) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
            for (NativeFileItem nativeFileItem : list) {
                NativeFileItem nativeFileItem2 = this.onFileAddedImpl(nativeFileItem, false);
                if (nativeFileItem2 == null) continue;
                arrayList.add(nativeFileItem2);
            }
            DeepReparsingUtils.reparseOnAdded(arrayList, (ProjectBase)this);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureChangedFilesEnqueued() {
        Set<CsmFile> set = this.editedFiles;
        synchronized (set) {
            super.ensureChangedFilesEnqueued();
            for (FileImpl fileImpl : this.editedFiles) {
                if (fileImpl.isParsingOrParsed()) continue;
                ParserQueue.instance().add(fileImpl, this.getPreprocHandler(fileImpl.getBuffer().getFile()).getState(), ParserQueue.Position.TAIL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasChangedFiles(CsmFile csmFile) {
        if (csmFile == null) {
            return false;
        }
        Set<CsmFile> set = this.editedFiles;
        synchronized (set) {
            for (FileImpl fileImpl : this.editedFiles) {
                if (csmFile == fileImpl || fileImpl.isParsingOrParsed()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ProjectBase findFileProject(CharSequence charSequence) {
        ProjectBase projectBase = super.findFileProject(charSequence);
        if (projectBase == null && ParserThreadManager.instance().isStandalone()) {
            projectBase = ((Object)charSequence).toString().startsWith("/usr") ? projectBase : this;
        }
        return projectBase;
    }

    public boolean isArtificial() {
        return false;
    }

    @Override
    public NativeFileItem getNativeFileItem(CsmUID<CsmFile> csmUID) {
        return this.nativeFiles.getNativeFileItem(csmUID);
    }

    @Override
    protected void putNativeFileItem(CsmUID<CsmFile> csmUID, NativeFileItem nativeFileItem) {
        this.nativeFiles.putNativeFileItem(csmUID, nativeFileItem);
    }

    @Override
    protected void removeNativeFileItem(CsmUID<CsmFile> csmUID) {
        this.nativeFiles.removeNativeFileItem(csmUID);
    }

    @Override
    protected void clearNativeFileContainer() {
        this.nativeFiles.clear();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        LibraryManager.getInstance().writeProjectLibraries(this.getUID(), dataOutput);
    }

    public ProjectImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        LibraryManager.getInstance().readProjectLibraries(this.getUID(), dataInput);
    }

    public synchronized void schedule(final FileBuffer fileBuffer, final FileImpl fileImpl) {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                try {
                    ProjectImpl.this.addToQueue(fileBuffer, fileImpl);
                }
                catch (AssertionError assertionError) {
                    DiagnosticExceptoins.register((Throwable)((Object)assertionError));
                }
                catch (Exception exception) {
                    DiagnosticExceptoins.register(exception);
                }
            }
        }, true);
        this.task.setPriority(1);
        int n = TraceFlags.REPARSE_DELAY;
        boolean bl = NamedEntityOptions.instance().isEnabled(new NamedEntity(){

            public String getName() {
                return "reparse-on-document-changed";
            }

            public boolean isEnabledByDefault() {
                return true;
            }
        });
        if (bl) {
            if (fileImpl.getLastParseTime() / (n + 1) > 2) {
                n = Math.max(n, fileImpl.getLastParseTime() + 2000);
            }
        } else {
            n = Integer.MAX_VALUE;
        }
        this.task.schedule(n);
    }

    @Override
    public void setDisposed() {
        super.setDisposed();
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

