/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.util.WeakList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseFinishNotificator {
    private static final ParseFinishNotificator instance = new ParseFinishNotificator();
    private final WeakList<CsmProject> waitingProjects = new WeakList();

    private ParseFinishNotificator() {
    }

    public static ParseFinishNotificator instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onParseFinish(CsmProject csmProject) {
        ParseFinishNotificator parseFinishNotificator = instance;
        synchronized (parseFinishNotificator) {
            ParseFinishNotificator.instance.waitingProjects.remove(csmProject);
            if (ParseFinishNotificator.areProjectAndLibsParsed(csmProject)) {
                if (csmProject instanceof ProjectBase) {
                    ((ProjectBase)csmProject).onLibParseFinish();
                }
                for (CsmProject csmProject2 : ParseFinishNotificator.instance.waitingProjects) {
                    if (!ParseFinishNotificator.isProjectsLib(csmProject2, csmProject) || !ParseFinishNotificator.areProjectAndLibsParsed(csmProject2) || !(csmProject2 instanceof ProjectBase)) continue;
                    ParseFinishNotificator.instance.waitingProjects.remove(csmProject2);
                    ((ProjectBase)csmProject2).onLibParseFinish();
                }
            } else if (csmProject.isStable(null)) {
                ParseFinishNotificator.instance.waitingProjects.add(csmProject);
            }
        }
    }

    private static boolean isProjectsLib(CsmProject csmProject, CsmProject csmProject2) {
        if (csmProject.equals(csmProject2)) {
            return false;
        }
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        hashSet.add(csmProject);
        return ParseFinishNotificator.isProjectInLibs(csmProject2, csmProject.getLibraries(), hashSet);
    }

    private static boolean isProjectInLibs(CsmProject csmProject, Collection<CsmProject> collection, Collection<CsmProject> collection2) {
        if (collection != null) {
            for (CsmProject csmProject2 : collection) {
                if (collection2.contains(csmProject2)) continue;
                collection2.add(csmProject2);
                if (!csmProject.equals(csmProject2) && !ParseFinishNotificator.isProjectInLibs(csmProject, csmProject2.getLibraries(), collection2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean areProjectAndLibsParsed(CsmProject csmProject) {
        if (!csmProject.isStable(null)) {
            return false;
        }
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        hashSet.add(csmProject);
        return ParseFinishNotificator.areProjectLibsParsed(csmProject.getLibraries(), hashSet);
    }

    private static boolean areProjectLibsParsed(Collection<CsmProject> collection, Collection<CsmProject> collection2) {
        if (collection != null) {
            for (CsmProject csmProject : collection) {
                if (collection2.contains(csmProject)) continue;
                collection2.add(csmProject);
                if (csmProject.isStable(null) && ParseFinishNotificator.areProjectLibsParsed(csmProject.getLibraries(), collection2)) continue;
                return false;
            }
        }
        return true;
    }
}

