/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionDefinitionImpl<T>
extends FunctionImplEx<T>
implements CsmFunctionDefinition {
    private CsmUID<CsmFunction> declarationUID;
    private final CsmCompoundStatement body;
    private int parseCount;

    public FunctionDefinitionImpl(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl, boolean bl2) throws AstRendererException {
        super(aST, csmFile, csmScope, false, bl2);
        this.body = AstRenderer.findCompoundStatement(aST, this.getContainingFile(), this);
        if (this.body == null) {
            throw new AstRendererException((FileImpl)csmFile, this.getStartOffset(), "Null body in function definition.");
        }
        if (bl) {
            this.registerInProject();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.body instanceof Disposable) {
            ((Disposable)this.body).dispose();
        }
    }

    @Override
    public CsmCompoundStatement getBody() {
        return this.body;
    }

    @Override
    public CsmFunction getDeclaration() {
        return this.getDeclaration(null);
    }

    public CsmFunction getDeclaration(Resolver resolver) {
        CsmFunction csmFunction = this._getDeclaration();
        if (csmFunction == null || FunctionDefinitionImpl.isFakeFunction(csmFunction)) {
            int n = FileImpl.getParseCount();
            if (n == this.parseCount) {
                return null;
            }
            this._setDeclaration(null);
            csmFunction = this.findDeclaration(resolver);
            this._setDeclaration(csmFunction);
            this.parseCount = n;
        }
        return csmFunction;
    }

    private CsmFunction _getDeclaration() {
        CsmFunction csmFunction = UIDCsmConverter.UIDtoDeclaration(this.declarationUID);
        return csmFunction;
    }

    private void _setDeclaration(CsmFunction csmFunction) {
        this.declarationUID = UIDCsmConverter.declarationToUID(csmFunction);
        assert (this.declarationUID != null || csmFunction == null);
    }

    private CsmDeclaration fixCastOperator(CsmClass csmClass) {
        CsmMember csmMember = null;
        String string = ((Object)this.getName()).toString();
        int n = string.lastIndexOf("::");
        if (n > 0) {
            string = "operator  " + string.substring(n + 2);
        }
        Iterator iterator = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter((CharSequence)"operator", false, true, false));
        while (iterator.hasNext()) {
            CsmMember csmMember2 = (CsmMember)iterator.next();
            String string2 = ((Object)csmMember2.getName()).toString();
            int n2 = string2.lastIndexOf("::");
            if (n2 > 0) {
                string2 = "operator  " + string2.substring(n2 + 2);
            }
            if (!string.equals(string2)) continue;
            if (csmMember == null) {
                csmMember = csmMember2;
                continue;
            }
            csmMember = null;
            break;
        }
        return csmMember;
    }

    private CsmFunction findDeclaration(Resolver resolver) {
        String string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION) + ':' + this.getUniqueNameWithoutPrefix();
        Collection collection = this.getContainingFile().getProject().findDeclarations((CharSequence)string);
        if (collection.isEmpty()) {
            string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND) + ':' + this.getUniqueNameWithoutPrefix();
            collection = this.getContainingFile().getProject().findDeclarations((CharSequence)string);
        }
        CsmFunction csmFunction = null;
        if (collection.isEmpty()) {
            CsmObject csmObject = this.findOwner(resolver);
            if (csmObject == null) {
                csmObject = CsmBaseUtilities.getFunctionClassByQualifiedName((CsmFunction)this);
            }
            if (csmObject instanceof CsmClass) {
                Iterator iterator = CsmSelect.getClassMembers((CsmClass)((CsmClass)csmObject), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false));
                csmFunction = FunctionDefinitionImpl.findByName(iterator, this.getName());
                if (csmFunction == null && this.isOperator()) {
                    csmFunction = this.fixCastOperator((CsmClass)csmObject);
                }
            } else if (csmObject instanceof CsmNamespace) {
                Iterator iterator = CsmSelect.getDeclarations((CsmNamespace)((CsmNamespace)csmObject), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false));
                csmFunction = FunctionDefinitionImpl.findByName(iterator, this.getName());
            }
        } else {
            csmFunction = FunctionDefinitionImpl.findByName(collection.iterator(), this.getName());
        }
        return csmFunction;
    }

    private static CsmFunction findByName(Iterator iterator, CharSequence charSequence) {
        CsmFunction csmFunction = null;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            CsmFunction csmFunction2;
            Object e = iterator2.next();
            if (!CsmKindUtilities.isCsmObject(e) || !CsmKindUtilities.isFunction((CsmObject)((CsmObject)e)) || !(csmFunction2 = (CsmFunction)e).getName().equals(charSequence)) continue;
            csmFunction = csmFunction2;
            if (FunctionDefinitionImpl.isFakeFunction(csmFunction2)) continue;
            break;
        }
        return csmFunction;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    @Override
    protected String findQualifiedName() {
        CsmFunction csmFunction = this._getDeclaration();
        if (csmFunction != null) {
            return ((Object)csmFunction.getQualifiedName()).toString();
        }
        return super.findQualifiedName();
    }

    @Override
    public CsmScope getScope() {
        return this.getContainingFile();
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> collection = super.getScopeElements();
        collection.add((CsmScopeElement)this.getBody());
        return collection;
    }

    @Override
    public CsmFunctionDefinition getDefinition() {
        return this;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeCompoundStatement(this.body, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.declarationUID, dataOutput);
    }

    public FunctionDefinitionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.body = PersistentUtils.readCompoundStatement(dataInput);
        this.declarationUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }

    private static boolean isFakeFunction(CsmFunction csmFunction) {
        return csmFunction instanceof FunctionImplEx;
    }
}

