/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.options;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.groovy.support.options.Model;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class GroovyPanel
extends JPanel {
    JTabbedPane tabbedPanel;
    private LookupListener listener = new LookupListenerImpl();
    private Model model = new Model(this.listener);
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            GroovyPanel.this.handleTabSwitched();
        }
    };

    GroovyPanel() {
    }

    public void update() {
        String string = this.tabbedPanel.getTitleAt(this.tabbedPanel.getSelectedIndex());
        this.model.update(string);
    }

    public void applyChanges() {
        this.model.applyChanges();
    }

    public void cancel() {
        this.model.cancel();
    }

    public HelpCtx getHelpCtx() {
        return this.model.getHelpCtx(this.tabbedPanel != null ? (JComponent)this.tabbedPanel.getSelectedComponent() : null);
    }

    public boolean dataValid() {
        return this.model.isValid();
    }

    public boolean isChanged() {
        return this.model.isChanged();
    }

    public Lookup getLookup() {
        return this.model.getLookup();
    }

    void init(Lookup lookup) {
        this.tabbedPanel = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPanel, "Center");
        this.initTabbedPane(lookup);
    }

    private void initTabbedPane(Lookup lookup) {
        this.tabbedPanel.removeChangeListener(this.changeListener);
        this.tabbedPanel.removeAll();
        for (String string : this.model.getCategories()) {
            this.tabbedPanel.addTab(string, new JLabel(string));
        }
        this.tabbedPanel.addChangeListener(this.changeListener);
        this.handleTabSwitched();
    }

    private void handleTabSwitched() {
        int n = this.tabbedPanel.getSelectedIndex() >= 0 ? this.tabbedPanel.getSelectedIndex() : 0;
        String string = this.tabbedPanel.getTitleAt(n);
        if (this.tabbedPanel.getSelectedComponent() instanceof JLabel) {
            this.tabbedPanel.setComponentAt(this.tabbedPanel.getSelectedIndex(), this.model.getPanel(string));
            ((JComponent)this.tabbedPanel.getSelectedComponent()).setBorder(new EmptyBorder(11, 11, 11, 11));
        }
        this.model.update(string);
        this.firePropertyChange("helpCtx", null, null);
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Lookup lookup = GroovyPanel.this.model.getLookup();
            GroovyPanel.this.model = new Model(GroovyPanel.this.listener);
            GroovyPanel.this.initTabbedPane(lookup);
        }
    }
}

