/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupport;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupportEvent;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupportListener;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathRootsListener
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ClassPathRootsListener.class.getName());
    private static ClassPathRootsListener INSTANCE;
    final Map<ClassPath, Collection<ClassPathRootsChangedListener>> cp2Listeners = new WeakHashMap<ClassPath, Collection<ClassPathRootsChangedListener>>();
    final Map<ClassPath, Set<File>> classPath2Roots = new WeakHashMap<ClassPath, Set<File>>();
    final Map<ClassPath, Boolean> classPath2Translate = new WeakHashMap<ClassPath, Boolean>();
    final Map<ClassPath.Entry, File> entry2File = new WeakHashMap<ClassPath.Entry, File>();
    final Map<ClassPath.Entry, FileChangeSupportListener> entry2Listener = new WeakHashMap<ClassPath.Entry, FileChangeSupportListener>();
    final Map<File, Reference<FileChangeSupportListener>> file2Listener = new WeakHashMap<File, Reference<FileChangeSupportListener>>();
    final Map<File, Set<ClassPath>> file2ClassPaths = new WeakHashMap<File, Set<ClassPath>>();
    final Map<File, Reference<File>> fileNormalizationFacility = new WeakHashMap<File, Reference<File>>();
    private static final ClassPath EMPTY_CLASSPATH;

    public static synchronized ClassPathRootsListener getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new ClassPathRootsListener();
        }
        return INSTANCE;
    }

    public void addClassPathRootsListener(final ClassPath classPath, final boolean bl, final ClassPathRootsChangedListener classPathRootsChangedListener) {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                ClassPathRootsListener.this.addClassPathRootsListenerImpl(classPath, bl, classPathRootsChangedListener);
                return null;
            }
        });
    }

    private synchronized void addClassPathRootsListenerImpl(ClassPath classPath, boolean bl, ClassPathRootsChangedListener classPathRootsChangedListener) {
        Collection<ClassPathRootsChangedListener> collection = this.cp2Listeners.get(classPath);
        if (collection == null) {
            collection = new HashSet<ClassPathRootsChangedListener>();
            this.cp2Listeners.put(classPath, collection);
            classPath.addPropertyChangeListener((PropertyChangeListener)this);
        }
        collection.add(classPathRootsChangedListener);
        this.classPath2Translate.put(classPath, bl);
        this.handleClassPath(classPath);
    }

    private synchronized void handleClassPath(ClassPath classPath) {
        Reference<File> reference;
        Reference<FileChangeSupportListener> reference2;
        Set<ClassPath> set;
        Set<File> set2 = this.classPath2Roots.get(classPath);
        set2 = set2 != null ? new HashSet<File>(set2) : Collections.emptySet();
        HashMap<URL, ClassPath.Entry> hashMap = new HashMap<URL, ClassPath.Entry>();
        for (ClassPath.Entry object : classPath.entries()) {
            hashMap.put(object.getURL(), object);
        }
        ClassPath classPath2 = this.classPath2Translate.get(classPath) == Boolean.TRUE ? ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(ClasspathInfo.create(EMPTY_CLASSPATH, classPath, EMPTY_CLASSPATH), ClasspathInfo.PathKind.COMPILE) : classPath;
        for (ClassPath.Entry entry : classPath2.entries()) {
            WeakSet weakSet;
            FileChangeSupportListener fileChangeSupportListener;
            File file;
            set = entry.getURL();
            ClassPath.Entry entry2 = (ClassPath.Entry)hashMap.get(set);
            if (entry2 == null) continue;
            reference2 = ClassPathRootsListener.fileForURL((URL)((Object)set));
            reference = this.fileNormalizationFacility.get(reference2);
            File file2 = file = reference != null ? reference.get() : null;
            if (file == null) {
                this.fileNormalizationFacility.put((File)((Object)reference2), new WeakReference<Object>(reference2));
            } else {
                reference2 = file;
            }
            if (reference2 == null) continue;
            this.entry2File.put(entry2, (File)((Object)reference2));
            Reference<FileChangeSupportListener> reference3 = this.file2Listener.get(reference2);
            FileChangeSupportListener fileChangeSupportListener2 = fileChangeSupportListener = reference3 != null ? reference3.get() : null;
            if (fileChangeSupportListener == null) {
                fileChangeSupportListener = new FileChangeSupportListener(){

                    public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
                        LOGGER.log(Level.FINE, "file created: {0}", fileChangeSupportEvent.getPath());
                        this.fileChanged(fileChangeSupportEvent.getPath());
                    }

                    public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
                        LOGGER.log(Level.FINE, "file deleted: {0}", fileChangeSupportEvent.getPath());
                        this.fileChanged(fileChangeSupportEvent.getPath());
                    }

                    public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
                        LOGGER.log(Level.FINE, "file modified: {0}", fileChangeSupportEvent.getPath());
                        this.fileChanged(fileChangeSupportEvent.getPath());
                    }

                    private void fileChanged(File file) {
                        try {
                            CachingArchiveProvider.getDefault().clearArchive(file.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                        }
                        Collection collection = ClassPathRootsListener.this.file2ClassPaths.get(file);
                        if (collection != null) {
                            ClassPathRootsListener.this.fireRootsChanged(Collections.unmodifiableCollection(new LinkedList(collection)), file);
                        }
                    }
                };
                FileChangeSupport.DEFAULT.addListener(fileChangeSupportListener, (File)((Object)reference2));
                this.file2Listener.put((File)((Object)reference2), new WeakReference<FileChangeSupportListener>(fileChangeSupportListener));
            }
            if ((weakSet = this.file2ClassPaths.get(reference2)) == null) {
                weakSet = new WeakSet();
                this.file2ClassPaths.put((File)((Object)reference2), (Set<ClassPath>)weakSet);
            }
            weakSet.add((ClassPath)classPath);
            WeakSet weakSet2 = this.classPath2Roots.get(classPath);
            if (weakSet2 == null) {
                weakSet2 = new WeakSet();
                this.classPath2Roots.put(classPath, (Set<File>)weakSet2);
            }
            weakSet2.add((File)((Object)reference2));
            this.entry2Listener.put(entry2, fileChangeSupportListener);
            set2.remove(reference2);
        }
        for (File file : set2) {
            set = this.file2ClassPaths.get(file);
            if (set == null) continue;
            set.remove(classPath);
            if (!set.isEmpty()) continue;
            reference2 = this.file2Listener.remove(file);
            Reference<File> reference4 = reference = reference2 != null ? (FileChangeSupportListener)reference2.get() : null;
            if (reference != null) {
                FileChangeSupport.DEFAULT.removeListener((FileChangeSupportListener)((Object)reference), file);
            }
            this.file2ClassPaths.remove(file);
        }
    }

    static File fileForURL(URL uRL) {
        File file = ClassPathRootsListener.fileForURLImpl(uRL);
        if (file == null) {
            return null;
        }
        file = FileUtil.normalizeFile((File)file);
        return file;
    }

    private static File fileForURLImpl(URL uRL) {
        URL uRL2;
        String string = uRL.getProtocol();
        if ("file".equals(string)) {
            return new File(URI.create(uRL.toExternalForm()));
        }
        if ("jar".equals(string) && "file".equals(string = (uRL2 = FileUtil.getArchiveFile((URL)uRL)).getProtocol())) {
            return new File(URI.create(uRL2.toExternalForm()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRootsChanged(Collection<ClassPath> collection, File file) {
        IdentityHashMap<ClassPathRootsChangedListener, Boolean> identityHashMap = new IdentityHashMap<ClassPathRootsChangedListener, Boolean>();
        ClassPathRootsListener classPathRootsListener = this;
        synchronized (classPathRootsListener) {
            for (ClassPath classPath : collection) {
                Collection<ClassPathRootsChangedListener> collection2 = this.cp2Listeners.get(classPath);
                if (identityHashMap == null) continue;
                for (ClassPathRootsChangedListener classPathRootsChangedListener : collection2) {
                    identityHashMap.put(classPathRootsChangedListener, true);
                }
            }
        }
        if (identityHashMap.isEmpty()) {
            return;
        }
        for (Object object : identityHashMap.keySet()) {
            object.rootsChanged(collection, file);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("entries".equals(propertyChangeEvent.getPropertyName())) {
            ClassPath classPath = (ClassPath)propertyChangeEvent.getSource();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "classpath entries changed: cp={0} ({2}), entries={1}", new Object[]{classPath, classPath.entries(), System.identityHashCode(classPath)});
            }
            this.handleClassPath(classPath);
            this.fireRootsChanged(Collections.singleton(classPath), null);
        }
    }

    static {
        EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ClassPathRootsChangedListener {
        public void rootsChanged(Collection<ClassPath> var1, File var2);
    }
}

