/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTaskProvider
extends PushTaskScanner {
    private static final Logger LOG = Logger.getLogger(JavaTaskProvider.class.getName());
    private static JavaTaskProvider INSTANCE;
    private TaskScanningScope scope;
    private PushTaskScanner.Callback callback;
    private static final Set<RequestProcessor.Task> TASKS;
    private static boolean clearing;
    private static final RequestProcessor WORKER;
    private static Map<FileObject, Set<FileObject>> root2FilesWithAttachedErrors;

    public JavaTaskProvider() {
        super(NbBundle.getBundle(JavaTaskProvider.class).getString("LBL_ProviderName"), NbBundle.getBundle(JavaTaskProvider.class).getString("LBL_ProviderDescription"), null);
        INSTANCE = this;
    }

    private synchronized void refreshImpl(FileObject fileObject) {
        LOG.log(Level.FINE, "refresh: {0}", fileObject);
        if (this.scope == null || this.callback == null) {
            return;
        }
        if (!this.scope.isInScope(fileObject)) {
            if (!fileObject.isFolder()) {
                return;
            }
            for (FileObject fileObject2 : this.scope.getLookup().lookupAll(FileObject.class)) {
                if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) continue;
                JavaTaskProvider.enqueue(new Work(fileObject2, this.callback));
            }
            return;
        }
        LOG.log(Level.FINE, "enqueing work for: {0}", fileObject);
        JavaTaskProvider.enqueue(new Work(fileObject, this.callback));
    }

    public static void refresh(FileObject fileObject) {
        if (INSTANCE != null) {
            INSTANCE.refreshImpl(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAll() {
        if (INSTANCE != null) {
            JavaTaskProvider javaTaskProvider = INSTANCE;
            synchronized (javaTaskProvider) {
                INSTANCE.setScope(JavaTaskProvider.INSTANCE.scope, JavaTaskProvider.INSTANCE.callback);
            }
        }
    }

    public synchronized void setScope(TaskScanningScope taskScanningScope, PushTaskScanner.Callback callback) {
        JavaTaskProvider.cancelAllCurrent();
        this.scope = taskScanningScope;
        this.callback = callback;
        if (taskScanningScope == null || callback == null) {
            return;
        }
        for (FileObject fileObject : taskScanningScope.getLookup().lookupAll(FileObject.class)) {
            JavaTaskProvider.enqueue(new Work(fileObject, callback));
        }
        for (FileObject fileObject : taskScanningScope.getLookup().lookupAll(Project.class)) {
            for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)fileObject).getSourceGroups("java")) {
                JavaTaskProvider.enqueue(new Work(sourceGroup.getRootFolder(), callback));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueue(Work work) {
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            RequestProcessor.Task task = WORKER.post((Runnable)work);
            TASKS.add(task);
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(org.openide.util.Task task) {
                    Set set = TASKS;
                    synchronized (set) {
                        if (!clearing) {
                            TASKS.remove(task);
                        }
                    }
                }
            });
            if (task.isFinished()) {
                TASKS.remove(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelAllCurrent() {
        Object object = TASKS;
        synchronized (object) {
            clearing = true;
            try {
                for (RequestProcessor.Task task : TASKS) {
                    task.cancel();
                }
                TASKS.clear();
                Object var4_3 = null;
                clearing = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                clearing = false;
                throw throwable;
            }
        }
        object = JavaTaskProvider.class;
        synchronized (JavaTaskProvider.class) {
            root2FilesWithAttachedErrors.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitWorkFinished() throws Exception {
        while (true) {
            RequestProcessor.Task task = null;
            Set<RequestProcessor.Task> set = TASKS;
            synchronized (set) {
                if (TASKS.isEmpty()) {
                    return;
                }
                task = TASKS.iterator().next();
            }
            task.waitFinished();
        }
    }

    private static Set<FileObject> getFilesWithAttachedErrors(FileObject fileObject) {
        WeakSet weakSet = root2FilesWithAttachedErrors.get(fileObject);
        if (weakSet == null) {
            weakSet = new WeakSet();
            root2FilesWithAttachedErrors.put(fileObject, (Set<FileObject>)weakSet);
        }
        return weakSet;
    }

    private static synchronized void updateErrorsInRoot(PushTaskScanner.Callback callback, FileObject fileObject) {
        Set<FileObject> set = JavaTaskProvider.getFilesWithAttachedErrors(fileObject);
        HashSet<FileObject> hashSet = new HashSet<FileObject>(set);
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        try {
            for (URL uRL : TaskCache.getDefault().getAllFilesWithRecord(fileObject.getURL())) {
                FileObject fileObject2 = URLMapper.findFileObject((URL)uRL);
                if (fileObject2 == null) continue;
                List<Task> list = TaskCache.getDefault().getErrors(fileObject2);
                LOG.log(Level.FINE, "Setting {1} for {0}\n", new Object[]{fileObject2, list});
                callback.setTasks(fileObject2, list);
                if (hashSet.remove(fileObject2)) continue;
                hashSet2.add(fileObject2);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        for (FileObject fileObject3 : hashSet) {
            LOG.log(Level.FINE, "Clearing errors for {0}", fileObject3);
            callback.setTasks(fileObject3, Collections.emptyList());
        }
        set.addAll(hashSet2);
    }

    static {
        TASKS = new HashSet<RequestProcessor.Task>();
        WORKER = new RequestProcessor("Java Task Provider");
        root2FilesWithAttachedErrors = new WeakHashMap<FileObject, Set<FileObject>>();
    }

    private static final class Work
    implements Runnable {
        private FileObject fileOrRoot;
        private PushTaskScanner.Callback callback;

        public Work(FileObject fileObject, PushTaskScanner.Callback callback) {
            this.fileOrRoot = fileObject;
            this.callback = callback;
        }

        public FileObject getFileOrRoot() {
            return this.fileOrRoot;
        }

        public PushTaskScanner.Callback getCallback() {
            return this.callback;
        }

        public void run() {
            FileObject fileObject = this.getFileOrRoot();
            LOG.log(Level.FINE, "dequeued work for: {0}", fileObject);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null) {
                LOG.log(Level.FINE, "cp == null");
                return;
            }
            FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
            if (fileObject2 == null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                LOG.log(Level.WARNING, "file: {0} is not on its own source classpath: {1}, project: {2}", new Object[]{FileUtil.getFileDisplayName((FileObject)fileObject), classPath.toString(ClassPath.PathConversionMode.PRINT), project != null ? project.getClass() : "null"});
                return;
            }
            if (fileObject.isData()) {
                List<Task> list = TaskCache.getDefault().getErrors(fileObject);
                Set set = JavaTaskProvider.getFilesWithAttachedErrors(fileObject2);
                if (list.isEmpty()) {
                    set.remove(fileObject);
                } else {
                    set.add(fileObject);
                }
                LOG.log(Level.FINE, "setting {1} for {0}", new Object[]{fileObject, list});
                this.getCallback().setTasks(fileObject, list);
            } else {
                JavaTaskProvider.updateErrorsInRoot(this.getCallback(), fileObject2);
            }
        }
    }
}

