/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import org.netbeans.api.java.lexer.JavaTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListMatcher<E> {
    private final E[] oldL;
    private final E[] newL;
    private final Stack<ResultItem<E>> result;
    private Comparator<E> measure = new Comparator<E>(){

        @Override
        public int compare(E e, E e2) {
            assert (e != null && e2 != null) : "Shouldn't pass null value!";
            if (e == e2 || e.equals(e2)) {
                return 0;
            }
            return 1000;
        }
    };

    private ListMatcher(List<? extends E> list, List<? extends E> list2, Comparator<E> comparator) {
        this(list.toArray(), list2.toArray(), comparator);
    }

    private ListMatcher(List<? extends E> list, List<? extends E> list2) {
        this(list.toArray(), list2.toArray());
    }

    private ListMatcher(E[] EArray, E[] EArray2) {
        this(EArray, EArray2, null);
    }

    private ListMatcher(E[] EArray, E[] EArray2, Comparator<E> comparator) {
        this.oldL = EArray;
        this.newL = EArray2;
        if (comparator != null) {
            this.measure = comparator;
        }
        this.result = new Stack();
    }

    public static <T> ListMatcher<T> instance(List<? extends T> list, List<? extends T> list2) {
        return new ListMatcher<T>(list, list2);
    }

    public static <T> ListMatcher<T> instance(List<? extends T> list, List<? extends T> list2, Comparator<T> comparator) {
        return new ListMatcher<T>(list, list2, comparator);
    }

    public static <T> ListMatcher<T> instance(T[] TArray, T[] TArray2) {
        return new ListMatcher<T>(TArray, TArray2);
    }

    public boolean match() {
        int n;
        int n2;
        int n3 = this.oldL.length;
        int n4 = this.newL.length;
        int[][] nArray = new int[n3 + 1][n4 + 1];
        int[][] nArray2 = new int[n3 + 1][n4 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2][0] = 0;
            nArray2[n2][0] = 1;
        }
        for (n = 0; n <= n4; ++n) {
            nArray[0][n] = 0;
            nArray2[0][n] = 2;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            for (n = 1; n <= n4; ++n) {
                if (this.oldL[n2 - 1].equals(this.newL[n - 1])) {
                    nArray[n2][n] = nArray[n2 - 1][n - 1] + 1;
                    nArray2[n2][n] = 3;
                } else {
                    int n5 = this.measure.compare(this.oldL[n2 - 1], this.newL[n - 1]);
                    if (n5 > 0 && n5 < 1000) {
                        nArray[n2][n] = nArray[n2 - 1][n - 1] + 1;
                        nArray2[n2][n] = 4;
                    } else {
                        nArray[n2][n] = nArray[n2 - 1][n - 1] + 0;
                        int n6 = nArray2[n2][n] = n5 == 0 ? 3 : 0;
                    }
                }
                if (nArray[n2 - 1][n] >= nArray[n2][n]) {
                    nArray[n2][n] = nArray[n2 - 1][n];
                    nArray2[n2][n] = 1;
                }
                if (nArray[n2][n - 1] < nArray[n2][n]) continue;
                nArray[n2][n] = nArray[n2][n - 1];
                nArray2[n2][n] = 2;
            }
        }
        n2 = n3;
        n = n4;
        if (!this.result.empty()) {
            this.result.clear();
        }
        while (n2 > 0 || n > 0) {
            E e;
            if (nArray2[n2][n] == 3) {
                --n;
                e = this.oldL[--n2];
                this.result.push(new ResultItem<E>(e, Operation.NOCHANGE));
                continue;
            }
            if (nArray2[n2][n] == 4) {
                --n2;
                e = this.newL[--n];
                this.result.push(new ResultItem<E>(e, Operation.MODIFY));
                continue;
            }
            if (nArray2[n2][n] == 1) {
                e = this.oldL[--n2];
                this.result.push(new ResultItem<E>(e, Operation.DELETE));
                continue;
            }
            if (nArray2[n2][n] != 2) continue;
            e = this.newL[--n];
            this.result.push(new ResultItem<E>(e, Operation.INSERT));
        }
        return !this.result.empty();
    }

    public ResultItem<E>[] getResult() {
        int n = this.result.size();
        ResultItem[] resultItemArray = new ResultItem[n];
        for (ResultItem resultItem : this.result) {
            resultItemArray[--n] = resultItem;
        }
        return resultItemArray;
    }

    public ResultItem<E>[] getTransformedResult() {
        Stack stack = (Stack)this.result.clone();
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>(stack.size());
        while (!stack.empty()) {
            ResultItem resultItem = (ResultItem)stack.pop();
            if (resultItem.operation == Operation.DELETE && !stack.empty() && ((ResultItem)stack.peek()).operation == Operation.INSERT) {
                ResultItem resultItem2 = (ResultItem)stack.pop();
                arrayList.add(new ResultItem(resultItem2.element, Operation.MODIFY));
                continue;
            }
            arrayList.add(resultItem);
        }
        return arrayList.toArray(new ResultItem[0]);
    }

    public String printResult(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(128);
        ResultItem<E>[] resultItemArray = bl ? this.getTransformedResult() : this.getResult();
        for (int i = 0; i < resultItemArray.length; ++i) {
            stringBuffer.append(resultItemArray[i]).append('\n');
        }
        return stringBuffer.toString();
    }

    public Separator separatorInstance() {
        return new Separator<E>(this.getTransformedResult(), JavaTokenId.COMMA);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Separator<E> {
        static final SItem EMPTY = new SItem(null, 0);
        private final ResultItem<E>[] match;
        private E lastInList;
        private E firstInList;
        private final JavaTokenId separator;
        private SItem[] result;
        private boolean allNew;
        private boolean allOld;

        public Separator(ResultItem<E>[] resultItemArray, JavaTokenId javaTokenId) {
            int n;
            this.match = resultItemArray;
            this.separator = javaTokenId;
            this.lastInList = null;
            for (n = resultItemArray.length - 1; n > 0; --n) {
                if (resultItemArray[n].operation == Operation.DELETE) continue;
                this.lastInList = resultItemArray[n].element;
                break;
            }
            for (n = 0; n < resultItemArray.length; ++n) {
                if (resultItemArray[n].operation == Operation.DELETE) continue;
                this.firstInList = resultItemArray[n].element;
                break;
            }
            this.allOld = true;
            this.allNew = true;
            for (n = 0; n < resultItemArray.length; ++n) {
                if (resultItemArray[n].operation == Operation.MODIFY || resultItemArray[n].operation == Operation.NOCHANGE) {
                    this.allOld = false;
                    this.allNew = false;
                    continue;
                }
                if (resultItemArray[n].operation == Operation.INSERT) {
                    this.allOld = false;
                    continue;
                }
                if (resultItemArray[n].operation != Operation.DELETE) continue;
                this.allNew = false;
            }
        }

        private static SItem create(ResultItem resultItem) {
            return Separator.create(resultItem, 0);
        }

        private static SItem create(ResultItem resultItem, int n) {
            return new SItem(resultItem, n);
        }

        public void compute() {
            this.result = new SItem[this.match.length];
            for (int i = this.match.length - 1; i >= 0; --i) {
                int n;
                if (this.match[i].operation == Operation.DELETE) {
                    if (i == this.match.length - 1) {
                        if (i > 0 && this.match[i - 1].operation == Operation.DELETE) {
                            this.result[i] = Separator.create(this.match[i], this.allOld ? 8 : 0);
                            while (i > 0 && this.match[i - 1].operation == Operation.DELETE) {
                                if (i > 1 && this.match[i - 2].operation == Operation.DELETE) {
                                    this.result[--i] = Separator.create(this.match[i], 2);
                                    continue;
                                }
                                n = i - 1 == 0 ? 4 : 1;
                                this.result[--i] = Separator.create(this.match[i], n | 2);
                            }
                            continue;
                        }
                        n = i > 0 ? 1 : 4;
                        this.result[i] = Separator.create(this.match[i], n |= this.allOld ? 8 : 0);
                        continue;
                    }
                    this.result[i] = Separator.create(this.match[i], 2);
                    continue;
                }
                if (this.match[i].operation == Operation.INSERT) {
                    if (i == this.match.length - 1) {
                        if (i > 0 && this.match[i - 1].operation == Operation.INSERT) {
                            this.result[i] = Separator.create(this.match[i], this.allNew ? 8 : 0);
                            while (i > 0 && this.match[i - 1].operation == Operation.INSERT) {
                                if (i > 1 && this.match[i - 2].operation == Operation.INSERT) {
                                    this.result[--i] = Separator.create(this.match[i], 2);
                                    continue;
                                }
                                n = i - 1 == 0 ? 4 : 1;
                                this.result[--i] = Separator.create(this.match[i], n | 2);
                            }
                            continue;
                        }
                        n = i > 0 ? 1 : 4;
                        this.result[i] = Separator.create(this.match[i], n |= this.allNew ? 8 : 0);
                        continue;
                    }
                    this.result[i] = Separator.create(this.match[i], 2);
                    continue;
                }
                this.result[i] = EMPTY;
            }
        }

        public boolean head(int n) {
            return this.result[n].head();
        }

        public boolean prev(int n) {
            return this.result[n].prev();
        }

        public boolean next(int n) {
            return this.result[n].next();
        }

        public boolean tail(int n) {
            return this.result[n].tail();
        }

        public String print() {
            if (this.result != null) {
                StringBuffer stringBuffer = new StringBuffer(128);
                for (SItem sItem : this.result) {
                    if (sItem == EMPTY) continue;
                    stringBuffer.append(sItem).append('\n');
                }
                return stringBuffer.toString();
            }
            return "Result was not computed!";
        }

        private static final class SItem {
            private static final int NONE = 0;
            private static final int PREV = 1;
            private static final int NEXT = 2;
            private static final int HEAD = 4;
            private static final int TAIL = 8;
            private final int type;
            private final ResultItem item;

            private SItem(ResultItem resultItem, int n) {
                this.item = resultItem;
                this.type = n;
            }

            private boolean prev() {
                return (this.type & 1) != 0;
            }

            private boolean next() {
                return (this.type & 2) != 0;
            }

            private boolean head() {
                return (this.type & 4) != 0;
            }

            private boolean tail() {
                return (this.type & 8) != 0;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.head()) {
                    stringBuffer.append("head ");
                }
                if (this.prev()) {
                    stringBuffer.append("previous ");
                }
                stringBuffer.append(this.item.toString()).append(' ');
                if (this.next()) {
                    stringBuffer.append("next ");
                }
                if (this.tail()) {
                    stringBuffer.append("tail ");
                }
                return stringBuffer.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ResultItem<S> {
        public final S element;
        public final Operation operation;

        public ResultItem(S s, Operation operation) {
            this.element = s;
            this.operation = operation;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append('{');
            stringBuffer.append((Object)this.operation);
            stringBuffer.append("} ");
            stringBuffer.append(this.element);
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        INSERT("insert"),
        MODIFY("modify"),
        DELETE("delete"),
        NOCHANGE("nochange");

        private final String name;

        private Operation(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

