/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.util.LinkedList;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.java.source.parsing.ClasspathInfoTask;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;

public class NewComilerTask
extends ClasspathInfoTask {
    private CompilationController result;
    private long timestamp;

    public NewComilerTask(ClasspathInfo classpathInfo, CompilationController compilationController, long l) {
        super(classpathInfo);
        this.result = compilationController;
        this.timestamp = l;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        Snapshot snapshot = resultIterator.getSnapshot();
        if ("text/x-java".equals(snapshot.getMimeType())) {
            resultIterator.getParserResult();
        } else {
            this.findEmbeddedJava(resultIterator);
        }
    }

    private Parser.Result findEmbeddedJava(ResultIterator resultIterator) throws ParseException {
        LinkedList<Embedding> linkedList = new LinkedList<Embedding>();
        for (Embedding embedding : resultIterator.getEmbeddings()) {
            if ("text/x-java".equals(embedding.getMimeType())) {
                return resultIterator.getResultIterator(embedding).getParserResult();
            }
            linkedList.add(embedding);
        }
        for (Embedding embedding : linkedList) {
            Parser.Result result = this.findEmbeddedJava(resultIterator.getResultIterator(embedding));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void setCompilationController(CompilationController compilationController, long l) {
        assert (compilationController != null);
        this.result = compilationController;
        this.timestamp = l;
    }

    public CompilationController getCompilationController() {
        return this.result;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }
}

