/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexerCache;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSSynchronizingIndexer
extends CustomIndexer {
    protected void index(Iterable<? extends Indexable> iterable, Context context) {
        if (!BuildArtifactMapperImpl.isUpdateResources(BuildArtifactMapperImpl.getTargetFolder(context.getRootURI()))) {
            return;
        }
        Set<String> set = COSSynchronizingIndexer.gatherJavaMimeTypes();
        LinkedList<File> linkedList = new LinkedList<File>();
        for (Indexable indexable : iterable) {
            if (set.contains(indexable.getMimeType())) continue;
            try {
                URL uRL = indexable.getURL();
                if (uRL == null) continue;
                linkedList.add(new File(uRL.toURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
        try {
            File file = new File(context.getRootURI().toURI());
            BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), file, Collections.<File>emptyList(), linkedList, true);
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
    }

    public static Set<String> gatherJavaMimeTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        for (IndexerCache.IndexerInfo indexerInfo : IndexerCache.getCifCache().getIndexersByName("java")) {
            hashSet.addAll(indexerInfo.getMimeTypes());
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends CustomIndexerFactory {
        public CustomIndexer createIndexer() {
            return new COSSynchronizingIndexer();
        }

        public boolean supportsEmbeddedIndexers() {
            return true;
        }

        public void filesDeleted(Iterable<? extends Indexable> iterable, Context context) {
            if (BuildArtifactMapperImpl.getTargetFolder(context.getRootURI()) == null) {
                return;
            }
            LinkedList<File> linkedList = new LinkedList<File>();
            for (Indexable indexable : iterable) {
                try {
                    linkedList.add(new File(indexable.getURL().toURI()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
            }
            try {
                File file = new File(context.getRootURI().toURI());
                BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), file, linkedList, Collections.<File>emptyList(), true);
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> iterable, Context context) {
        }

        public String getIndexerName() {
            return COSSynchronizingIndexer.class.getName();
        }

        public int getIndexVersion() {
            return 1;
        }
    }
}

