/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.tools.javac.api.JavacTaskImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.PositionConverter;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaSourceAccessor {
    private Map<CancellableTask<CompilationInfo>, ParserResultTask<?>> tasks = new HashMap();
    private static volatile JavaSourceAccessor INSTANCE;

    public static synchronized JavaSourceAccessor getINSTANCE() {
        if (INSTANCE == null) {
            try {
                Class.forName("org.netbeans.api.java.source.JavaSource", true, JavaSourceAccessor.class.getClassLoader());
                assert (INSTANCE != null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
        return INSTANCE;
    }

    public static void setINSTANCE(JavaSourceAccessor javaSourceAccessor) {
        assert (javaSourceAccessor != null);
        INSTANCE = javaSourceAccessor;
    }

    private int translatePriority(JavaSource.Priority priority) {
        assert (priority != null);
        int n = priority == JavaSource.Priority.MAX ? 0 : (priority == JavaSource.Priority.MIN ? Integer.MAX_VALUE : priority.ordinal() * 100);
        return n;
    }

    public void runSpecialTask(final Mutex.ExceptionAction exceptionAction, JavaSource.Priority priority) {
        final int n = this.translatePriority(priority);
        ParserResultTask parserResultTask = new ParserResultTask(){

            public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
                try {
                    exceptionAction.run();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }

            public int getPriority() {
                return n;
            }

            public Class<? extends Scheduler> getSchedulerClass() {
                return null;
            }

            public void cancel() {
            }
        };
        Utilities.scheduleSpecialTask((SchedulerTask)parserResultTask);
    }

    public void revalidate(JavaSource javaSource) {
        Collection<Source> collection = this.getSources(javaSource);
        assert (collection != null);
        if (collection.size() == 1) {
            Utilities.revalidate((Source)collection.iterator().next());
        }
    }

    public boolean isJavaCompilerLocked() {
        return Utilities.holdsParserLock();
    }

    public void lockJavaCompiler() {
        Utilities.acquireParserLock();
    }

    public void unlockJavaCompiler() {
        Utilities.releaseParserLock();
    }

    public void addPhaseCompletionTask(JavaSource javaSource, CancellableTask<CompilationInfo> cancellableTask, JavaSource.Phase phase, JavaSource.Priority priority) {
        Collection<Source> collection = this.getSources(javaSource);
        assert (collection.size() == 1);
        int n = this.translatePriority(priority);
        assert (!this.tasks.keySet().contains(cancellableTask));
        CancelableTaskWrapper cancelableTaskWrapper = new CancelableTaskWrapper(cancellableTask, n, phase, javaSource);
        this.tasks.put(cancellableTask, cancelableTaskWrapper);
        Utilities.addParserResultTask((ParserResultTask)cancelableTaskWrapper, (Source)collection.iterator().next());
    }

    public void removePhaseCompletionTask(JavaSource javaSource, CancellableTask<CompilationInfo> cancellableTask) {
        Collection<Source> collection = this.getSources(javaSource);
        assert (collection.size() == 1);
        ParserResultTask<?> parserResultTask = this.tasks.remove(cancellableTask);
        if (parserResultTask == null) {
            throw new NullPointerException();
        }
        Utilities.removeParserResultTask(parserResultTask, (Source)collection.iterator().next());
    }

    public void rescheduleTask(JavaSource javaSource, CancellableTask<CompilationInfo> cancellableTask) {
        Collection<Source> collection = this.getSources(javaSource);
        assert (collection.size() == 1);
        ParserResultTask<?> parserResultTask = this.tasks.get(cancellableTask);
        if (parserResultTask != null) {
            Utilities.rescheduleTask(parserResultTask, (Source)collection.iterator().next());
        }
    }

    public abstract Collection<Source> getSources(JavaSource var1);

    public abstract void setJavaSource(CompilationInfo var1, JavaSource var2);

    public abstract JavacTaskImpl getJavacTask(CompilationInfo var1);

    public abstract CompilationController createCompilationController(Source var1) throws IOException, ParseException;

    public abstract long createTaggedCompilationController(JavaSource var1, long var2, Object[] var4) throws IOException;

    public abstract JavaSource create(ClasspathInfo var1, PositionConverter var2, Collection<? extends FileObject> var3) throws IllegalArgumentException;

    public abstract CompilationInfo createCompilationInfo(CompilationInfoImpl var1);

    public abstract CompilationController createCompilationController(CompilationInfoImpl var1);

    public abstract void invalidateCachedClasspathInfo(FileObject var1);

    public abstract CompilationInfoImpl getCompilationInfoImpl(CompilationInfo var1);

    @NonNull
    public abstract String generateReadableParameterName(@NonNull String var1, @NonNull Set<String> var2);

    public abstract void invalidate(CompilationInfo var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CancelableTaskWrapper
    extends JavaParserResultTask
    implements ClasspathInfoProvider {
        private final JavaSource javaSource;
        private final int priority;
        private final CancellableTask<CompilationInfo> task;

        public CancelableTaskWrapper(CancellableTask<CompilationInfo> cancellableTask, int n, JavaSource.Phase phase, JavaSource javaSource) {
            super(phase);
            assert (phase != null);
            assert (javaSource != null);
            this.task = cancellableTask;
            this.priority = n;
            this.javaSource = javaSource;
        }

        public int getPriority() {
            return this.priority;
        }

        public Class<? extends Scheduler> getSchedulerClass() {
            return null;
        }

        public void cancel() {
            this.task.cancel();
        }

        public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
            CompilationInfo compilationInfo = CompilationInfo.get(result);
            assert (compilationInfo != null);
            try {
                JavaSourceAccessor.getINSTANCE().setJavaSource(compilationInfo, this.javaSource);
                this.task.run(compilationInfo);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        @Override
        public ClasspathInfo getClasspathInfo() {
            return this.javaSource.getClasspathInfo();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[task: " + this.task + ", phase: " + (Object)((Object)this.getPhase()) + ", priority: " + this.priority + "]";
        }
    }
}

