/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TranslateIdentifier
implements TreeVisitor<Tree, Boolean> {
    private final CompilationInfo info;
    private final TreeMaker make;
    private final CompilationUnitTree unit;
    private final boolean copyComments;
    private final boolean resolveImports;
    private final TokenSequence<JavaTokenId> seq;
    private final CommentHandlerService commentService;
    private final SourcePositions positions;
    private int tokenIndexAlreadyAdded = -1;
    private Element rootElement;
    private static Logger log = Logger.getLogger(TranslateIdentifier.class.getName());

    public TranslateIdentifier(CompilationInfo compilationInfo, boolean bl, boolean bl2, TokenSequence<JavaTokenId> tokenSequence) {
        this(compilationInfo, bl, bl2, tokenSequence, compilationInfo.getCompilationUnit());
    }

    public TranslateIdentifier(CompilationInfo compilationInfo, boolean bl, boolean bl2, TokenSequence<JavaTokenId> tokenSequence, CompilationUnitTree compilationUnitTree) {
        this(compilationInfo, bl, bl2, tokenSequence, compilationUnitTree, compilationInfo.getTrees().getSourcePositions());
    }

    public TranslateIdentifier(CompilationInfo compilationInfo, boolean bl, boolean bl2, TokenSequence<JavaTokenId> tokenSequence, SourcePositions sourcePositions) {
        this(compilationInfo, bl, bl2, tokenSequence, compilationInfo.getCompilationUnit(), sourcePositions);
    }

    private TranslateIdentifier(CompilationInfo compilationInfo, boolean bl, boolean bl2, TokenSequence<JavaTokenId> tokenSequence, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions) {
        this.info = compilationInfo;
        this.make = compilationInfo instanceof WorkingCopy ? ((WorkingCopy)compilationInfo).getTreeMaker() : null;
        this.unit = compilationUnitTree;
        this.seq = tokenSequence;
        this.copyComments = bl;
        this.resolveImports = bl2;
        this.commentService = CommentHandlerService.instance(compilationInfo.impl.getJavacTask().getContext());
        this.positions = sourcePositions;
    }

    @Override
    public Tree visitAnnotation(AnnotationTree annotationTree, Boolean bl) {
        Tree tree = this.translateTree(annotationTree.getAnnotationType());
        List<? extends ExpressionTree> list = this.translateTree(annotationTree.getArguments());
        if (this.make == null) {
            return annotationTree;
        }
        if (tree != annotationTree.getAnnotationType() || list != annotationTree.getArguments()) {
            annotationTree = this.make.Annotation(tree, list);
        }
        return annotationTree;
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree methodInvocationTree, Boolean bl) {
        List<? extends ExpressionTree> list = this.translateTree(methodInvocationTree.getArguments());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(methodInvocationTree.getMethodSelect());
        List<? extends Tree> list2 = this.translateTree(methodInvocationTree.getTypeArguments());
        if (this.make == null) {
            return methodInvocationTree;
        }
        if (list != methodInvocationTree.getArguments() || expressionTree != methodInvocationTree.getMethodSelect() || list2 != methodInvocationTree.getTypeArguments()) {
            methodInvocationTree = this.make.MethodInvocation(list2, expressionTree, list);
        }
        return methodInvocationTree;
    }

    @Override
    public Tree visitAssert(AssertTree assertTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(assertTree.getCondition());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(assertTree.getDetail());
        if (this.make == null) {
            return assertTree;
        }
        if (expressionTree != assertTree.getCondition() || expressionTree2 != assertTree.getDetail()) {
            assertTree = this.make.Assert(expressionTree, expressionTree2);
        }
        return assertTree;
    }

    @Override
    public Tree visitAssignment(AssignmentTree assignmentTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(assignmentTree.getExpression());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(assignmentTree.getVariable());
        if (this.make == null) {
            return assignmentTree;
        }
        if (expressionTree != assignmentTree.getExpression() || expressionTree2 != assignmentTree.getVariable()) {
            assignmentTree = this.make.Assignment(expressionTree2, expressionTree);
        }
        return assignmentTree;
    }

    @Override
    public Tree visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(compoundAssignmentTree.getExpression());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(compoundAssignmentTree.getVariable());
        if (this.make == null) {
            return compoundAssignmentTree;
        }
        if (expressionTree != compoundAssignmentTree.getExpression() || expressionTree2 != compoundAssignmentTree.getVariable()) {
            compoundAssignmentTree = this.make.CompoundAssignment(compoundAssignmentTree.getKind(), expressionTree2, expressionTree);
        }
        return compoundAssignmentTree;
    }

    @Override
    public Tree visitBinary(BinaryTree binaryTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(binaryTree.getLeftOperand());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(binaryTree.getRightOperand());
        if (this.make == null) {
            return binaryTree;
        }
        if (expressionTree != binaryTree.getLeftOperand() || expressionTree2 != binaryTree.getRightOperand()) {
            binaryTree = this.make.Binary(binaryTree.getKind(), expressionTree, expressionTree2);
        }
        return binaryTree;
    }

    @Override
    public Tree visitBlock(BlockTree blockTree, Boolean bl) {
        List<? extends StatementTree> list = this.translateTree(blockTree.getStatements());
        if (this.make == null) {
            return blockTree;
        }
        if (list != blockTree.getStatements()) {
            blockTree = this.make.Block(list, blockTree.isStatic());
        }
        return blockTree;
    }

    @Override
    public Tree visitBreak(BreakTree breakTree, Boolean bl) {
        return breakTree;
    }

    @Override
    public Tree visitCase(CaseTree caseTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(caseTree.getExpression(), true);
        List<? extends StatementTree> list = this.translateTree(caseTree.getStatements());
        if (this.make == null) {
            return caseTree;
        }
        if (expressionTree != caseTree.getExpression() || list != caseTree.getStatements()) {
            caseTree = this.make.Case(expressionTree, list);
        }
        return caseTree;
    }

    @Override
    public Tree visitCatch(CatchTree catchTree, Boolean bl) {
        BlockTree blockTree = (BlockTree)this.translateTree(catchTree.getBlock());
        VariableTree variableTree = (VariableTree)this.translateTree(catchTree.getParameter());
        if (this.make == null) {
            return catchTree;
        }
        if (blockTree != catchTree.getBlock() || variableTree != catchTree.getParameter()) {
            catchTree = this.make.Catch(variableTree, blockTree);
        }
        return catchTree;
    }

    @Override
    public Tree visitClass(ClassTree classTree, Boolean bl) {
        Tree tree = this.translateTree(classTree.getExtendsClause());
        List<? extends Tree> list = this.translateTree(classTree.getImplementsClause());
        List<? extends Tree> list2 = this.translateTree(classTree.getMembers());
        ModifiersTree modifiersTree = (ModifiersTree)this.translateTree(classTree.getModifiers());
        List<? extends TypeParameterTree> list3 = this.translateTree(classTree.getTypeParameters());
        if (this.make == null) {
            return classTree;
        }
        if (tree != classTree.getExtendsClause() || list != classTree.getImplementsClause() || list2 != classTree.getMembers() || modifiersTree != classTree.getModifiers() || list3 != classTree.getTypeParameters()) {
            classTree = this.make.Class(modifiersTree, classTree.getSimpleName(), list3, tree, list, list2);
        }
        return classTree;
    }

    @Override
    public Tree visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(conditionalExpressionTree.getCondition());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(conditionalExpressionTree.getFalseExpression());
        ExpressionTree expressionTree3 = (ExpressionTree)this.translateTree(conditionalExpressionTree.getTrueExpression());
        if (this.make == null) {
            return conditionalExpressionTree;
        }
        if (expressionTree != conditionalExpressionTree.getCondition() || expressionTree2 != conditionalExpressionTree.getFalseExpression() || expressionTree3 != conditionalExpressionTree.getTrueExpression()) {
            conditionalExpressionTree = this.make.ConditionalExpression(expressionTree, expressionTree3, expressionTree2);
        }
        return conditionalExpressionTree;
    }

    @Override
    public Tree visitContinue(ContinueTree continueTree, Boolean bl) {
        return continueTree;
    }

    @Override
    public Tree visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, Boolean bl) {
        StatementTree statementTree = (StatementTree)this.translateTree(doWhileLoopTree.getStatement());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(doWhileLoopTree.getCondition());
        if (this.make == null) {
            return doWhileLoopTree;
        }
        if (expressionTree != doWhileLoopTree.getCondition() || statementTree != doWhileLoopTree.getStatement()) {
            doWhileLoopTree = this.make.DoWhileLoop(expressionTree, statementTree);
        }
        return doWhileLoopTree;
    }

    @Override
    public Tree visitErroneous(ErroneousTree erroneousTree, Boolean bl) {
        List<? extends Tree> list = this.translateTree(erroneousTree.getErrorTrees());
        if (this.make == null) {
            return erroneousTree;
        }
        if (list != erroneousTree.getErrorTrees()) {
            erroneousTree = this.make.Erroneous(list);
        }
        return erroneousTree;
    }

    @Override
    public Tree visitExpressionStatement(ExpressionStatementTree expressionStatementTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(expressionStatementTree.getExpression());
        if (this.make == null) {
            return expressionStatementTree;
        }
        if (expressionTree != expressionStatementTree.getExpression()) {
            expressionStatementTree = this.make.ExpressionStatement(expressionTree);
        }
        return expressionStatementTree;
    }

    @Override
    public Tree visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, Boolean bl) {
        StatementTree statementTree = (StatementTree)this.translateTree(enhancedForLoopTree.getStatement());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(enhancedForLoopTree.getExpression());
        VariableTree variableTree = (VariableTree)this.translateTree(enhancedForLoopTree.getVariable());
        if (this.make == null) {
            return enhancedForLoopTree;
        }
        if (statementTree != enhancedForLoopTree.getStatement() || expressionTree != enhancedForLoopTree.getExpression() || variableTree != enhancedForLoopTree.getVariable()) {
            enhancedForLoopTree = this.make.EnhancedForLoop(variableTree, expressionTree, statementTree);
        }
        return enhancedForLoopTree;
    }

    @Override
    public Tree visitForLoop(ForLoopTree forLoopTree, Boolean bl) {
        StatementTree statementTree = (StatementTree)this.translateTree(forLoopTree.getStatement());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(forLoopTree.getCondition());
        List<? extends StatementTree> list = this.translateTree(forLoopTree.getInitializer());
        List<? extends ExpressionStatementTree> list2 = this.translateTree(forLoopTree.getUpdate());
        if (this.make == null) {
            return forLoopTree;
        }
        if (statementTree != forLoopTree.getStatement() || expressionTree != forLoopTree.getCondition() || list != forLoopTree.getInitializer() || list2 != forLoopTree.getUpdate()) {
            forLoopTree = this.make.ForLoop(list, expressionTree, list2, statementTree);
        }
        return forLoopTree;
    }

    @Override
    public Tree visitIdentifier(IdentifierTree identifierTree, Boolean bl) {
        if (!this.resolveImports) {
            return identifierTree;
        }
        if (this.make == null) {
            return identifierTree;
        }
        TreePath treePath = this.info.getTrees().getPath(this.unit, identifierTree);
        Element element = treePath == null ? ((JCTree.JCIdent)identifierTree).sym : this.info.getTrees().getElement(treePath);
        if (element != null && (element.getKind().isClass() || element.getKind().isInterface() || element.getKind().isField() && ((Symbol)element).isStatic())) {
            boolean bl2;
            TreePath treePath2 = this.info.getTrees().getPath(element);
            boolean bl3 = bl2 = bl == Boolean.TRUE && element.getKind() == ElementKind.ENUM_CONSTANT;
            if (treePath == null && element == this.rootElement || treePath != null && treePath2 != null && treePath.getCompilationUnit().getSourceFile() == treePath2.getCompilationUnit().getSourceFile() || bl2) {
                return this.make.Identifier(element.getSimpleName());
            }
            return this.make.QualIdent(element);
        }
        return identifierTree;
    }

    @Override
    public Tree visitIf(IfTree ifTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(ifTree.getCondition());
        StatementTree statementTree = (StatementTree)this.translateTree(ifTree.getElseStatement());
        StatementTree statementTree2 = (StatementTree)this.translateTree(ifTree.getThenStatement());
        if (this.make == null) {
            return ifTree;
        }
        if (expressionTree != ifTree.getCondition() || statementTree != ifTree.getElseStatement() || statementTree2 != ifTree.getThenStatement()) {
            ifTree = this.make.If(expressionTree, statementTree2, statementTree);
        }
        return ifTree;
    }

    @Override
    public Tree visitImport(ImportTree importTree, Boolean bl) {
        return importTree;
    }

    @Override
    public Tree visitArrayAccess(ArrayAccessTree arrayAccessTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(arrayAccessTree.getExpression());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(arrayAccessTree.getIndex());
        if (this.make == null) {
            return arrayAccessTree;
        }
        if (expressionTree != arrayAccessTree.getExpression() || expressionTree2 != arrayAccessTree.getIndex()) {
            arrayAccessTree = this.make.ArrayAccess(expressionTree, expressionTree2);
        }
        return arrayAccessTree;
    }

    @Override
    public Tree visitLabeledStatement(LabeledStatementTree labeledStatementTree, Boolean bl) {
        StatementTree statementTree = (StatementTree)this.translateTree(labeledStatementTree.getStatement());
        if (this.make == null) {
            return labeledStatementTree;
        }
        if (statementTree != labeledStatementTree.getStatement()) {
            labeledStatementTree = this.make.LabeledStatement(labeledStatementTree.getLabel(), statementTree);
        }
        return labeledStatementTree;
    }

    @Override
    public Tree visitLiteral(LiteralTree literalTree, Boolean bl) {
        return literalTree;
    }

    @Override
    public Tree visitMethod(MethodTree methodTree, Boolean bl) {
        BlockTree blockTree = (BlockTree)this.translateTree(methodTree.getBody());
        Tree tree = this.translateTree(methodTree.getDefaultValue());
        List<? extends VariableTree> list = this.translateTree(methodTree.getParameters());
        ModifiersTree modifiersTree = (ModifiersTree)this.translateTree(methodTree.getModifiers());
        Tree tree2 = this.translateTree(methodTree.getReturnType());
        List<? extends ExpressionTree> list2 = this.translateTree(methodTree.getThrows());
        List<? extends TypeParameterTree> list3 = this.translateTree(methodTree.getTypeParameters());
        if (this.make == null) {
            return methodTree;
        }
        if (blockTree != methodTree.getBody() || tree != methodTree.getDefaultValue() || list != methodTree.getParameters() || modifiersTree != methodTree.getModifiers() || tree2 != methodTree.getReturnType() || list2 != methodTree.getThrows() || list3 != methodTree.getTypeParameters()) {
            methodTree = this.make.Method(modifiersTree, (CharSequence)methodTree.getName(), tree2, list3, list, list2, blockTree, (ExpressionTree)tree);
        }
        return methodTree;
    }

    @Override
    public Tree visitModifiers(ModifiersTree modifiersTree, Boolean bl) {
        List<? extends AnnotationTree> list = this.translateTree(modifiersTree.getAnnotations());
        if (this.make == null) {
            return modifiersTree;
        }
        if (list != modifiersTree.getAnnotations()) {
            modifiersTree = this.make.Modifiers(modifiersTree.getFlags(), list);
        }
        return modifiersTree;
    }

    @Override
    public Tree visitNewArray(NewArrayTree newArrayTree, Boolean bl) {
        List<? extends ExpressionTree> list = this.translateTree(newArrayTree.getInitializers());
        List<? extends ExpressionTree> list2 = this.translateTree(newArrayTree.getDimensions());
        Tree tree = this.translateTree(newArrayTree.getType());
        if (this.make == null) {
            return newArrayTree;
        }
        if (list != newArrayTree.getInitializers() || list2 != newArrayTree.getDimensions() || tree != newArrayTree.getType()) {
            newArrayTree = this.make.NewArray(tree, list2, list);
        }
        return newArrayTree;
    }

    @Override
    public Tree visitNewClass(NewClassTree newClassTree, Boolean bl) {
        List<? extends ExpressionTree> list = this.translateTree(newClassTree.getArguments());
        ClassTree classTree = (ClassTree)this.translateTree(newClassTree.getClassBody());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(newClassTree.getEnclosingExpression());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(newClassTree.getIdentifier());
        List<? extends Tree> list2 = this.translateTree(newClassTree.getTypeArguments());
        if (this.make == null) {
            return newClassTree;
        }
        if (list != newClassTree.getArguments() || classTree != newClassTree.getClassBody() || expressionTree != newClassTree.getEnclosingExpression() || expressionTree2 != newClassTree.getIdentifier() || list2 != newClassTree.getTypeArguments()) {
            newClassTree = this.make.NewClass(expressionTree, list2, expressionTree2, list, classTree);
        }
        return newClassTree;
    }

    @Override
    public Tree visitParenthesized(ParenthesizedTree parenthesizedTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(parenthesizedTree.getExpression());
        if (this.make == null) {
            return parenthesizedTree;
        }
        if (expressionTree != parenthesizedTree.getExpression()) {
            parenthesizedTree = this.make.Parenthesized(expressionTree);
        }
        return parenthesizedTree;
    }

    @Override
    public Tree visitReturn(ReturnTree returnTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(returnTree.getExpression());
        if (this.make == null) {
            return returnTree;
        }
        if (expressionTree != returnTree.getExpression()) {
            returnTree = this.make.Return(expressionTree);
        }
        return returnTree;
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Boolean bl) {
        if (this.make == null) {
            return memberSelectTree;
        }
        TypeElement typeElement = this.info.getElements().getTypeElement(memberSelectTree.toString());
        if (typeElement != null) {
            return this.make.QualIdent(typeElement);
        }
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(memberSelectTree.getExpression());
        if (expressionTree != memberSelectTree.getExpression()) {
            memberSelectTree = this.make.MemberSelect(expressionTree, memberSelectTree.getIdentifier());
        }
        return memberSelectTree;
    }

    @Override
    public Tree visitEmptyStatement(EmptyStatementTree emptyStatementTree, Boolean bl) {
        return emptyStatementTree;
    }

    @Override
    public Tree visitSwitch(SwitchTree switchTree, Boolean bl) {
        List<? extends CaseTree> list = this.translateTree(switchTree.getCases());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(switchTree.getExpression());
        if (this.make == null) {
            return switchTree;
        }
        if (list != switchTree.getCases() || expressionTree != switchTree.getExpression()) {
            switchTree = this.make.Switch(expressionTree, list);
        }
        return switchTree;
    }

    @Override
    public Tree visitSynchronized(SynchronizedTree synchronizedTree, Boolean bl) {
        BlockTree blockTree = (BlockTree)this.translateTree(synchronizedTree.getBlock());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(synchronizedTree.getExpression());
        if (this.make == null) {
            return synchronizedTree;
        }
        if (blockTree != synchronizedTree.getBlock() || expressionTree != synchronizedTree.getExpression()) {
            synchronizedTree = this.make.Synchronized(expressionTree, blockTree);
        }
        return synchronizedTree;
    }

    @Override
    public Tree visitThrow(ThrowTree throwTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(throwTree.getExpression());
        if (this.make == null) {
            return throwTree;
        }
        if (expressionTree != throwTree.getExpression()) {
            throwTree = this.make.Throw(expressionTree);
        }
        return throwTree;
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Boolean bl) {
        List<? extends Tree> list = this.translateTree(compilationUnitTree.getTypeDecls());
        if (this.make == null) {
            return compilationUnitTree;
        }
        if (list != compilationUnitTree.getTypeDecls()) {
            compilationUnitTree = this.make.CompilationUnit(compilationUnitTree.getPackageName(), compilationUnitTree.getImports(), list, compilationUnitTree.getSourceFile());
        }
        return compilationUnitTree;
    }

    @Override
    public Tree visitTry(TryTree tryTree, Boolean bl) {
        BlockTree blockTree = (BlockTree)this.translateTree(tryTree.getBlock());
        List<? extends CatchTree> list = this.translateTree(tryTree.getCatches());
        BlockTree blockTree2 = (BlockTree)this.translateTree(tryTree.getFinallyBlock());
        if (this.make == null) {
            return tryTree;
        }
        if (blockTree != tryTree.getBlock() || list != tryTree.getCatches() || blockTree2 != tryTree.getFinallyBlock()) {
            tryTree = this.make.Try(blockTree, list, blockTree2);
        }
        return tryTree;
    }

    @Override
    public Tree visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Boolean bl) {
        Tree tree = this.translateTree(parameterizedTypeTree.getType());
        List<? extends Tree> list = this.translateTree(parameterizedTypeTree.getTypeArguments());
        if (this.make == null) {
            return parameterizedTypeTree;
        }
        if (tree != parameterizedTypeTree.getType() || list != parameterizedTypeTree.getTypeArguments()) {
            parameterizedTypeTree = this.make.ParameterizedType(tree, list);
        }
        return parameterizedTypeTree;
    }

    @Override
    public Tree visitArrayType(ArrayTypeTree arrayTypeTree, Boolean bl) {
        Tree tree = this.translateTree(arrayTypeTree.getType());
        if (this.make == null) {
            return arrayTypeTree;
        }
        if (tree != arrayTypeTree.getType()) {
            arrayTypeTree = this.make.ArrayType(tree);
        }
        return arrayTypeTree;
    }

    @Override
    public Tree visitTypeCast(TypeCastTree typeCastTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(typeCastTree.getExpression());
        Tree tree = this.translateTree(typeCastTree.getType());
        if (this.make == null) {
            return typeCastTree;
        }
        if (expressionTree != typeCastTree.getExpression() || tree != typeCastTree.getType()) {
            typeCastTree = this.make.TypeCast(tree, expressionTree);
        }
        return typeCastTree;
    }

    @Override
    public Tree visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, Boolean bl) {
        return primitiveTypeTree;
    }

    @Override
    public Tree visitTypeParameter(TypeParameterTree typeParameterTree, Boolean bl) {
        List<? extends Tree> list = this.translateTree(typeParameterTree.getBounds());
        if (this.make == null) {
            return typeParameterTree;
        }
        if (list != typeParameterTree.getBounds()) {
            typeParameterTree = this.make.TypeParameter(typeParameterTree.getName(), list);
        }
        return typeParameterTree;
    }

    @Override
    public Tree visitInstanceOf(InstanceOfTree instanceOfTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(instanceOfTree.getExpression());
        Tree tree = this.translateTree(instanceOfTree.getType());
        if (this.make == null) {
            return instanceOfTree;
        }
        if (expressionTree != instanceOfTree.getExpression() || tree != instanceOfTree.getType()) {
            instanceOfTree = this.make.InstanceOf(expressionTree, tree);
        }
        return instanceOfTree;
    }

    @Override
    public Tree visitUnary(UnaryTree unaryTree, Boolean bl) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(unaryTree.getExpression());
        if (this.make == null) {
            return unaryTree;
        }
        if (expressionTree != unaryTree.getExpression()) {
            unaryTree = this.make.Unary(unaryTree.getKind(), expressionTree);
        }
        return unaryTree;
    }

    @Override
    public Tree visitVariable(VariableTree variableTree, Boolean bl) {
        ModifiersTree modifiersTree = (ModifiersTree)this.translateTree(variableTree.getModifiers());
        Tree tree = this.translateTree(variableTree.getType());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(variableTree.getInitializer());
        if (this.make == null) {
            return variableTree;
        }
        if (modifiersTree != variableTree.getModifiers() || tree != variableTree.getType() || expressionTree != variableTree.getInitializer()) {
            variableTree = this.make.Variable(modifiersTree, variableTree.getName(), tree, expressionTree);
        }
        return variableTree;
    }

    @Override
    public Tree visitWhileLoop(WhileLoopTree whileLoopTree, Boolean bl) {
        StatementTree statementTree = (StatementTree)this.translateTree(whileLoopTree.getStatement());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(whileLoopTree.getCondition());
        if (this.make == null) {
            return whileLoopTree;
        }
        if (expressionTree != whileLoopTree.getCondition() || statementTree != whileLoopTree.getStatement()) {
            whileLoopTree = this.make.WhileLoop(expressionTree, statementTree);
        }
        return whileLoopTree;
    }

    @Override
    public Tree visitWildcard(WildcardTree wildcardTree, Boolean bl) {
        Tree tree = this.translateTree(wildcardTree.getBound());
        if (this.make == null) {
            return wildcardTree;
        }
        if (tree != wildcardTree.getBound()) {
            wildcardTree = this.make.Wildcard(wildcardTree.getKind(), tree);
        }
        return wildcardTree;
    }

    @Override
    public Tree visitOther(Tree tree, Boolean bl) {
        return tree;
    }

    public Tree translate(Tree tree) {
        TreePath treePath;
        if (tree == null) {
            return null;
        }
        if (this.copyComments) {
            this.mapComments2(tree, true);
        }
        if ((treePath = this.info.getTrees().getPath(this.unit, tree)) == null) {
            if (tree instanceof JCTree.JCClassDecl) {
                this.rootElement = ((JCTree.JCClassDecl)tree).sym;
            }
        } else {
            this.rootElement = this.info.getTrees().getElement(treePath);
        }
        Tree tree2 = tree.accept(this, null);
        if (this.copyComments) {
            this.mapComments2(tree, false);
        }
        return tree2;
    }

    private <T extends Tree> List<T> translateTree(List<T> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        boolean bl = false;
        for (Tree tree : list) {
            Tree tree2 = this.translateTree(tree);
            if (tree2 != tree) {
                bl = true;
            }
            if (tree2 == null) continue;
            arrayList.add(tree2);
        }
        return bl ? arrayList : list;
    }

    private Tree translateTree(Tree tree) {
        return this.translateTree(tree, null);
    }

    private Tree translateTree(Tree tree, Boolean bl) {
        if (tree == null) {
            return null;
        }
        if (this.copyComments && this.info.getTreeUtilities().isSynthetic(new TreePath(new TreePath(this.info.getCompilationUnit()), tree))) {
            return tree;
        }
        if (this.copyComments) {
            this.mapComments2(tree, true);
        }
        Tree tree2 = tree.accept(this, bl);
        if (this.copyComments) {
            this.mapComments2(tree, false);
        }
        this.commentService.copyComments(tree, tree2);
        return tree2;
    }

    private void mapComments2(Tree tree, boolean bl) {
        if (((JCTree)tree).pos <= 0) {
            return;
        }
        this.collect(tree, bl);
    }

    private void collect(Tree tree, boolean bl) {
        if (this.isEvil(tree)) {
            return;
        }
        if (bl) {
            BlockTree blockTree;
            int n = this.findInterestingStart((JCTree)tree);
            this.seq.move(n);
            this.lookForPreceedings(this.seq, tree);
            if (tree instanceof BlockTree && (blockTree = (BlockTree)tree).getStatements().isEmpty()) {
                this.lookWithinEmptyBlock(this.seq, blockTree);
            }
        } else {
            this.lookForInline(this.seq, tree);
            this.lookForTrailing(this.seq, tree);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "T: " + tree + "\nC: " + this.commentService.getComments(tree));
        }
    }

    private void lookForInline(TokenSequence<JavaTokenId> tokenSequence, Tree tree) {
        tokenSequence.move((int)this.positions.getEndPosition(this.unit, tree));
        CommentsCollection commentsCollection = new CommentsCollection();
        while (tokenSequence.moveNext()) {
            if (tokenSequence.index() <= this.tokenIndexAlreadyAdded) continue;
            if (tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                if (this.numberOfNL((Token<JavaTokenId>)tokenSequence.token()) <= 0) continue;
                break;
            }
            if (!this.isComment((JavaTokenId)tokenSequence.token().id())) break;
            commentsCollection.add((Token<JavaTokenId>)tokenSequence.token());
            this.tokenIndexAlreadyAdded = tokenSequence.index();
            if (tokenSequence.token().id() != JavaTokenId.LINE_COMMENT) continue;
        }
        if (!commentsCollection.isEmpty()) {
            CommentSet.RelativePosition relativePosition = CommentSet.RelativePosition.INLINE;
            this.attachComments(tree, commentsCollection, relativePosition);
        }
    }

    private void attachComments(Tree tree, CommentsCollection commentsCollection, CommentSet.RelativePosition relativePosition) {
        CommentSetImpl commentSetImpl = this.commentService.getComments(tree);
        for (Token<JavaTokenId> token : commentsCollection) {
            this.attachComment(relativePosition, commentSetImpl, token);
        }
    }

    private boolean isEvil(Tree tree) {
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case MODIFIERS: 
            case COMPILATION_UNIT: 
            case PRIMITIVE_TYPE: {
                return true;
            }
        }
        return false;
    }

    private void lookForTrailing(TokenSequence<JavaTokenId> tokenSequence, Tree tree) {
        tokenSequence.move((int)this.positions.getEndPosition(this.unit, tree));
        LinkedList<TrailingCommentsDataHolder> linkedList = new LinkedList<TrailingCommentsDataHolder>();
        int n = 0;
        int n2 = 0;
        while (tokenSequence.moveNext()) {
            if (tokenSequence.index() <= this.tokenIndexAlreadyAdded) continue;
            Token token = tokenSequence.token();
            if (token.id() == JavaTokenId.WHITESPACE) {
                n2 += this.numberOfNL((Token<JavaTokenId>)token);
                continue;
            }
            if (this.isComment((JavaTokenId)token.id())) {
                linkedList.add(new TrailingCommentsDataHolder(n2, (Token<JavaTokenId>)token, tokenSequence.index()));
                n = Math.max(n, n2);
                if (token.id() == JavaTokenId.LINE_COMMENT) {
                    n2 = 1;
                    continue;
                }
                n2 = 0;
                continue;
            }
            if (token.id() != JavaTokenId.RBRACE) break;
            n = Integer.MAX_VALUE;
            break;
        }
        int n3 = tokenSequence.index() - 1;
        n = Math.max(n, n2);
        for (TrailingCommentsDataHolder trailingCommentsDataHolder : linkedList) {
            if (trailingCommentsDataHolder.newlines < n) {
                this.attachComments(Collections.singleton(trailingCommentsDataHolder.comment), tree, this.commentService, CommentSet.RelativePosition.TRAILING);
                continue;
            }
            n3 = trailingCommentsDataHolder.index;
            break;
        }
        this.tokenIndexAlreadyAdded = n3;
    }

    private void lookWithinEmptyBlock(TokenSequence<JavaTokenId> tokenSequence, BlockTree blockTree) {
        if (this.moveTo(tokenSequence, JavaTokenId.LBRACE, true)) {
            if (tokenSequence.moveNext()) {
                CommentsCollection commentsCollection = this.getCommentsCollection(tokenSequence, Integer.MAX_VALUE);
                this.attachComments(blockTree, commentsCollection, CommentSet.RelativePosition.INNER);
            }
        } else {
            int n = (int)this.positions.getEndPosition(this.unit, blockTree);
            tokenSequence.move(n);
            tokenSequence.moveNext();
        }
    }

    private boolean moveTo(TokenSequence<JavaTokenId> tokenSequence, JavaTokenId javaTokenId, boolean bl) {
        do {
            if (javaTokenId != tokenSequence.token().id()) continue;
            return true;
        } while (!bl ? tokenSequence.movePrevious() : tokenSequence.moveNext());
        return false;
    }

    private void lookForPreceedings(TokenSequence<JavaTokenId> tokenSequence, Tree tree) {
        int n = ((JCTree)tree).pos;
        CommentsCollection commentsCollection = null;
        while (tokenSequence.moveNext() && tokenSequence.offset() < n) {
            JavaTokenId javaTokenId = (JavaTokenId)tokenSequence.token().id();
            if (!this.isComment(javaTokenId)) continue;
            if (commentsCollection == null) {
                commentsCollection = this.getCommentsCollection(tokenSequence, Integer.MAX_VALUE);
                continue;
            }
            commentsCollection.merge(this.getCommentsCollection(tokenSequence, Integer.MAX_VALUE));
        }
        this.attachComments(commentsCollection, tree, this.commentService, CommentSet.RelativePosition.PRECEDING);
        tokenSequence.move(n);
        tokenSequence.moveNext();
        this.tokenIndexAlreadyAdded = tokenSequence.index();
    }

    private int findInterestingStart(JCTree jCTree) {
        int n = (int)this.positions.getStartPosition(this.unit, jCTree);
        if (n <= 0) {
            return 0;
        }
        this.seq.move(n);
        block4: while (this.seq.movePrevious() && this.tokenIndexAlreadyAdded < this.seq.index()) {
            switch ((JavaTokenId)this.seq.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case JAVADOC_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block4;
                }
                case LBRACE: {
                    return this.seq.offset() + this.seq.token().length();
                }
            }
            return this.seq.offset() + this.seq.token().length();
        }
        return this.seq.offset();
    }

    private void consumeWS(TokenSequence<JavaTokenId> tokenSequence, boolean bl) {
        block3: while (bl ? tokenSequence.moveNext() : tokenSequence.movePrevious()) {
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case WHITESPACE: {
                    continue block3;
                }
            }
            return;
        }
    }

    private int adjustByComments(int n, CommentSetImpl commentSetImpl) {
        List<Comment> list = commentSetImpl.getComments(CommentSet.RelativePosition.INLINE);
        if (!list.isEmpty()) {
            for (Comment comment : list) {
                n = Math.max(n, comment.endPos());
            }
        }
        if (!(list = commentSetImpl.getComments(CommentSet.RelativePosition.TRAILING)).isEmpty()) {
            for (Comment comment : list) {
                n = Math.max(n, comment.endPos());
            }
        }
        return n;
    }

    private void skipEvil(TokenSequence<JavaTokenId> tokenSequence) {
        do {
            JavaTokenId javaTokenId = (JavaTokenId)tokenSequence.token().id();
            switch (javaTokenId) {
                case WHITESPACE: 
                case PUBLIC: 
                case PRIVATE: 
                case PROTECTED: 
                case ABSTRACT: 
                case FINAL: 
                case STATIC: 
                case VOID: 
                case VOLATILE: 
                case NATIVE: 
                case STRICTFP: 
                case INT: 
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case CONST: 
                case LONG: {
                    break;
                }
                default: {
                    return;
                }
            }
        } while (tokenSequence.moveNext());
    }

    private double belongsTo(int n, int n2, TokenSequence<JavaTokenId> tokenSequence) {
        int n3 = tokenSequence.index();
        double d = this.getForwardWeight(n2, tokenSequence) - this.getBackwardWeight(n, tokenSequence);
        tokenSequence.moveIndex(n3);
        tokenSequence.moveNext();
        return d;
    }

    private double getForwardWeight(int n, TokenSequence<JavaTokenId> tokenSequence) {
        double d = 0.0;
        tokenSequence.move(n);
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                int n2 = this.numberOfNL((Token<JavaTokenId>)tokenSequence.token());
                d = n2 == 0 ? 1.0 : (double)(1 / n2);
                continue;
            }
            if (!this.isComment((JavaTokenId)tokenSequence.token().id())) break;
            if (tokenSequence.token().id() == JavaTokenId.LINE_COMMENT) {
                return 1.0;
            }
            d = 0.0;
            break;
        }
        return d;
    }

    private double getBackwardWeight(int n, TokenSequence<JavaTokenId> tokenSequence) {
        double d = 0.0;
        tokenSequence.move(n);
        while (tokenSequence.movePrevious()) {
            if (tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                int n2 = this.numberOfNL((Token<JavaTokenId>)tokenSequence.token());
                d = n2 == 0 ? 0.0 : (double)(1 / n2);
                continue;
            }
            if (!this.isComment((JavaTokenId)tokenSequence.token().id())) break;
            d = 0.0;
            break;
        }
        return d;
    }

    private void attachComments(Iterable<? extends Token<JavaTokenId>> iterable, Tree tree, CommentHandler commentHandler, CommentSet.RelativePosition relativePosition) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            return;
        }
        CommentSet commentSet = this.createCommentSet(commentHandler, tree);
        for (Token<JavaTokenId> token : iterable) {
            this.attachComment(relativePosition, commentSet, token);
        }
    }

    private void attachComment(CommentSet.RelativePosition relativePosition, CommentSet commentSet, Token<JavaTokenId> token) {
        Comment comment = Comment.create(this.getStyle((JavaTokenId)token.id()), token.offset(null), this.getEndPos(token), -2, this.getText(token));
        commentSet.addComment(relativePosition, comment);
    }

    private String getText(Token<JavaTokenId> token) {
        return String.valueOf(token.text());
    }

    private int getEndPos(Token<JavaTokenId> token) {
        return token.offset(null) + token.length();
    }

    private Comment.Style getStyle(JavaTokenId javaTokenId) {
        switch (javaTokenId) {
            case JAVADOC_COMMENT: {
                return Comment.Style.JAVADOC;
            }
            case LINE_COMMENT: {
                return Comment.Style.LINE;
            }
            case BLOCK_COMMENT: {
                return Comment.Style.BLOCK;
            }
        }
        return Comment.Style.WHITESPACE;
    }

    private int[] getBounds(JCTree jCTree) {
        return new int[]{(int)this.positions.getStartPosition(this.unit, jCTree), (int)this.positions.getEndPosition(this.unit, jCTree)};
    }

    private Tree getTree(TreeUtilities treeUtilities, TokenSequence<JavaTokenId> tokenSequence) {
        TreePath treePath;
        int n = tokenSequence.offset();
        if (tokenSequence.token().length() > 0) {
            ++n;
        }
        if ((treePath = treeUtilities.pathFor(n)) != null) {
            return treePath.getLeaf();
        }
        return null;
    }

    private int numberOfNL(Token<JavaTokenId> token) {
        int n = 0;
        CharSequence charSequence = token.text();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if ('\n' != c) continue;
            ++n;
        }
        return n;
    }

    private CommentsCollection getCommentsCollection(TokenSequence<JavaTokenId> tokenSequence, int n) {
        CommentsCollection commentsCollection = new CommentsCollection();
        Token token = tokenSequence.token();
        commentsCollection.add((Token<JavaTokenId>)token);
        boolean bl = token.id() == JavaTokenId.LINE_COMMENT;
        int n2 = tokenSequence.index();
        int n3 = tokenSequence.offset();
        int n4 = tokenSequence.offset() + tokenSequence.token().length();
        while (tokenSequence.moveNext()) {
            if (tokenSequence.index() < this.tokenIndexAlreadyAdded) continue;
            token = tokenSequence.token();
            if (this.isComment((JavaTokenId)token.id())) {
                commentsCollection.add((Token<JavaTokenId>)token);
                n3 = Math.min(tokenSequence.offset(), n3);
                n4 = Math.max(tokenSequence.offset() + token.length(), n4);
                bl = token.id() == JavaTokenId.LINE_COMMENT;
                n2 = tokenSequence.index();
                continue;
            }
            if (token.id() == JavaTokenId.WHITESPACE && this.numberOfNL((Token<JavaTokenId>)token) + (bl ? 1 : 0) <= n) continue;
        }
        tokenSequence.moveIndex(n2);
        tokenSequence.moveNext();
        this.tokenIndexAlreadyAdded = tokenSequence.index();
        commentsCollection.setBounds(new int[]{n3, n4});
        return commentsCollection;
    }

    private CommentSet createCommentSet(CommentHandler commentHandler, Tree tree) {
        return commentHandler.getComments(tree);
    }

    private boolean isComment(JavaTokenId javaTokenId) {
        switch (javaTokenId) {
            case LINE_COMMENT: 
            case JAVADOC_COMMENT: 
            case BLOCK_COMMENT: {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommentsCollection
    implements Iterable<Token<JavaTokenId>> {
        private final int[] bounds = new int[]{-2, -2};
        private final List<Token<JavaTokenId>> comments = new LinkedList<Token<JavaTokenId>>();

        private CommentsCollection() {
        }

        void add(Token<JavaTokenId> token) {
            this.comments.add(token);
        }

        boolean isEmpty() {
            return this.comments.isEmpty();
        }

        @Override
        public Iterator<Token<JavaTokenId>> iterator() {
            return this.comments.iterator();
        }

        void setBounds(int[] nArray) {
            this.bounds[0] = nArray[0];
            this.bounds[1] = nArray[1];
        }

        public int[] getBounds() {
            return (int[])this.bounds.clone();
        }

        public void merge(CommentsCollection commentsCollection) {
            this.comments.addAll(commentsCollection.comments);
            this.bounds[0] = Math.min(this.bounds[0], commentsCollection.bounds[0]);
            this.bounds[1] = Math.max(this.bounds[1], commentsCollection.bounds[1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrailingCommentsDataHolder {
        private final int newlines;
        private final Token<JavaTokenId> comment;
        private final int index;

        public TrailingCommentsDataHolder(int n, Token<JavaTokenId> token, int n2) {
            this.newlines = n;
            this.comment = token;
            this.index = n2;
        }
    }
}

