/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.support.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.FileChooserUI;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AntArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private String artifactType;
    private JFileChooser chooser;
    private JButton approveButton;
    private JLabel jLabelJarFiles;
    private JLabel jLabelName;
    private JList jListArtifacts;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;

    public AntArtifactChooser(String string, JFileChooser jFileChooser) {
        this.artifactType = string;
        this.chooser = jFileChooser;
        this.initComponents();
        this.initAccessibility();
        this.jListArtifacts.setModel(new DefaultListModel());
        jFileChooser.addPropertyChangeListener(this);
        if (this.setValid(false)) {
            this.jListArtifacts.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    AntArtifactChooser.this.setValid(AntArtifactChooser.this.jListArtifacts.getSelectedIndex() >= 0);
                }
            });
        }
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelJarFiles = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListArtifacts = new JList();
        this.setLayout(new GridBagLayout());
        this.jLabelName.setLabelFor(this.jTextFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelName, (String)NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AAChooser_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelName, gridBagConstraints);
        this.jTextFieldName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabelJarFiles.setLabelFor(this.jListArtifacts);
        Mnemonics.setLocalizedText((JLabel)this.jLabelJarFiles, (String)NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AAChooser_JARFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelJarFiles, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jListArtifacts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void initAccessibility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setValid(boolean bl) {
        AntArtifactChooser antArtifactChooser = this;
        synchronized (antArtifactChooser) {
            if (this.approveButton == null) {
                try {
                    FileChooserUI fileChooserUI = this.chooser.getUI();
                    Method method = fileChooserUI.getClass().getDeclaredMethod("getApproveButton", JFileChooser.class);
                    method.setAccessible(true);
                    this.approveButton = (JButton)method.invoke((Object)fileChooserUI, this.chooser);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.approveButton != null) {
            this.approveButton.setEnabled(bl);
        }
        return this.approveButton != null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            File file = jFileChooser.getSelectedFile();
            Project project = this.getProject(file);
            this.populateAccessory(project);
        }
    }

    private Project getProject(File file) {
        if (file == null) {
            return null;
        }
        try {
            File file2 = FileUtil.normalizeFile((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file2);
            if (fileObject != null) {
                return ProjectManager.getDefault().findProject(fileObject);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return null;
    }

    private void populateAccessory(Project project) {
        DefaultListModel defaultListModel = (DefaultListModel)this.jListArtifacts.getModel();
        defaultListModel.clear();
        this.jTextFieldName.setText(project == null ? "" : ProjectUtils.getInformation((Project)project).getDisplayName());
        if (project != null) {
            AntArtifact[] antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)project, (String)this.artifactType);
            for (int i = 0; i < antArtifactArray.length; ++i) {
                URI[] uRIArray = antArtifactArray[i].getArtifactLocations();
                for (int j = 0; j < uRIArray.length; ++j) {
                    defaultListModel.addElement(new ArtifactItem(antArtifactArray[i], uRIArray[j]));
                }
            }
            this.jListArtifacts.setSelectionInterval(0, defaultListModel.size() - 1);
        }
    }

    private static Container findParent() {
        return DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)new JPanel(), "")).getParent();
    }

    public static ArtifactItem[] showDialog(String string) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AAChooserSelectProject"));
        jFileChooser.setApproveButtonText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AAChooser_AddJARFiles"));
        AntArtifactChooser antArtifactChooser = new AntArtifactChooser(string, jFileChooser);
        jFileChooser.setAccessory(antArtifactChooser);
        jFileChooser.setPreferredSize(new Dimension(650, 380));
        int n = jFileChooser.showOpenDialog(AntArtifactChooser.findParent());
        if (n == 0) {
            Object[] objectArray = antArtifactChooser.jListArtifacts.getSelectedValues();
            ArtifactItem[] artifactItemArray = new ArtifactItem[objectArray.length];
            System.arraycopy(objectArray, 0, artifactItemArray, 0, objectArray.length);
            return artifactItemArray;
        }
        return null;
    }

    public static class ArtifactItem {
        private final AntArtifact artifact;
        private final URI uri;

        ArtifactItem(AntArtifact antArtifact, URI uRI) {
            this.artifact = antArtifact;
            this.uri = uRI;
        }

        public AntArtifact getArtifact() {
            return this.artifact;
        }

        public URI getURI() {
            return this.uri;
        }

        public String toString() {
            return this.uri.getPath();
        }
    }
}

