/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.UserConfigurationTemplatesProvider;
import org.netbeans.modules.mobility.project.ui.customizer.CloneConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.CloneConfigurationPanel2;
import org.netbeans.modules.mobility.project.ui.customizer.CustomizerMIDP;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.NewConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.SaveConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ConfigurationsSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ConfigurationsSelectionPanelGUI;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class VisualConfigSupport {
    static final String PRIVATE_PREFIX = "private.";
    final JList configurationList;
    final JButton addConfigButton;
    final JButton addMoreButton;
    final JButton renameConfigButton;
    final JButton removeConfigButton;
    final JButton duplicateButton;
    final JButton saveButton;
    private final DefaultListModel configurationModel;
    J2MEProjectProperties properties;

    public VisualConfigSupport(JList jList, JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4, JButton jButton5, JButton jButton6) {
        this.configurationList = jList;
        this.configurationModel = new DefaultListModel();
        this.configurationList.setModel(this.configurationModel);
        this.configurationList.setCellRenderer(new ConfigurationCellRenderer());
        this.addConfigButton = jButton;
        this.addMoreButton = jButton2;
        this.renameConfigButton = jButton3;
        this.removeConfigButton = jButton4;
        this.duplicateButton = jButton5;
        this.saveButton = jButton6;
        ConfigSupportListener configSupportListener = new ConfigSupportListener();
        jButton.addActionListener(configSupportListener);
        jButton2.addActionListener(configSupportListener);
        jButton3.addActionListener(configSupportListener);
        jButton4.addActionListener(configSupportListener);
        jButton5.addActionListener(configSupportListener);
        jButton6.addActionListener(configSupportListener);
        jList.getSelectionModel().addListSelectionListener(configSupportListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyMap(J2MEProjectProperties j2MEProjectProperties) {
        this.properties = j2MEProjectProperties;
        ProjectConfiguration[] projectConfigurationArray = j2MEProjectProperties.getConfigurations();
        DefaultListModel defaultListModel = this.configurationModel;
        synchronized (defaultListModel) {
            this.configurationModel.clear();
            for (int i = 0; i < projectConfigurationArray.length; ++i) {
                this.configurationModel.addElement(projectConfigurationArray[i]);
            }
        }
        this.configurationList.setSelectedValue(j2MEProjectProperties.getActiveConfiguration(), true);
        this.refreshButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectConfiguration[] getConfigurationItems() {
        DefaultListModel defaultListModel = this.configurationModel;
        synchronized (defaultListModel) {
            ProjectConfiguration[] projectConfigurationArray = new ProjectConfiguration[this.configurationModel.getSize()];
            for (int i = 0; i < projectConfigurationArray.length; ++i) {
                projectConfigurationArray[i] = (ProjectConfiguration)this.configurationModel.getElementAt(i);
            }
            return projectConfigurationArray;
        }
    }

    protected void addNewConfig() {
        String string;
        ProjectConfiguration[] projectConfigurationArray = this.getConfigurationItems();
        HashSet<String> hashSet = new HashSet<String>(projectConfigurationArray.length);
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            hashSet.add(projectConfigurationArray[i].getDisplayName());
        }
        NewConfigurationPanel newConfigurationPanel = new NewConfigurationPanel(hashSet);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newConfigurationPanel, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_AddConfiguration"), true, 2, NotifyDescriptor.OK_OPTION, null);
        newConfigurationPanel.setDialogDescriptor(dialogDescriptor);
        String string2 = string = NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor)) ? newConfigurationPanel.getName() : null;
        if (string != null) {
            ProjectConfiguration projectConfiguration = new ProjectConfiguration(){

                public String getDisplayName() {
                    return string;
                }
            };
            this.configurationModel.addElement(projectConfiguration);
            this.configurationList.setSelectedValue(projectConfiguration, true);
            VisualConfigSupport.createFromTemplate(this.properties, string, newConfigurationPanel.getTemplate());
            this.fireActionPerformed();
        }
    }

    protected void addMoreConfigs() {
        ProjectConfiguration[] projectConfigurationArray = this.getConfigurationItems();
        HashSet<String> hashSet = new HashSet<String>(projectConfigurationArray.length);
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            hashSet.add(projectConfigurationArray[i].getDisplayName());
        }
        final ConfigurationsSelectionPanelGUI configurationsSelectionPanelGUI = new ConfigurationsSelectionPanelGUI(hashSet);
        final ErrorPanel errorPanel = new ErrorPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.getAccessibleContext().setAccessibleName(configurationsSelectionPanelGUI.getAccessibleContext().getAccessibleName());
        jPanel.getAccessibleContext().setAccessibleDescription(configurationsSelectionPanelGUI.getAccessibleContext().getAccessibleDescription());
        jPanel.add((Component)configurationsSelectionPanelGUI, "Center");
        jPanel.add((Component)errorPanel, "South");
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_AddConfiguration"), true, 2, NotifyDescriptor.OK_OPTION, null);
        configurationsSelectionPanelGUI.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = configurationsSelectionPanelGUI.valid();
                dialogDescriptor.setValid(bl);
                errorPanel.setErrorMessage(bl ? null : NbBundle.getMessage(ConfigurationsSelectionPanel.class, (String)"ERR_CfgSelPanel_NameCollision"));
            }
        });
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            for (ProjectConfigurationFactory.ConfigurationTemplateDescriptor configurationTemplateDescriptor : configurationsSelectionPanelGUI.getSelectedTemplates()) {
                final String string = configurationTemplateDescriptor.getCfgName();
                ProjectConfiguration projectConfiguration = new ProjectConfiguration(){

                    public String getDisplayName() {
                        return string;
                    }
                };
                this.configurationModel.addElement(projectConfiguration);
                this.configurationList.setSelectedValue(projectConfiguration, true);
                VisualConfigSupport.createFromTemplate(this.properties, string, configurationTemplateDescriptor);
            }
            this.fireActionPerformed();
        }
    }

    public static void createFromTemplate(J2MEProjectProperties j2MEProjectProperties, String string, ProjectConfigurationFactory.ConfigurationTemplateDescriptor configurationTemplateDescriptor) {
        if (configurationTemplateDescriptor == null) {
            return;
        }
        AntProjectHelper antProjectHelper = j2MEProjectProperties.getHelper();
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/private/private.properties");
        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/project.properties");
        String string2 = configurationTemplateDescriptor.getCfgName();
        String string3 = "configs." + string2 + '.';
        Map map = configurationTemplateDescriptor.getPrivateProperties();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (editableProperties.containsKey(entry.getKey())) continue;
                editableProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ((map = configurationTemplateDescriptor.getProjectGlobalProperties()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (editableProperties2.containsKey(entry.getKey())) continue;
                editableProperties2.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ((map = configurationTemplateDescriptor.getProjectConfigurationProperties()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                j2MEProjectProperties.putPropertyRawValue("configs." + string + '.' + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties2);
    }

    private static void fixPlatform(J2MEProjectProperties j2MEProjectProperties, String string, String string2) {
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
        int n = 0;
        int n2 = 0;
        for (int i = 0; n2 < 5 && i < javaPlatformArray.length; ++i) {
            int n3;
            if (!(javaPlatformArray[i] instanceof J2MEPlatform) || (n3 = VisualConfigSupport.ratePlatform((J2MEPlatform)javaPlatformArray[i], string2)) <= n2) continue;
            n2 = n3;
            n = i;
        }
        if (n2 > 0) {
            j2MEProjectProperties.putPropertyRawValue("configs." + string + '.' + "platform.active", ((J2MEPlatform)javaPlatformArray[n]).getName());
            CustomizerMIDP customizerMIDP = new CustomizerMIDP();
            customizerMIDP.initValues(j2MEProjectProperties, string);
            customizerMIDP.initGroupValues(true);
        }
    }

    private static int ratePlatform(J2MEPlatform j2MEPlatform, String string) {
        String string2 = j2MEPlatform.getName();
        if (string2.equals(string)) {
            return 5;
        }
        if (string2.indexOf(string) >= 0) {
            return 4;
        }
        if (string2.startsWith("J2ME_Wireless_Toolkit_2")) {
            return 3;
        }
        if (string2.startsWith("J2ME_Wireless_Toolkit")) {
            return 2;
        }
        return 1;
    }

    protected void duplicateElement() {
        Object[] objectArray = this.configurationList.getSelectedValues();
        assert (objectArray.length > 0) : "Duplicate button should be disabled";
        ProjectConfiguration[] projectConfigurationArray = this.getConfigurationItems();
        HashSet<String> hashSet = new HashSet<String>(projectConfigurationArray.length);
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            hashSet.add(projectConfigurationArray[i].getDisplayName());
        }
        if (objectArray.length == 1) {
            String string;
            CloneConfigurationPanel cloneConfigurationPanel = new CloneConfigurationPanel(hashSet);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)cloneConfigurationPanel, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_DuplConfiguration", (Object)((ProjectConfiguration)objectArray[0]).getDisplayName()), true, 2, NotifyDescriptor.OK_OPTION, null);
            cloneConfigurationPanel.setDialogDescriptor(dialogDescriptor);
            String string2 = string = NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor)) ? cloneConfigurationPanel.getName() : null;
            if (string != null) {
                this.copyProperties(((ProjectConfiguration)objectArray[0]).getDisplayName(), string);
                this.configurationList.setSelectedValue(this.addCfg(string), true);
                this.fireActionPerformed();
            }
        } else {
            HashSet<String> hashSet2 = new HashSet<String>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                hashSet2.add(((ProjectConfiguration)objectArray[i]).getDisplayName());
            }
            CloneConfigurationPanel2 cloneConfigurationPanel2 = new CloneConfigurationPanel2(hashSet, hashSet2);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)cloneConfigurationPanel2, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_DuplConfigurations"), true, 2, NotifyDescriptor.OK_OPTION, null);
            cloneConfigurationPanel2.setDialogDescriptor(dialogDescriptor);
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
                String string = cloneConfigurationPanel2.getPrefix();
                String string3 = cloneConfigurationPanel2.getSuffix();
                for (int i = 0; i < objectArray.length; ++i) {
                    ProjectConfiguration projectConfiguration = (ProjectConfiguration)objectArray[i];
                    String string4 = string + projectConfiguration.getDisplayName() + string3;
                    this.copyProperties(projectConfiguration.getDisplayName(), string4);
                    this.configurationList.setSelectedValue(this.addCfg(string4), true);
                }
                this.fireActionPerformed();
            }
        }
    }

    private ProjectConfiguration addCfg(final String string) {
        ProjectConfiguration projectConfiguration = new ProjectConfiguration(){

            public String getDisplayName() {
                return string;
            }
        };
        this.configurationModel.addElement(projectConfiguration);
        return projectConfiguration;
    }

    private void copyProperties(String string, String string2) {
        String[] stringArray = this.properties.keySet().toArray(new String[this.properties.size()]);
        String string3 = "configs." + string;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string3)) continue;
            Object object = this.properties.get(stringArray[i]);
            if (object instanceof Cloneable) {
                try {
                    Method method = object.getClass().getMethod("clone", new Class[0]);
                    if (method != null) {
                        object = method.invoke(object, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
            this.properties.put("configs." + string2 + stringArray[i].substring(string3.length()), object);
        }
    }

    protected void removeElement() {
        int n = this.configurationList.getSelectedIndex();
        assert (n > 0) : "Remove button should be disabled";
        Object[] objectArray = this.configurationList.getSelectedValues();
        StringBuffer stringBuffer = new StringBuffer(((ProjectConfiguration)objectArray[0]).getDisplayName());
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append("\", \"").append(((ProjectConfiguration)objectArray[i]).getDisplayName());
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_ReallyRemove", (Object)stringBuffer), 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                this.configurationModel.removeElement(objectArray[i]);
                this.removeProperties(((ProjectConfiguration)objectArray[i]).getDisplayName());
            }
            this.configurationList.setSelectedIndex(n < this.configurationModel.getSize() ? n : n - 1);
            this.fireActionPerformed();
        }
    }

    protected void renameElement() {
        Object[] objectArray = this.configurationList.getSelectedValues();
        assert (objectArray.length > 0) : "Rename button should be disabled";
        for (Object object : objectArray) {
            ProjectConfiguration projectConfiguration = (ProjectConfiguration)object;
            ProjectConfiguration[] projectConfigurationArray = this.getConfigurationItems();
            HashSet<String> hashSet = new HashSet<String>(projectConfigurationArray.length);
            for (int i = 0; i < projectConfigurationArray.length; ++i) {
                hashSet.add(projectConfigurationArray[i].getDisplayName());
            }
            CloneConfigurationPanel cloneConfigurationPanel = new CloneConfigurationPanel(hashSet);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)cloneConfigurationPanel, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_RenConfiguration", (Object)projectConfiguration.getDisplayName()), true, 2, NotifyDescriptor.OK_OPTION, null);
            cloneConfigurationPanel.setDialogDescriptor(dialogDescriptor);
            Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (NotifyDescriptor.OK_OPTION.equals(object2)) {
                String string = cloneConfigurationPanel.getName();
                this.copyProperties(projectConfiguration.getDisplayName(), string);
                this.removeProperties(projectConfiguration.getDisplayName());
                this.configurationModel.removeElement(projectConfiguration);
                this.configurationList.setSelectedValue(this.addCfg(string), true);
                this.fireActionPerformed();
                continue;
            }
            if (!NotifyDescriptor.CANCEL_OPTION.equals(object2)) continue;
            return;
        }
    }

    private void removeProperties(String string) {
        String[] stringArray = this.properties.keySet().toArray(new String[this.properties.size()]);
        String string2 = "configs." + string;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string2)) continue;
            this.properties.remove(stringArray[i]);
        }
    }

    protected void saveElement() {
        Object[] objectArray = this.configurationList.getSelectedValues();
        assert (objectArray.length > 0) : "Save button should be disabled";
        FileObject[] fileObjectArray = VisualConfigSupport.getConfigurationTemplates();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            hashSet.add(fileObjectArray[i].getName());
        }
        JButton jButton = new JButton(NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_SaveBtn"));
        jButton.setMnemonic(NbBundle.getMessage(VisualConfigSupport.class, (String)"MNM_VCS_SaveBtn").charAt(0));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VisualConfigSupport.class, (String)"ACSD_VCS_SaveBtn"));
        for (Object object : objectArray) {
            ProjectConfiguration projectConfiguration = (ProjectConfiguration)object;
            SaveConfigurationPanel saveConfigurationPanel = new SaveConfigurationPanel(projectConfiguration.getDisplayName() + UserConfigurationTemplatesProvider.CFG_TEMPLATE_SUFFIX, hashSet, jButton);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)saveConfigurationPanel, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_SaveConfiguration", (Object)projectConfiguration.getDisplayName()), true, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton, 0, new HelpCtx(SaveConfigurationPanel.class), null);
            Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (jButton.equals(object2)) {
                this.saveConfigurationTemplate(projectConfiguration.getDisplayName(), saveConfigurationPanel.getName());
                continue;
            }
            if (!DialogDescriptor.CANCEL_OPTION.equals(object2)) continue;
            return;
        }
    }

    public static FileObject[] getConfigurationTemplates() {
        TreeSet<FileObject> treeSet = new TreeSet<FileObject>(new Comparator<FileObject>(){

            @Override
            public int compare(FileObject fileObject, FileObject fileObject2) {
                return fileObject.getName().compareTo(fileObject2.getName());
            }
        });
        FileObject fileObject = FileUtil.getConfigFile((String)"Templates/J2MEProjectConfigurations");
        if (fileObject != null) {
            Enumeration enumeration = fileObject.getData(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (!"cfg".equals(fileObject2.getExt()) || !Utilities.isJavaIdentifier((String)fileObject2.getName())) continue;
                treeSet.add(fileObject2);
            }
        }
        return treeSet.toArray(new FileObject[treeSet.size()]);
    }

    private void saveConfigurationTemplate(final String string, final String string2) {
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    FileLock fileLock = null;
                    OutputStream outputStream = null;
                    try {
                        FileObject fileObject = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)("Templates/J2MEProjectConfigurations/" + string2 + '.' + "cfg"));
                        fileLock = fileObject.lock();
                        outputStream = fileObject.getOutputStream(fileLock);
                        VisualConfigSupport.this.extractConfigurationTemplate(string, string2).store(outputStream, null);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    protected Properties extractConfigurationTemplate(String string, String string2) {
        Properties properties = new Properties();
        String[] stringArray = this.properties.keySet().toArray(new String[this.properties.size()]);
        String string3 = "configs." + string + '.';
        String string4 = "configs." + string2 + '.';
        String string5 = "configs." + string + '.' + "libs.classpath";
        int n = string3.length();
        String string6 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string7;
            if (!stringArray[i].startsWith(string3) || (string7 = this.properties.getPropertyRawValue(stringArray[i])) == null) continue;
            properties.put(string4 + stringArray[i].substring(n), string7);
            if (!string5.equals(stringArray[i])) continue;
            string6 = string7;
        }
        if (string6 != null) {
            this.processReferences(properties, string6, this.properties.getHelper().getProperties("nbproject/project.properties"), this.properties.getHelper().getProperties("nbproject/private/private.properties"));
        }
        return properties;
    }

    private void processReferences(Properties properties, String string, EditableProperties editableProperties, EditableProperties editableProperties2) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf("${", n2)) >= 0) {
            n2 = string.indexOf(125, n);
            if (n2 < 0) {
                return;
            }
            String string2 = string.substring(n + 2, n2);
            if (properties.contains(string2) || properties.contains(PRIVATE_PREFIX + string2)) continue;
            String string3 = editableProperties2.getProperty(string2);
            if (string3 != null) {
                properties.put(PRIVATE_PREFIX + string2, string3);
                this.processReferences(properties, string3, editableProperties, editableProperties2);
            }
            if ((string3 = editableProperties.getProperty(string2)) == null) continue;
            if (string3.indexOf(36) < 0) {
                properties.put(PRIVATE_PREFIX + string2, this.properties.getHelper().resolvePath(string3));
                continue;
            }
            properties.put(string2, string3);
            this.processReferences(properties, string3, editableProperties, editableProperties2);
        }
    }

    protected void refreshButtons() {
        boolean bl = this.configurationList.getSelectedIndex() > 0;
        this.renameConfigButton.setEnabled(bl);
        this.removeConfigButton.setEnabled(bl);
        this.duplicateButton.setEnabled(bl);
        this.saveButton.setEnabled(bl);
    }

    private void fireActionPerformed() {
        this.refreshButtons();
        this.properties.setConfigurations(this.getConfigurationItems());
        this.properties.setActiveConfiguration((ProjectConfiguration)this.configurationList.getSelectedValue());
    }

    private static class ConfigurationCellRenderer
    extends DefaultListCellRenderer {
        private ConfigurationCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ProjectConfiguration) {
                this.setText(((ProjectConfiguration)object).getDisplayName());
            }
            return this;
        }
    }

    private class ConfigSupportListener
    implements ActionListener,
    ListSelectionListener {
        private ConfigSupportListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == VisualConfigSupport.this.addConfigButton) {
                VisualConfigSupport.this.addNewConfig();
            } else if (object == VisualConfigSupport.this.addMoreButton) {
                VisualConfigSupport.this.addMoreConfigs();
            } else if (object == VisualConfigSupport.this.renameConfigButton) {
                VisualConfigSupport.this.renameElement();
            } else if (object == VisualConfigSupport.this.removeConfigButton) {
                VisualConfigSupport.this.removeElement();
            } else if (object == VisualConfigSupport.this.duplicateButton) {
                VisualConfigSupport.this.duplicateElement();
            } else if (object == VisualConfigSupport.this.saveButton) {
                VisualConfigSupport.this.saveElement();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            VisualConfigSupport.this.refreshButtons();
            VisualConfigSupport.this.properties.setActiveConfiguration((ProjectConfiguration)VisualConfigSupport.this.configurationList.getSelectedValue());
        }
    }
}

