/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.project.ui.customizer.CustomizerJad;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAttributePanel
extends JPanel
implements ActionListener,
DocumentListener {
    private DialogDescriptor dd;
    private boolean editing;
    private HashSet<String> keys;
    private boolean mandatory;
    private String originalKey;
    private CustomizerJad.StorableTableModel tableModel;
    private final HashSet<String> bannedNames;
    private final HashSet<String> riskyNames;
    private HashSet<String> allNames;
    private JComboBox cKey;
    private JComboBox cPlacement;
    private ErrorPanel errorPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField tValue;

    public AddAttributePanel() {
        this.initComponents();
        this.initAccessibility();
        this.cPlacement.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(AddAttributePanel.class, (String)"LBL_Attr_Placement_Both"), NbBundle.getMessage(AddAttributePanel.class, (String)"LBL_Attr_Placement_JAD"), NbBundle.getMessage(AddAttributePanel.class, (String)"LBL_Attr_Placement_Manifest")}));
        this.bannedNames = new HashSet();
        this.bannedNames.add("MIDlet-Jar-RSA-SHA1");
        this.bannedNames.add("MIDlet-Jar-Size");
        this.bannedNames.add("MIDlet-Jar-URL");
        this.bannedNames.add("MIDlet-Permissions");
        this.bannedNames.add("MIDlet-Permissions-Opt");
        this.riskyNames = new HashSet();
        this.riskyNames.add("MicroEdition-Configuration");
        this.riskyNames.add("MicroEdition-Profile");
    }

    public void init(boolean bl, CustomizerJad.StorableTableModel storableTableModel, HashSet<String> hashSet, String string, String string2) {
        Object object;
        Serializable serializable;
        this.keys = hashSet;
        this.editing = bl;
        this.tableModel = storableTableModel;
        this.allNames = new HashSet<String>(Arrays.asList(storableTableModel.getAllAttrs()));
        if (!storableTableModel.isMIDP2()) {
            this.riskyNames.add("MIDlet-Install-Notify");
            this.riskyNames.add("MIDlet-Delete-Notify");
            this.riskyNames.add("MIDlet-Delete-Confirm");
        }
        this.originalKey = string;
        this.jLabel4.setVisible("MIDlet-Version".equals(string));
        if (bl) {
            this.cKey.setModel(new DefaultComboBoxModel<String>(storableTableModel.getNonMandatory()));
            this.cKey.getEditor().setItem(string);
            this.tValue.setText(string2);
            this.mandatory = storableTableModel.containsInMandatory(string);
            this.cKey.setEnabled(!this.mandatory);
        } else {
            serializable = new Vector<String>();
            object = storableTableModel.getAllAttrs();
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (hashSet.contains(object[i])) continue;
                serializable.add(object[i]);
            }
            this.cKey.setModel(new DefaultComboBoxModel(serializable));
            this.tValue.setText("");
            this.mandatory = false;
            this.cKey.setEnabled(true);
        }
        serializable = this.cKey.getEditor().getEditorComponent();
        if (serializable instanceof JTextComponent) {
            ((JTextComponent)serializable).getDocument().addDocumentListener(this);
        }
        this.tValue.getDocument().addDocumentListener(this);
        this.isStateValid();
        object = storableTableModel.getPlacement(string);
        this.cPlacement.setSelectedIndex(object == null ? 0 : (((Boolean)object).booleanValue() ? 1 : 2));
    }

    public String getKey() {
        return this.cKey.getEditor().getItem().toString();
    }

    public String getValue() {
        return this.tValue.getText();
    }

    public Boolean getPlacement() {
        int n = this.cPlacement.getSelectedIndex();
        return n == 0 ? null : (n == 1 ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dd = dialogDescriptor;
        this.dd.setHelpCtx(new HelpCtx(AddAttributePanel.class));
        this.actionPerformed(null);
    }

    public boolean isStateValid() {
        block15: {
            if (this.allNames.contains(this.getKey())) {
                this.cPlacement.setEnabled(false);
                this.cPlacement.setSelectedIndex(0);
            } else {
                this.cPlacement.setEnabled(true);
            }
            this.errorPanel.setErrorBundleMessage(null);
            if (this.getKey() == null || "".equals(this.getKey())) {
                this.errorPanel.setErrorBundleMessage("ERR_AddAttr_InvAttName");
                return false;
            }
            if (this.bannedNames.contains(this.getKey())) {
                this.errorPanel.setErrorBundleMessage("ERR_AddAttr_" + this.getKey());
                return false;
            }
            if (this.riskyNames.contains(this.getKey())) {
                this.errorPanel.setErrorBundleMessage("WARN_AddAttr_" + this.getKey());
            }
            if (this.getKey().startsWith("MIDlet-Certificate-")) {
                this.errorPanel.setErrorBundleMessage("ERR_AddAttr_Certificate");
                return false;
            }
            if (this.getKey().startsWith("MIDlet-Push-")) {
                this.errorPanel.setErrorBundleMessage("ERR_AddAttr_Push");
                return false;
            }
            if (this.editing) {
                if (this.mandatory && (this.getValue() == null || "".equals(this.getValue()))) {
                    this.errorPanel.setErrorBundleMessage("ERR_AddAttr_EmptyMandAttVal");
                    return false;
                }
            } else if (this.tableModel.containsInMandatory(this.getKey()) && (this.getValue() == null || "".equals(this.getValue()))) {
                this.errorPanel.setErrorBundleMessage("ERR_AddAttr_EmptyMandAttVal");
                return false;
            }
            if (!this.getKey().equals(this.originalKey) && this.keys.contains(this.getKey())) {
                this.errorPanel.setErrorBundleMessage("ERR_AddAttr_AttNameExists");
                return false;
            }
            if (this.getKey().startsWith("MIDlet-")) {
                String string = this.getKey().substring("MIDlet-".length());
                try {
                    Integer.parseInt(string);
                    this.errorPanel.setErrorBundleMessage("ERR_AddAttr_MIDlet");
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.tableModel.isAcceptable(this.getKey())) break block15;
                    this.errorPanel.setErrorBundleMessage("WARN_AddAttr_MIDlet");
                    return true;
                }
            }
        }
        return true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cKey = new JComboBox();
        this.jLabel2 = new JLabel();
        this.tValue = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cPlacement = new JComboBox();
        this.errorPanel = new ErrorPanel();
        this.setPreferredSize(new Dimension(500, 150));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.cKey);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddAttributePanel.class, (String)"LBL_Attr_Key"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.cKey.setEditable(true);
        this.cKey.setPreferredSize(new Dimension(300, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.cKey, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tValue);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AddAttributePanel.class, (String)"LBL_Attr_Value"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.tValue.setPreferredSize(new Dimension(300, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.tValue, gridBagConstraints);
        this.jLabel4.setLabelFor(this.tValue);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(AddAttributePanel.class, (String)"LBL_Attr_Expl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddAttributePanel.class, (String)"ACSD_AddAttribute_Hint"));
        this.jLabel3.setLabelFor(this.cPlacement);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(AddAttributePanel.class, (String)"LBL_Attr_Placement"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.cPlacement, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddAttributePanel.class, (String)"ACSN_AddAttribute"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddAttributePanel.class, (String)"ACSD_AddAttribute"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dd.setValid(this.isStateValid());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.actionPerformed(null);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.actionPerformed(null);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.actionPerformed(null);
    }
}

