/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.mobility.project.ui.FileMonitor;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

class MissingFileDetector {
    static int INTERVAL = 15000;
    static MissingFileDetector INSTANCE = new MissingFileDetector();
    private final Map<File, OneFileItem> monitorsToFiles = new ConcurrentHashMap<File, OneFileItem>();
    static boolean unitTest;
    volatile boolean firstRun;
    private volatile boolean listeningToMainWindow;
    private final RunnerAndWindowHandler windowRunner = new RunnerAndWindowHandler();
    private final RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this.windowRunner);
    volatile boolean active;
    private Window mainWindow;
    private volatile boolean shouldBeListening;

    private MissingFileDetector() {
        assert (unitTest || INSTANCE == null);
        this.task.setPriority(1);
        if (!unitTest) {
            this.findMainWindow();
        }
    }

    static void reset() {
        INSTANCE = new MissingFileDetector();
    }

    private void scheduleTask() {
        this.active = true;
        this.task.schedule(INTERVAL);
    }

    private void cancelTask() {
        this.active = false;
        this.task.cancel();
    }

    private boolean mainWindowIsActive() {
        return unitTest ? true : (this.mainWindow == null ? false : this.mainWindow.isActive());
    }

    private synchronized Window getMainWindow() {
        return this.mainWindow;
    }

    private synchronized void setMainWindow(Window window) {
        this.mainWindow = window;
    }

    private void findMainWindow() {
        this.firstRun = false;
        if (!unitTest) {
            Runnable runnable = new Runnable(){

                public void run() {
                    Frame frame = WindowManager.getDefault().getMainWindow();
                    MissingFileDetector.this.setMainWindow(frame);
                    if (MissingFileDetector.this.shouldBeListening) {
                        frame.addWindowListener(MissingFileDetector.this.windowRunner);
                        MissingFileDetector.this.scheduleTask();
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeLater(runnable);
            }
        }
    }

    public static void register(File file, FileMonitor fileMonitor) {
        if (file == null) {
            throw new NullPointerException("null file");
        }
        if (fileMonitor == null) {
            throw new NullPointerException("Null monitor");
        }
        INSTANCE._register(file, fileMonitor);
    }

    public static void unregister(File file, FileMonitor fileMonitor) {
        if (file == null) {
            throw new NullPointerException("null file");
        }
        if (fileMonitor == null) {
            throw new NullPointerException("Null monitor");
        }
        INSTANCE._unregister(file, fileMonitor);
    }

    private void remove(File file) {
        this.monitorsToFiles.remove(file);
        this.prune();
    }

    void _register(File file, FileMonitor fileMonitor) {
        if (this.firstRun) {
            this.findMainWindow();
        }
        if (!unitTest && !this.listeningToMainWindow) {
            this.startListening();
        }
        this.scheduleTask();
        OneFileItem oneFileItem = this.monitorsToFiles.get(file);
        if (oneFileItem == null) {
            oneFileItem = new OneFileItem(file);
            this.monitorsToFiles.put(file, oneFileItem);
        }
        oneFileItem.add(fileMonitor);
    }

    void _unregister(File file, FileMonitor fileMonitor) {
        OneFileItem oneFileItem = this.monitorsToFiles.get(file);
        if (oneFileItem != null) {
            oneFileItem.remove(fileMonitor);
            if (oneFileItem.notifyMonitorsAndCleanUpReferences(null)) {
                this.monitorsToFiles.remove(file);
            }
        }
        this.prune();
    }

    private void startListening() {
        this.shouldBeListening = true;
        if (!this.listeningToMainWindow && !unitTest) {
            this.listeningToMainWindow = true;
            Window window = this.getMainWindow();
            if (window != null) {
                window.addWindowListener(this.windowRunner);
            }
        }
        this.scheduleTask();
    }

    private void stopListening() {
        this.shouldBeListening = false;
        if (!unitTest && !this.listeningToMainWindow) {
            this.listeningToMainWindow = false;
            Window window = this.getMainWindow();
            if (window != null) {
                window.removeWindowListener(this.windowRunner);
            }
        }
        this.cancelTask();
    }

    private boolean isEmpty() {
        return this.monitorsToFiles.isEmpty();
    }

    private void prune() {
        for (File file : new HashSet<File>(this.monitorsToFiles.keySet())) {
            OneFileItem oneFileItem = this.monitorsToFiles.get(file);
            if (!oneFileItem.notifyMonitorsAndCleanUpReferences(null)) continue;
            this.monitorsToFiles.remove(file);
        }
        if (this.isEmpty()) {
            this.cancelTask();
            this.stopListening();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OneMonitorItem
    extends WeakReference<FileMonitor> {
        private final Exception exception;

        OneMonitorItem(FileMonitor fileMonitor) {
            super(fileMonitor);
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            this.exception = bl ? new Exception() : null;
        }
    }

    private static final class MonitorRunnableImpl
    implements MonitorRunnable {
        private final RunnableKinds kind;

        private MonitorRunnableImpl(RunnableKinds runnableKinds) {
            this.kind = runnableKinds;
        }

        public void run(FileMonitor fileMonitor) {
            switch (this.kind) {
                case CHANGED: {
                    fileMonitor.fileChanged();
                    break;
                }
                case CREATED: {
                    fileMonitor.fileCreated();
                    break;
                }
                case DELETED: {
                    fileMonitor.fileDeleted();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RunnableKinds {
        CREATED,
        CHANGED,
        DELETED;

    }

    private static interface MonitorRunnable {
        public void run(FileMonitor var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Notifier
    implements Runnable {
        private final List<? extends FileMonitor> monitors;
        private final MonitorRunnable notifier;

        private Notifier(List<? extends FileMonitor> list, MonitorRunnable monitorRunnable) {
            this.monitors = list;
            this.notifier = monitorRunnable;
        }

        @Override
        public void run() {
            for (FileMonitor fileMonitor : this.monitors) {
                this.notifier.run(fileMonitor);
            }
        }
    }

    private final class OneFileItem {
        private final File file;
        private final List<OneMonitorItem> monitors = Collections.synchronizedList(new LinkedList());
        private boolean exists;
        private long timestamp;

        OneFileItem(File file) {
            if (file == null) {
                throw new NullPointerException("Null file");
            }
            this.file = FileUtil.normalizeFile((File)file);
            this.timestamp = file.exists() ? file.lastModified() : 0L;
            this.exists = file.exists();
            MissingFileDetector.this.startListening();
        }

        private void notifyFileChanged() {
            if (this.notifyMonitorsAndCleanUpReferences(new MonitorRunnableImpl(RunnableKinds.CHANGED))) {
                MissingFileDetector.this.remove(this.file);
            }
        }

        private void notifyFileCreated() {
            if (this.notifyMonitorsAndCleanUpReferences(new MonitorRunnableImpl(RunnableKinds.CREATED))) {
                MissingFileDetector.this.remove(this.file);
            }
        }

        private void notifyFileDeleted() {
            if (this.notifyMonitorsAndCleanUpReferences(new MonitorRunnableImpl(RunnableKinds.DELETED))) {
                MissingFileDetector.this.remove(this.file);
            }
        }

        public boolean exists() {
            return this.file.exists();
        }

        public void add(FileMonitor fileMonitor) {
            OneMonitorItem oneMonitorItem;
            assert (fileMonitor != null) : "Monitor null";
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            this.notifyMonitorsAndCleanUpReferences(null);
            if (bl && (oneMonitorItem = this.checkDuplicate(fileMonitor)) != null) {
                throw new IllegalArgumentException("File monitor added twice: " + fileMonitor + "\nStack trace for when first added " + "listed below as cause", oneMonitorItem.exception);
            }
            this.monitors.add(new OneMonitorItem(fileMonitor));
        }

        public boolean remove(FileMonitor fileMonitor) {
            assert (fileMonitor != null) : "Null monitor";
            Iterator<OneMonitorItem> iterator = this.monitors.iterator();
            while (iterator.hasNext()) {
                OneMonitorItem oneMonitorItem = iterator.next();
                FileMonitor fileMonitor2 = (FileMonitor)oneMonitorItem.get();
                if (fileMonitor2 != null && !fileMonitor.equals(fileMonitor2)) continue;
                iterator.remove();
            }
            return this.monitors.isEmpty();
        }

        private OneMonitorItem checkDuplicate(FileMonitor fileMonitor) {
            Iterator<OneMonitorItem> iterator = this.monitors.iterator();
            while (iterator.hasNext()) {
                OneMonitorItem oneMonitorItem = iterator.next();
                FileMonitor fileMonitor2 = (FileMonitor)oneMonitorItem.get();
                if (fileMonitor2 == null) {
                    iterator.remove();
                    continue;
                }
                if (!fileMonitor.equals(fileMonitor2)) continue;
                return oneMonitorItem;
            }
            return null;
        }

        private boolean notifyMonitorsAndCleanUpReferences(MonitorRunnable monitorRunnable) {
            LinkedList<FileMonitor> linkedList = null;
            Iterator<OneMonitorItem> iterator = this.monitors.iterator();
            while (iterator.hasNext()) {
                OneMonitorItem oneMonitorItem = iterator.next();
                FileMonitor fileMonitor = (FileMonitor)oneMonitorItem.get();
                if (fileMonitor == null) {
                    iterator.remove();
                    continue;
                }
                if (monitorRunnable == null) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList<FileMonitor>();
                }
                linkedList.add(fileMonitor);
            }
            if (monitorRunnable != null && !linkedList.isEmpty()) {
                EventQueue.invokeLater(new Notifier(linkedList, monitorRunnable));
            }
            return this.monitors.isEmpty();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            OneFileItem oneFileItem = (OneFileItem)object;
            return this.file == oneFileItem.file || this.file.equals(oneFileItem.file);
        }

        public int hashCode() {
            int n = 7;
            n = 17 * n + (this.file != null ? this.file.hashCode() : 0);
            return n;
        }

        private void poll() {
            boolean bl = this.exists;
            long l = this.timestamp;
            this.exists = this.file.exists();
            if (bl != this.exists) {
                if (this.exists) {
                    this.notifyFileCreated();
                } else {
                    this.timestamp = 0L;
                    this.notifyFileDeleted();
                }
            } else {
                this.timestamp = this.file.lastModified();
                if (l != this.timestamp) {
                    this.notifyFileChanged();
                }
            }
            this.exists = this.file.exists();
        }
    }

    private class RunnerAndWindowHandler
    extends WindowAdapter
    implements Runnable {
        private RunnerAndWindowHandler() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            MissingFileDetector.this.scheduleTask();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            MissingFileDetector.this.cancelTask();
        }

        public void run() {
            MissingFileDetector.this.prune();
            if (!MissingFileDetector.this.isEmpty() && MissingFileDetector.this.mainWindowIsActive()) {
                MissingFileDetector.this.scheduleTask();
            }
            for (File file : MissingFileDetector.this.monitorsToFiles.keySet()) {
                OneFileItem oneFileItem = (OneFileItem)MissingFileDetector.this.monitorsToFiles.get(file);
                oneFileItem.poll();
            }
        }
    }
}

