/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.security;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import sun.security.tools.KeyTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreRepository
implements Externalizable,
PropertyChangeListener {
    public static boolean rememberPasswords = true;
    public static final String PROP_KEYSTORE_ADDED = "keystore_added";
    public static final String PROP_KEYSTORE_REMOVED = "keystore_removed";
    public static final String PROP_OPENED = "opened";
    private static final long serialVersionUID = -4428411825913512121L;
    private static transient boolean defaultKeyStoreInitialized = false;
    private static KeyStoreRepository repo;
    private static KeyStoreBean defaultKeyStore;
    private static final String PASSWORD = "password";
    private ArrayList<KeyStoreBean> keyStores = new ArrayList();
    private final transient Map<String, Object> passwords = Collections.synchronizedMap(new HashMap());
    PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public KeyStoreRepository() {
        if (defaultKeyStore != null) {
            this.keyStores.add(defaultKeyStore);
        }
    }

    public static boolean isDefaultKeystore(KeyStoreBean keyStoreBean) {
        if (!defaultKeyStoreInitialized) {
            KeyStoreRepository.getDefault();
        }
        return keyStoreBean != null && keyStoreBean == defaultKeyStore;
    }

    public static synchronized KeyStoreRepository getDefault() {
        if (repo == null) {
            defaultKeyStoreInitialized = true;
            File file = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            if (file != null) {
                file = new File(file, "j2me" + File.separator + "builtin.ks");
            }
            if (file != null) {
                KeyStoreBean keyStoreBean = KeyStoreBean.create(file.getAbsolutePath(), PASSWORD);
                if (!file.exists() && keyStoreBean.openKeyStore(true)) {
                    try {
                        keyStoreBean.addKeyToStore("trusted", "CN=trusted", PASSWORD, -1);
                        keyStoreBean.addKeyToStore("untrusted", "CN=untrusted", PASSWORD, -1);
                        keyStoreBean.addKeyToStore("minimal", "CN=minimal", PASSWORD, -1);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        keyStoreBean = null;
                    }
                }
                if ((defaultKeyStore = keyStoreBean) != null) {
                    defaultKeyStore.openKeyStore();
                    if (defaultKeyStore.isOpened()) {
                        for (KeyStoreBean.KeyAliasBean keyAliasBean : defaultKeyStore.aliasses()) {
                            keyAliasBean.setPassword(PASSWORD);
                            keyAliasBean.open();
                        }
                    }
                }
            }
            repo = (KeyStoreRepository)Lookup.getDefault().lookup(KeyStoreRepository.class);
        }
        return repo;
    }

    public static KeyStoreRepository createRepository() {
        return new KeyStoreRepository();
    }

    public Object getPassword(String string) {
        return this.passwords.get(string);
    }

    public Object putPassword(String string, Object object) {
        return this.passwords.put(string, object);
    }

    public Object removePassword(String string) {
        return this.passwords.remove(string);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException {
        this.keyStores = new ArrayList();
        if (defaultKeyStore != null) {
            this.keyStores.add(defaultKeyStore);
        }
        try {
            while (true) {
                KeyStoreBean keyStoreBean = (KeyStoreBean)objectInput.readObject();
                this.keyStores.add(keyStoreBean);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        for (KeyStoreBean keyStoreBean : this.keyStores) {
            if (keyStoreBean == defaultKeyStore) continue;
            objectOutput.writeObject(keyStoreBean);
        }
    }

    public List<KeyStoreBean> getKeyStores() {
        return this.keyStores;
    }

    public void addKeyStore(KeyStoreBean keyStoreBean) {
        if (keyStoreBean == null) {
            return;
        }
        if (this.getKeyStore(keyStoreBean.getKeyStorePath(), false) != null) {
            return;
        }
        this.keyStores.add(keyStoreBean);
        keyStoreBean.addPropertyChangeListener(this);
        this.propertyChangeSupport.firePropertyChange(PROP_KEYSTORE_ADDED, null, null);
    }

    public void removeKeyStore(KeyStoreBean keyStoreBean) {
        keyStoreBean.removePropertyChangeListener(this);
        this.keyStores.remove(keyStoreBean);
        this.propertyChangeSupport.firePropertyChange(PROP_KEYSTORE_REMOVED, null, null);
    }

    public KeyStoreBean getKeyStore(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        for (KeyStoreBean keyStoreBean : this.keyStores) {
            if (!KeyStoreBean.equalFiles(keyStoreBean.getKeyStoreFile(), file)) continue;
            return keyStoreBean;
        }
        if (!bl) {
            return null;
        }
        KeyStoreBean keyStoreBean = KeyStoreBean.create(string);
        this.addKeyStore(keyStoreBean);
        return keyStoreBean;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyStoreBean
    implements Externalizable {
        private static final long serialVersionUID = -38422947758836052L;
        public static final String PROP_PASSWORD = "password";
        public static final String PROP_PATH2KEY_STORE = "pathToKeyStore";
        public static final String PROP_TYPE = "type";
        PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        private File keyStoreFile;
        private String password;
        private String type;
        private static final String JKS = "JKS";
        private transient boolean opened = false;
        private transient KeyStore store;
        private transient TreeSet<KeyAliasBean> aliasses = new TreeSet();

        public static KeyStoreBean create(String string) {
            if (string == null) {
                return null;
            }
            KeyStoreBean keyStoreBean = new KeyStoreBean();
            keyStoreBean.keyStoreFile = new File(string);
            keyStoreBean.type = (string = string.toLowerCase()).endsWith(".pkcs12") || string.endsWith(".p12") ? "PKCS12" : JKS;
            return keyStoreBean;
        }

        public static KeyStoreBean create(String string, String string2) {
            KeyStoreBean keyStoreBean = KeyStoreBean.create(string);
            keyStoreBean.password = string2;
            return keyStoreBean;
        }

        public boolean isValid() {
            return this.keyStoreFile.exists() && this.keyStoreFile.isFile();
        }

        public String getType() {
            if (this.type == null) {
                return JKS;
            }
            return this.type;
        }

        public void setType(String string) {
            String string2;
            String string3 = string2 = string == null ? JKS : string.toUpperCase();
            if (!"PKCS12".equals(string2)) {
                string2 = JKS;
            }
            if (!string2.equals(this.type)) {
                this.type = string2;
                this.propertyChangeSupport.firePropertyChange(PROP_TYPE, null, null);
            }
        }

        public File getKeyStoreFile() {
            return this.keyStoreFile;
        }

        public String getKeyStorePath() {
            return this.keyStoreFile.getAbsolutePath();
        }

        public void setKeyStoreFile(File file) {
            this.keyStoreFile = file;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public boolean isOpened() {
            return this.opened;
        }

        public KeyStore getStore() {
            return this.store;
        }

        public Set<KeyAliasBean> aliasses() {
            return Collections.unmodifiableSet(this.aliasses);
        }

        public KeyAliasBean getAlias(String string) {
            for (KeyAliasBean keyAliasBean : this.aliasses) {
                if (!string.equals(keyAliasBean.getAlias())) continue;
                return keyAliasBean;
            }
            return null;
        }

        public boolean openKeyStore() {
            return this.openKeyStore(false);
        }

        public synchronized boolean openKeyStore(boolean bl) {
            block16: {
                if (this.opened) {
                    return true;
                }
                this.clearAliasses();
                if (this.getPassword() == null) {
                    return false;
                }
                try {
                    this.store = "PKCS12".equals(this.type) ? KeyStore.getInstance("pkcs12", "SunJSSE") : KeyStore.getInstance(JKS, "SUN");
                    if (this.keyStoreFile.exists()) {
                        FileInputStream fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(this.keyStoreFile);
                            this.store.load(fileInputStream, this.password.toCharArray());
                            break block16;
                        }
                        catch (IOException iOException) {
                            throw iOException;
                        }
                        finally {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                    }
                    this.store.load(null, this.password.toCharArray());
                    if (!bl) {
                        return false;
                    }
                    this.storeKeyStore();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return false;
                }
                catch (CertificateException certificateException) {
                    return false;
                }
                catch (KeyStoreException keyStoreException) {
                    return false;
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            this.opened = true;
            this.loadAliasses(null);
            this.propertyChangeSupport.firePropertyChange(KeyStoreRepository.PROP_OPENED, false, true);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public boolean storeKeyStore() throws IOException {
            if (KeyStoreRepository.isDefaultKeystore(this)) {
                return false;
            }
            if (this.store == null) {
                return false;
            }
            FileOutputStream fileOutputStream = null;
            try {
                File file;
                if (!this.keyStoreFile.exists() && (file = this.keyStoreFile.getParentFile()) != null && !file.exists()) {
                    file.mkdirs();
                }
                fileOutputStream = new FileOutputStream(this.keyStoreFile);
                this.store.store(fileOutputStream, this.password.toCharArray());
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (KeyStoreException keyStoreException) {
                boolean bl = false;
                return bl;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                boolean bl = false;
                return bl;
            }
            catch (CertificateException certificateException) {
                boolean bl = false;
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return true;
        }

        public boolean closeKeyStore() {
            this.opened = false;
            this.store = null;
            this.propertyChangeSupport.firePropertyChange(KeyStoreRepository.PROP_OPENED, true, false);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() throws IOException {
            TreeSet<KeyAliasBean> treeSet = this.aliasses;
            this.clearAliasses();
            if (this.getPassword() == null) {
                return;
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.keyStoreFile);
                this.store.load(fileInputStream, this.password.toCharArray());
                this.loadAliasses(treeSet);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (CertificateException certificateException) {
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }

        private void clearAliasses() {
            this.aliasses = new TreeSet();
        }

        private void loadAliasses(TreeSet<KeyAliasBean> treeSet) {
            this.aliasses = new TreeSet();
            try {
                Enumeration<String> enumeration = this.store.aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (!this.store.isKeyEntry(string)) continue;
                    KeyAliasBean keyAliasBean = new KeyAliasBean(this.store, string);
                    if (treeSet != null) {
                        keyAliasBean.getAlias();
                        for (KeyAliasBean keyAliasBean2 : treeSet) {
                            if (!keyAliasBean.equals(keyAliasBean2)) continue;
                            keyAliasBean.setPassword(keyAliasBean2.getPassword());
                            if (!keyAliasBean2.isOpened()) break;
                            keyAliasBean.open();
                            break;
                        }
                    }
                    this.aliasses.add(keyAliasBean);
                }
            }
            catch (KeyStoreException keyStoreException) {
                this.aliasses = new TreeSet();
            }
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.getKeyStorePath());
            objectOutput.writeUTF(this.getType());
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException {
            this.keyStoreFile = new File(objectInput.readUTF());
            this.type = objectInput.readUTF();
        }

        public KeyAliasBean addKeyToStore(String string, String string2, String string3, int n) throws IOException {
            if (KeyStoreRepository.isDefaultKeystore(this)) {
                return null;
            }
            if (string == null) {
                return null;
            }
            if (string3 == null || "".equals(string3)) {
                string3 = this.getPassword();
            }
            if (n == -1) {
                n = 180;
            }
            String[] stringArray = new String[]{"-genkey", "-alias", string, "-keyalg", "RSA", "-dname", string2, "-keystore", this.getKeyStorePath(), "-storepass", this.getPassword(), "-keypass", string3, "-storetype", this.getType(), "-validity", String.valueOf(n)};
            try {
                KeyTool.main((String[])stringArray);
            }
            catch (Exception exception) {
                return null;
            }
            this.refresh();
            return this.getAlias(string);
        }

        public KeyAliasBean createInvalidKeyAliasBean(String string) {
            KeyAliasBean keyAliasBean = new KeyAliasBean(this.store, string);
            keyAliasBean.invalidate();
            return keyAliasBean;
        }

        public boolean removeAliasFromStore(KeyAliasBean keyAliasBean) throws IOException {
            if (KeyStoreRepository.isDefaultKeystore(this)) {
                return false;
            }
            if (!this.opened || keyAliasBean == null) {
                return false;
            }
            try {
                this.store.deleteEntry(keyAliasBean.getAlias());
                this.storeKeyStore();
                this.loadAliasses(this.aliasses);
                return true;
            }
            catch (KeyStoreException keyStoreException) {
                return false;
            }
        }

        public static boolean equalFiles(File file, File file2) {
            file = FileUtil.normalizeFile((File)file);
            file2 = FileUtil.normalizeFile((File)file2);
            return file != null && file.equals(file2);
        }

        public boolean equals(Object object) {
            if (object instanceof KeyStoreBean) {
                KeyStoreBean keyStoreBean = (KeyStoreBean)object;
                return KeyStoreBean.equalFiles(this.getKeyStoreFile(), keyStoreBean.getKeyStoreFile());
            }
            if (object instanceof String) {
                return KeyStoreBean.equalFiles(this.getKeyStoreFile(), new File((String)object));
            }
            return false;
        }

        public int hashCode() {
            File file = this.getKeyStoreFile();
            return file != null ? FileUtil.normalizeFile((File)file).hashCode() : super.hashCode();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public static class KeyAliasBean
        implements Comparable {
            private final KeyStore store;
            private final String alias;
            private String password;
            private boolean opened;
            private boolean valid;
            private String issuerName;
            private String subjectName;
            private String serialNumber;
            private Date notBefore;
            private Date notAfter;
            private String md5;
            private String sha;

            public KeyAliasBean(KeyStore keyStore, String string) {
                this.store = keyStore;
                this.alias = string;
                this.opened = false;
                this.valid = true;
            }

            public void invalidate() {
                this.valid = false;
            }

            public void setPassword(String string) {
                this.password = string;
            }

            public boolean isOpened() {
                return this.opened;
            }

            public boolean isValid() {
                return this.valid;
            }

            public boolean open() {
                if (this.opened) {
                    return true;
                }
                if (!this.valid || this.alias == null || this.password == null) {
                    return false;
                }
                try {
                    this.store.getKey(this.alias, this.password.toCharArray());
                    Certificate certificate = this.store.getCertificate(this.alias);
                    if (certificate instanceof X509Certificate) {
                        X509Certificate x509Certificate = (X509Certificate)certificate;
                        this.subjectName = x509Certificate.getSubjectDN().getName();
                        this.issuerName = x509Certificate.getIssuerDN().getName();
                        this.serialNumber = x509Certificate.getSerialNumber().toString(16).toUpperCase();
                        this.notBefore = x509Certificate.getNotBefore();
                        this.notAfter = x509Certificate.getNotAfter();
                        try {
                            byte[] byArray = x509Certificate.getEncoded();
                            this.md5 = KeyAliasBean.createFingerPrint(byArray, "MD5".toUpperCase());
                            this.sha = KeyAliasBean.createFingerPrint(byArray, "SHA".toUpperCase());
                        }
                        catch (CertificateEncodingException certificateEncodingException) {}
                    }
                }
                catch (KeyStoreException keyStoreException) {
                    return false;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return false;
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    return false;
                }
                this.opened = true;
                return true;
            }

            public static String createFingerPrint(byte[] byArray, String string) {
                MessageDigest messageDigest;
                try {
                    messageDigest = MessageDigest.getInstance(string);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return null;
                }
                messageDigest.update(byArray);
                byte[] byArray2 = messageDigest.digest();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < byArray2.length; ++i) {
                    int n;
                    String string2;
                    if (i != 0) {
                        stringBuffer.append(':');
                    }
                    if ((string2 = Integer.toHexString(n = byArray2[i] & 0xFF)).length() == 1) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
                return stringBuffer.toString();
            }

            public String getAlias() {
                return this.alias;
            }

            public String getPassword() {
                return this.password;
            }

            public String getIssuerName() {
                return this.issuerName;
            }

            public String getSubjectName() {
                return this.subjectName;
            }

            public String getSerialNumber() {
                return this.serialNumber;
            }

            public Date getNotBefore() {
                return this.notBefore == null ? null : (Date)this.notBefore.clone();
            }

            public Date getNotAfter() {
                return this.notAfter == null ? null : (Date)this.notAfter.clone();
            }

            public String getMd5() {
                return this.md5;
            }

            public String getSha() {
                return this.sha;
            }

            public boolean equals(Object object) {
                if (object instanceof KeyAliasBean) {
                    return this.getAlias().equals(((KeyAliasBean)object).getAlias());
                }
                if (object instanceof String) {
                    return this.getAlias().equals(object);
                }
                return false;
            }

            public int hashCode() {
                return this.getAlias().hashCode();
            }

            public int compareTo(Object object) {
                return this.getAlias().compareTo(object instanceof String ? (String)object : ((KeyAliasBean)object).getAlias());
            }
        }
    }
}

