/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.CfgSelectionPanel;
import org.netbeans.modules.mobility.project.ui.QuickRunPanel;
import org.netbeans.modules.mobility.project.ui.actions.AddConfigurationAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class J2MEActionProvider
implements ActionProvider {
    public static final String COMMAND_COMPILE = "compile";
    public static final String COMMAND_OBFUSCATE = "obfuscate";
    public static final String COMMAND_PREVERIFY = "preverify";
    public static final String COMMAND_JAR = "jar";
    public static final String COMMAND_RUN_WITH = "runwith";
    public static final String COMMAND_JAVADOC = "javadoc";
    public static final String COMMAND_DEPLOY = "deploy";
    public static final String COMMAND_CLEAN_ALL = "clean-all";
    public static final String COMMAND_BUILD_ALL = "build-all";
    public static final String COMMAND_REBUILD_ALL = "rebuild-all";
    public static final String COMMAND_JAVADOC_ALL = "javadoc-all";
    public static final String COMMAND_DEPLOY_ALL = "deploy-all";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile", "compile.single", "obfuscate", "preverify", "jar", "run", "runwith", "debug", "javadoc", "deploy", "build-all", "clean-all", "rebuild-all", "javadoc-all", "deploy-all", "delete", "copy", "move", "rename"};
    final Set<String> bkgScanSensitiveActions;
    protected final AntProjectHelper helper;
    protected final J2MEProject project;
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public J2MEActionProvider(J2MEProject j2MEProject, AntProjectHelper antProjectHelper) {
        this.commands.put("build", new String[]{"build"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"rebuild"});
        this.commands.put(COMMAND_COMPILE, new String[]{COMMAND_COMPILE});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put(COMMAND_OBFUSCATE, new String[]{COMMAND_OBFUSCATE});
        this.commands.put(COMMAND_PREVERIFY, new String[]{COMMAND_PREVERIFY});
        this.commands.put(COMMAND_JAR, new String[]{COMMAND_JAR});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put(COMMAND_RUN_WITH, new String[]{"run-no-build"});
        this.commands.put(COMMAND_JAVADOC, new String[]{COMMAND_JAVADOC});
        this.commands.put(COMMAND_DEPLOY, new String[]{COMMAND_DEPLOY});
        this.commands.put(COMMAND_BUILD_ALL, new String[]{COMMAND_BUILD_ALL});
        this.commands.put(COMMAND_CLEAN_ALL, new String[]{COMMAND_CLEAN_ALL});
        this.commands.put(COMMAND_REBUILD_ALL, new String[]{COMMAND_REBUILD_ALL});
        this.commands.put(COMMAND_JAVADOC_ALL, new String[]{COMMAND_JAVADOC_ALL});
        this.commands.put(COMMAND_DEPLOY_ALL, new String[]{COMMAND_DEPLOY_ALL});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("debug"));
        this.project = j2MEProject;
        this.helper = antProjectHelper;
    }

    protected FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    public String[] getSupportedActions() {
        return (String[])supportedActions.clone();
    }

    protected FileObject[] findSourcesAndPackages(Lookup lookup, FileObject fileObject) {
        if (fileObject != null) {
            FileObject[] fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject, null, (boolean)true);
            if (fileObjectArray != null) {
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (fileObjectArray[i].isFolder() || "java".equals(fileObjectArray[i].getExt())) continue;
                    return null;
                }
            }
            return fileObjectArray;
        }
        return null;
    }

    public String[] getTargetNames(String string) {
        return this.commands.get(string);
    }

    public void invokeAction(final String string, final Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ((COMMAND_BUILD_ALL.equals(string) || COMMAND_CLEAN_ALL.equals(string) || COMMAND_DEPLOY_ALL.equals(string) || COMMAND_JAVADOC_ALL.equals(string) || COMMAND_REBUILD_ALL.equals(string)) && !this.showCfgSelectionDialog(string)) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                FileObject fileObject;
                Object object;
                String[] stringArray = J2MEActionProvider.this.getTargetNames(string);
                if (stringArray == null) {
                    throw new IllegalArgumentException(string);
                }
                EditableProperties editableProperties = J2MEActionProvider.this.helper.getProperties("nbproject/project.properties");
                ProjectConfigurationsHelper projectConfigurationsHelper = J2MEActionProvider.this.project.getConfigurationHelper();
                String string2 = projectConfigurationsHelper.getActiveConfiguration() != projectConfigurationsHelper.getDefaultConfiguration() ? projectConfigurationsHelper.getActiveConfiguration().getDisplayName() : null;
                Properties properties = new Properties();
                if (string.equals("compile.single")) {
                    FileObject[] fileObjectArray;
                    object = J2MEActionProvider.this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
                    if (object != null && (fileObject = J2MEActionProvider.this.helper.resolveFileObject((String)object)) != null && (fileObjectArray = J2MEActionProvider.this.findSourcesAndPackages(lookup, fileObject)) != null) {
                        properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)fileObject));
                    }
                } else if ("debug".equals(string)) {
                    properties.put("obfuscation.level", "0");
                    properties.put("app.codename", J2MEActionProvider.this.project.getName());
                }
                if ("run".equals(string) || J2MEActionProvider.COMMAND_RUN_WITH.equals(string) || "debug".equals(string)) {
                    object = J2MEActionProvider.this.getJadURL();
                    if (object != null) {
                        properties.put("dist.jad.url", object);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MEActionProvider.class, (String)"ERR_GetJadURL"), 0));
                        return;
                    }
                }
                if (J2MEActionProvider.COMMAND_RUN_WITH.equals(string)) {
                    object = new QuickRunPanel("j2me", J2MEActionProvider.this.evaluateProperty(editableProperties, "platform.active", string2), J2MEActionProvider.this.evaluateProperty(editableProperties, "platform.device", string2));
                    fileObject = new DialogDescriptor(object, NbBundle.getMessage(J2MEActionProvider.class, (String)"Title_QuickRun"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(J2MEActionProvider.class), null);
                    if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)fileObject)) && ((QuickRunPanel)object).getPlatformName() != null && ((QuickRunPanel)object).getDeviceName() != null) {
                        properties.put("platform.active", ((QuickRunPanel)object).getPlatformName());
                        properties.put("platform.device", ((QuickRunPanel)object).getDeviceName());
                        properties.put("run.use.security.domain", Boolean.FALSE.toString());
                    } else {
                        return;
                    }
                }
                try {
                    object = J2MEActionProvider.this.findBuildXml();
                    if (object != null) {
                        ActionUtils.runTarget((FileObject)object, (String[])stringArray, (Properties)properties);
                    } else {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(J2MEActionProvider.class, (String)"MSG_NO_BUILD_SCRIPT"));
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        };
        runnable.run();
    }

    private boolean showCfgSelectionDialog(String string) {
        boolean bl;
        String string2 = this.helper.getProperties("nbproject/project.properties").getProperty("all.configurations");
        if (string2 == null) {
            return false;
        }
        if (string2.trim().length() == 0) {
            return true;
        }
        final EditableProperties editableProperties = this.helper.getProperties("nbproject/private/private.properties");
        String string3 = editableProperties.getProperty("selected.configurations");
        CfgSelectionPanel cfgSelectionPanel = new CfgSelectionPanel(string2, string3);
        String string4 = NbBundle.getMessage(AddConfigurationAction.class, (String)("Title_CfgSelection_" + string));
        cfgSelectionPanel.getAccessibleContext().setAccessibleName(string4);
        cfgSelectionPanel.getAccessibleContext().setAccessibleDescription(string4);
        boolean bl2 = DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)cfgSelectionPanel, string4, true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(CfgSelectionPanel.class), null)));
        final String string5 = cfgSelectionPanel.getSelectedConfigurations();
        boolean bl3 = bl = string3 == null != (string5 == null) || string3 != null && !string3.equals(string5);
        if (bl2 && bl) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                public void run() {
                    editableProperties.put("selected.configurations", string5);
                    J2MEActionProvider.this.helper.putProperties("nbproject/private/private.properties", editableProperties);
                    try {
                        ProjectManager.getDefault().saveProject((Project)J2MEActionProvider.this.project);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            });
        }
        return bl2;
    }

    protected String evaluateProperty(EditableProperties editableProperties, String string, String string2) {
        if (string2 == null) {
            return editableProperties.getProperty(string);
        }
        String string3 = editableProperties.getProperty("configs." + string2 + "." + string);
        return string3 != null ? string3 : this.evaluateProperty(editableProperties, string, null);
    }

    protected String getJadURL() {
        FileObject fileObject = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)2);
        if (uRL == null) {
            return null;
        }
        PropertyEvaluator propertyEvaluator = this.helper.getStandardPropertyEvaluator();
        try {
            URL uRL2 = new URL(uRL.getProtocol(), "localhost", uRL.getPort(), this.encodeURL("/servlet/org.netbeans.modules.mobility.project.jam.JAMServlet/" + this.helper.getProjectDirectory().getPath() + "/" + propertyEvaluator.evaluate("${dist.dir}/${dist.jad}")));
            return uRL2.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            return null;
        }
    }

    private String encodeURL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("/")) {
                stringBuffer.append(string2);
                continue;
            }
            try {
                stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                stringBuffer.append(URLEncoder.encode(string2));
            }
        }
        return stringBuffer.toString();
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        if (COMMAND_RUN_WITH.equals(string)) {
            Collection collection = lookup.lookupAll(Project.class);
            for (Project project : collection) {
                J2MEProject j2MEProject = (J2MEProject)project.getLookup().lookup(J2MEProject.class);
                if (j2MEProject == null) {
                    System.err.println("No J2MEProject in " + project + " lookup contents " + project.getLookup().lookupAll(Object.class));
                    return false;
                }
                EditableProperties editableProperties = j2MEProject.helper.getProperties("nbproject/project.properties");
                if (editableProperties != null) {
                    String string2 = editableProperties.getProperty("platform.trigger");
                    if (!"CDC".equals(string2)) continue;
                    System.err.println("Found CDC trigger: " + string2);
                    return false;
                }
                System.err.println("No props, bail");
                return false;
            }
        }
        return true;
    }
}

