/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.HashSet;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.netbeans.modules.kenai.UserData;
import org.netbeans.modules.kenai.api.Kenai;

public final class KenaiUser {
    public static final String PROP_PRESENCE = "Presence";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final HashMap<String, KenaiUser> users = new HashMap();
    private static final HashSet<String> onlineUsers = new HashSet();
    UserData data;

    private KenaiUser(UserData userData) {
        this.data = userData;
    }

    private KenaiUser(String string) {
        this.data = new UserData();
        this.data.user_name = string;
    }

    public String getUserName() {
        return this.data.user_name;
    }

    public String getFirstName() {
        return this.data.first_name;
    }

    public String getLastName() {
        return this.data.last_name;
    }

    public Status getStatus() {
        if (Kenai.getDefault().getPasswordAuthentication() == null) {
            return Status.UNKNOWN;
        }
        if (this.isOnline()) {
            return Status.ONLINE;
        }
        return Status.OFFLINE;
    }

    public String toString() {
        return this.getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KenaiUser forName(String string) {
        HashMap<String, KenaiUser> hashMap = users;
        synchronized (hashMap) {
            KenaiUser kenaiUser = users.get(string);
            if (kenaiUser == null) {
                kenaiUser = new KenaiUser(string);
                users.put(string, kenaiUser);
            }
            return kenaiUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOnlineUserCount() {
        HashSet<String> hashSet = onlineUsers;
        synchronized (hashSet) {
            return onlineUsers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KenaiUser get(UserData userData) {
        HashMap<String, KenaiUser> hashMap = users;
        synchronized (hashMap) {
            KenaiUser kenaiUser = users.get(userData.user_name);
            if (kenaiUser != null) {
                kenaiUser.data = userData;
            } else {
                kenaiUser = new KenaiUser(userData);
                users.put(userData.user_name, kenaiUser);
            }
            return kenaiUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void clear() {
        Cloneable cloneable = users;
        synchronized (cloneable) {
            users.clear();
        }
        cloneable = onlineUsers;
        synchronized (cloneable) {
            onlineUsers.clear();
        }
    }

    public boolean isOnline() {
        return KenaiUser.isOnline(this.getUserName());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOnline(String string) {
        HashSet<String> hashSet = onlineUsers;
        synchronized (hashSet) {
            return onlineUsers.contains(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ONLINE,
        OFFLINE,
        DND,
        UNKNOWN;

    }

    static class KenaiPacketListener
    implements PacketListener {
        KenaiPacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            Presence presence = (Presence)packet;
            String string = presence.getFrom();
            if (null != packet.getExtension("x", "http://jabber.org/protocol/muc#user")) {
                String string2 = StringUtils.parseResource((String)string);
                if (presence.getType() == Presence.Type.available) {
                    Cloneable cloneable = onlineUsers;
                    synchronized (cloneable) {
                        onlineUsers.add(string2);
                    }
                    cloneable = users;
                    synchronized (cloneable) {
                        KenaiUser kenaiUser = (KenaiUser)users.get(string2);
                        if (kenaiUser != null) {
                            kenaiUser.propertyChangeSupport.firePropertyChange(KenaiUser.PROP_PRESENCE, presence.getType() != Presence.Type.available, presence.getType() == Presence.Type.available);
                        }
                    }
                }
                if (presence.getType() == Presence.Type.unavailable) {
                    Cloneable cloneable = onlineUsers;
                    synchronized (cloneable) {
                        onlineUsers.remove(string2);
                    }
                    cloneable = users;
                    synchronized (cloneable) {
                        KenaiUser kenaiUser = (KenaiUser)users.get(string2);
                        if (kenaiUser != null) {
                            kenaiUser.propertyChangeSupport.firePropertyChange(KenaiUser.PROP_PRESENCE, presence.getType() != Presence.Type.available, presence.getType() == Presence.Type.available);
                        }
                    }
                }
            }
        }
    }
}

