/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.FeatureData;
import org.netbeans.modules.kenai.LicenceData;
import org.netbeans.modules.kenai.ProjectData;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiLicense;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.api.KenaiUser;

public final class KenaiProject {
    public static final String PROP_PROJECT_CHANGED = "project_change";
    public static final String PROP_PROJECT_NOTIFICATION = "project_notification";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ProjectData data;
    private Icon projectIcon;
    private KenaiFeature[] features;
    private KenaiProjectMember[] members;
    private KenaiLicense[] licenses;
    private static final int repositoryPatternProjectGroup = 4;

    private KenaiProject(ProjectData projectData) {
        this.fillInfo(projectData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KenaiProject get(ProjectData projectData) {
        Kenai kenai = Kenai.getDefault();
        HashMap<String, WeakReference<KenaiProject>> hashMap = kenai.projectsCache;
        synchronized (hashMap) {
            WeakReference<KenaiProject> weakReference = kenai.projectsCache.get(projectData.name);
            KenaiProject kenaiProject = null;
            if (weakReference == null || (kenaiProject = (KenaiProject)weakReference.get()) == null) {
                kenaiProject = new KenaiProject(projectData);
                kenai.projectsCache.put(projectData.name, new WeakReference<KenaiProject>(kenaiProject));
            } else {
                kenaiProject = (KenaiProject)weakReference.get();
                kenaiProject.fillInfo(projectData);
            }
            return kenaiProject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KenaiProject get(String string) {
        Kenai kenai = Kenai.getDefault();
        HashMap<String, WeakReference<KenaiProject>> hashMap = kenai.projectsCache;
        synchronized (hashMap) {
            WeakReference<KenaiProject> weakReference = kenai.projectsCache.get(string);
            if (weakReference == null) {
                return null;
            }
            return (KenaiProject)weakReference.get();
        }
    }

    public synchronized String getName() {
        return this.data.name;
    }

    public synchronized URL getWebLocation() {
        try {
            return new URL(this.data.web_url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    public synchronized String getDisplayName() {
        return this.data.display_name;
    }

    public synchronized String getDescription() throws KenaiException {
        this.fetchDetailsIfNotAvailable();
        return this.data.description;
    }

    public synchronized String getImageUrl() throws KenaiException {
        this.fetchDetailsIfNotAvailable();
        return this.data.image;
    }

    public boolean isMyProject() {
        Collection<KenaiProject> collection = Kenai.getDefault().myProjects;
        if (collection == null) {
            return false;
        }
        return collection.contains(this);
    }

    public KenaiProjectMember.Role getMyRole() throws KenaiException {
        PasswordAuthentication passwordAuthentication = Kenai.getDefault().getPasswordAuthentication();
        if (passwordAuthentication == null) {
            return null;
        }
        String string = passwordAuthentication.getUserName();
        for (KenaiProjectMember kenaiProjectMember : this.getMembers()) {
            if (!string.equals(kenaiProjectMember.getUserName())) continue;
            return kenaiProjectMember.getRole();
        }
        return null;
    }

    public Icon getProjectIcon() throws KenaiException {
        if (this.projectIcon == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new KenaiException("KenaiProject.getProjectIcon() must not be called from AWT thread unless an icon is cached!");
            }
            try {
                URL uRL = new URL(this.getImageUrl());
                BufferedImage bufferedImage = ImageIO.read(uRL);
                this.projectIcon = new ImageIcon(bufferedImage);
            }
            catch (IOException iOException) {
                throw new KenaiException(iOException.getMessage());
            }
        }
        return this.projectIcon;
    }

    public synchronized String getTags() throws KenaiException {
        this.fetchDetailsIfNotAvailable();
        return this.data.tags;
    }

    public synchronized boolean isPrivate() throws KenaiException {
        this.fetchDetailsIfNotAvailable();
        return this.data.private_hidden;
    }

    private static Pattern getRepositoryPattern() {
        return Pattern.compile("(https|http)://([a-z]+\\.)?" + Kenai.getDefault().getUrl().getHost().replace(".", "\\.") + "/(svn|hg)/(\\S*)~(.*)");
    }

    public static KenaiProject forRepository(String string) throws KenaiException {
        if (string == null) {
            return null;
        }
        Matcher matcher = KenaiProject.getRepositoryPattern().matcher(string);
        if (matcher.matches()) {
            return Kenai.getDefault().getProject(matcher.group(4));
        }
        if (Kenai.getDefault().getUrl().getHost().equals("netbeans.org") && (string.startsWith("https://hg.netbeans.org") || string.startsWith("http://hg.netbeans.org"))) {
            return Kenai.getDefault().getProject("ide");
        }
        return null;
    }

    public static String getNameForRepository(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = KenaiProject.getRepositoryPattern().matcher(string);
        if (matcher.matches()) {
            return matcher.group(4);
        }
        if (Kenai.getDefault().getUrl().getHost().equals("netbeans.org") && (string.startsWith("https://hg.netbeans.org") || string.startsWith("http://hg.netbeans.org"))) {
            return "ide";
        }
        return null;
    }

    public synchronized KenaiFeature[] getFeatures() throws KenaiException {
        this.fetchDetailsIfNotAvailable();
        if (this.features == null) {
            this.features = new KenaiFeature[this.data.features.length];
            int n = 0;
            for (FeatureData featureData : this.data.features) {
                this.features[n++] = new KenaiFeature(featureData);
            }
        }
        return this.features;
    }

    public synchronized KenaiProjectMember[] getMembers() throws KenaiException {
        if (this.members == null) {
            Collection<KenaiProjectMember> collection = Kenai.getDefault().getProjectMembers(this.getName());
            this.members = collection.toArray(new KenaiProjectMember[collection.size()]);
        }
        return this.members;
    }

    public synchronized KenaiUser getOwner() throws KenaiException {
        this.fetchDetailsIfNotAvailable();
        return KenaiUser.forName(this.data.owner);
    }

    public synchronized KenaiFeature[] getFeatures(KenaiService.Type type) throws KenaiException {
        ArrayList<KenaiFeature> arrayList = new ArrayList<KenaiFeature>();
        for (KenaiFeature kenaiFeature : this.getFeatures()) {
            if (!kenaiFeature.getType().equals((Object)type)) continue;
            arrayList.add(kenaiFeature);
        }
        return arrayList.toArray(new KenaiFeature[arrayList.size()]);
    }

    public synchronized KenaiLicense[] getLicenses() throws KenaiException {
        this.fetchDetailsIfNotAvailable();
        if (this.licenses == null) {
            this.licenses = new KenaiLicense[this.data.licenses.length];
            int n = 0;
            for (LicenceData licenceData : this.data.licenses) {
                this.licenses[n++] = new KenaiLicense(licenceData);
            }
        }
        return this.licenses;
    }

    public KenaiFeature createProjectFeature(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws KenaiException {
        KenaiFeature kenaiFeature = Kenai.getDefault().createProjectFeature(this.getName(), string, string2, string3, string4, string5, string6, string7);
        this.refresh();
        return kenaiFeature;
    }

    public static String checkName(String string) throws KenaiException {
        return Kenai.getDefault().checkName(string);
    }

    private void join() throws KenaiException {
        Kenai.getDefault().joinProject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillInfo(ProjectData projectData) {
        KenaiProject kenaiProject = this;
        synchronized (kenaiProject) {
            if (projectData.updated_at == null && this.data != null && this.data.updated_at != null) {
                return;
            }
            this.data = projectData;
            this.features = null;
            this.members = null;
            this.licenses = null;
            this.projectIcon = null;
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_PROJECT_CHANGED, null, null));
    }

    synchronized ProjectData getData() {
        return this.data;
    }

    private void fetchDetailsIfNotAvailable() throws KenaiException {
        if (this.data.updated_at != null) {
            return;
        }
        this.refresh();
    }

    private void refresh() throws KenaiException {
        this.fillInfo(Kenai.getDefault().getDetails(this.getName()));
    }

    public synchronized boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KenaiProject kenaiProject = (KenaiProject)object;
        return !(this.data.name == null ? kenaiProject.data.name != null : !this.data.name.equals(kenaiProject.data.name));
    }

    public synchronized int hashCode() {
        int n = 5;
        n = 13 * n + (this.data.name != null ? this.data.name.hashCode() : 0);
        return n;
    }

    public synchronized String toString() {
        return "KenaiProject " + this.getName();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }
}

