/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.codeviation.commons.utils.StreamUtil;

public class ClassUtils {
    private static Map<Class, Class> P2O = new HashMap<Class, Class>();

    public static boolean isSuperinterface(Class clazz, Class clazz2) {
        if (!clazz2.isInterface()) {
            throw new IllegalArgumentException("iface parameter " + clazz2 + "must be an interface!");
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean isSuperclass(Class clazz, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz parameter must not be null!");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("superclass parameter must not be null!");
        }
        if (clazz2.isInterface()) {
            throw new IllegalArgumentException("superclass parameter " + clazz2 + "must not be an interface!");
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static String getDotClassName(Class clazz) {
        StringBuilder stringBuilder = new StringBuilder(clazz.getSimpleName());
        for (clazz = clazz.getEnclosingClass(); clazz != null; clazz = clazz.getEnclosingClass()) {
            stringBuilder.insert(0, clazz.getSimpleName() + ".");
        }
        return stringBuilder.toString();
    }

    public static String getResourceAsString(Class clazz, String string) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream(string);
        return inputStream == null ? null : StreamUtil.asString(inputStream);
    }

    public static Vector arrayToVector(Object object) {
        int n = Array.getLength(object);
        Vector<Object> vector = new Vector<Object>(n);
        for (int i = 0; i < n; ++i) {
            vector.add(Array.get(object, i));
        }
        return vector;
    }

    public static Class primitive2Object(Class clazz) {
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + "is not primitive");
        }
        return P2O.get(clazz);
    }

    static {
        P2O.put(Boolean.TYPE, Boolean.class);
        P2O.put(Byte.TYPE, Byte.class);
        P2O.put(Character.TYPE, Character.class);
        P2O.put(Short.TYPE, Short.class);
        P2O.put(Integer.TYPE, Integer.class);
        P2O.put(Long.TYPE, Long.class);
        P2O.put(Float.TYPE, Float.class);
        P2O.put(Double.TYPE, Double.class);
        P2O.put(Void.TYPE, Void.class);
    }
}

