/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultivalueMap<K, V> {
    private HashMap<K, Object> mContainer = new HashMap();

    public void put(K k, V v) {
        Object object = this.mContainer.get(k);
        if (object == null) {
            this.mContainer.put(k, v);
        } else if (object instanceof List) {
            List list = (List)List.class.cast(object);
            if (!list.contains(v)) {
                list.add(v);
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            this.mContainer.put(k, arrayList);
            arrayList.add(object);
            arrayList.add(v);
        }
    }

    public List<V> get(K k) {
        Object object = this.mContainer.get(k);
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        if (object instanceof List) {
            return (List)List.class.cast(object);
        }
        return Collections.singletonList(object);
    }

    public boolean containsKey(K k) {
        return this.mContainer.containsKey(k);
    }

    public boolean isEmpty() {
        return this.mContainer.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Utils {
        public static <I> Set<I> getTreeLeafs(Graph<I> graph, I i) {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            Utils.populateLeafs(graph, i, hashSet, hashSet2);
            return hashSet;
        }

        private static <I> void populateLeafs(Graph<I> graph, I i, Set<I> set, Set<I> set2) {
            List list = graph.get(i);
            if (list.isEmpty()) {
                set.add(i);
            }
            set2.add(i);
            for (Object v : list) {
                if (set2.contains(v)) continue;
                Utils.populateLeafs(graph, v, set, set2);
            }
        }

        public static <I> Set<I> collectAllSubItems(Graph<I> graph, I i) {
            HashSet hashSet = new HashSet();
            Utils.populateAllSubItems(graph, i, hashSet);
            return hashSet;
        }

        public static <I> void populateAllSubItems(Graph<I> graph, I i, Set<I> set) {
            set.add(i);
            List list = graph.get(i);
            for (Object v : list) {
                if (set.contains(v)) continue;
                Utils.populateAllSubItems(graph, v, set);
            }
        }

        public static <I> Set<I> getTreeRoots(BidirectionalGraph<I> bidirectionalGraph, I i) {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            Path<I> path = new Path<I>(i);
            Utils.populateRoots(bidirectionalGraph, path, hashSet, hashSet2);
            return hashSet;
        }

        private static <I> void populateRoots(BidirectionalGraph<I> bidirectionalGraph, Path<I> path, Set<I> set, Set<I> set2) {
            I i = path.getItem();
            set2.add(i);
            List<I> list = bidirectionalGraph.getFrom(i);
            if (list.isEmpty()) {
                set.add(i);
            }
            for (I i2 : list) {
                if (!set2.contains(i2)) {
                    Path<I> path2 = new Path<I>(path, i2);
                    Utils.populateRoots(bidirectionalGraph, path2, set, set2);
                    continue;
                }
                if (!path.containsInPath(i2)) continue;
                set.add(i2);
            }
        }

        public static <I> void populateAllSubItems(BidirectionalGraph<I> bidirectionalGraph, I i, I i2, Set<I> set) {
            if (i == i2) {
                return;
            }
            set.add(i);
            List<I> list = bidirectionalGraph.getTo(i);
            for (I i3 : list) {
                if (set.contains(i3)) continue;
                Utils.populateAllSubItems(bidirectionalGraph, i3, i2, set);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Path<I> {
            private I mItem;
            private Path<I> mParentPath;

            public Path(I i) {
                this.mItem = i;
            }

            public Path(Path<I> path, I i) {
                this.mItem = i;
                this.mParentPath = path;
            }

            public I getItem() {
                return this.mItem;
            }

            public boolean containsInPath(I i) {
                if (i == this.mItem) {
                    return true;
                }
                if (this.mParentPath != null) {
                    return this.mParentPath.containsInPath(i);
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BidirectionalGraph<I> {
        private Graph<I> mForward = new Graph();
        private Graph<I> mBackward = new Graph();
        private Set<I> mRoots = null;

        public void put(I i, I i2) {
            this.mForward.put(i, i2);
            this.mBackward.put(i2, i);
        }

        public List<I> getTo(I i) {
            return this.mForward.get(i);
        }

        public List<I> getFrom(I i) {
            return this.mBackward.get(i);
        }

        public boolean containsKey(I i) {
            return this.mForward.containsKey(i) || this.mBackward.containsKey(i);
        }

        public boolean isEmpty() {
            return this.mForward.isEmpty();
        }

        public Set<I> getRoots(I i, boolean bl) {
            if (this.mRoots == null) {
                bl = true;
            }
            if (bl) {
                this.mRoots = Utils.getTreeRoots(this, i);
            }
            return this.mRoots;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Graph<I>
    extends MultivalueMap<I, I> {
    }
}

