/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactGraphNode {
    public static final int UNMANAGED = 0;
    public static final int MANAGED = 1;
    public static final int OVERRIDES_MANAGED = 2;
    public static final int NO_CONFLICT = 0;
    public static final int POTENTIAL_CONFLICT = 1;
    public static final int CONFLICT = 2;
    private DependencyNode artifact;
    private DependencyNode parentAfterFix;
    double locX;
    double locY;
    double dispX;
    double dispY;
    private boolean fixed;
    private ArtifactWidget widget;
    private boolean root;
    private HashSet<DependencyNode> dupl;
    private int level;
    private int managedState = 0;

    public ArtifactGraphNode(DependencyNode dependencyNode) {
        this.artifact = dependencyNode;
        this.dupl = new HashSet();
    }

    DependencyNode getArtifact() {
        return this.artifact;
    }

    DependencyNode getArtifactParent() {
        if (this.parentAfterFix != null) {
            return this.parentAfterFix;
        }
        return this.getArtifact().getParent();
    }

    void setArtifactParent(DependencyNode dependencyNode) {
        this.parentAfterFix = dependencyNode;
    }

    void setArtifact(DependencyNode dependencyNode) {
        this.artifact = dependencyNode;
    }

    void addDuplicateOrConflict(DependencyNode dependencyNode) {
        this.dupl.add(dependencyNode);
    }

    Set<DependencyNode> getDuplicatesOrConflicts() {
        return this.dupl;
    }

    boolean represents(DependencyNode dependencyNode) {
        if (this.artifact.equals((Object)dependencyNode)) {
            return true;
        }
        for (DependencyNode dependencyNode2 : this.dupl) {
            if (!dependencyNode2.equals((Object)dependencyNode)) continue;
            return true;
        }
        return false;
    }

    int getConflictType() {
        int n = 0;
        DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(this.getArtifact().getArtifact().getVersion());
        for (DependencyNode dependencyNode : this.getDuplicatesOrConflicts()) {
            if (dependencyNode.getState() != 2) continue;
            int n2 = defaultArtifactVersion.compareTo((Object)new DefaultArtifactVersion(dependencyNode.getArtifact().getVersion()));
            if (n2 < 0) {
                return 2;
            }
            if (n2 <= 0) continue;
            n = 1;
        }
        return n;
    }

    public boolean isRoot() {
        return this.level == 0;
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isVisible() {
        return this.widget != null ? this.widget.isVisible() : true;
    }

    void setPrimaryLevel(int n) {
        this.level = n;
    }

    public int getPrimaryLevel() {
        return this.level;
    }

    void setWidget(ArtifactWidget artifactWidget) {
        this.widget = artifactWidget;
    }

    ArtifactWidget getWidget() {
        return this.widget;
    }

    public int getManagedState() {
        return this.managedState;
    }

    public void setManagedState(int n) {
        this.managedState = n;
    }

    static int compareVersions(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        for (int i = 0; i < Math.min(stringArray.length, stringArray2.length); ++i) {
            int n = stringArray[i].compareTo(stringArray2[i]);
            if (n == 0) continue;
            return n;
        }
        return stringArray.length - stringArray2.length;
    }
}

