/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.ProgressDisplayer;
import org.netbeans.modules.profiler.selector.ui.RootSelectorTree;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.panels.ProfilerProgressDisplayer;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class ProjectSelectRootMethodsPanel
extends JPanel {
    private static ProjectSelectRootMethodsPanel instance = null;
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(ProjectSelectRootMethodsPanel.class, (String)"SelectRootMethodsPanel_OkButtonText");
    private static final String REMOVE_SELECTED_ITEM_TEXT = NbBundle.getMessage(ProjectSelectRootMethodsPanel.class, (String)"SelectRootMethodsPanel_RemoveSelectedItemText");
    private static final String REMOVE_ALL_ITEM_TEXT = NbBundle.getMessage(ProjectSelectRootMethodsPanel.class, (String)"SelectRootMethodsPanel_RemoveAllItemText");
    private static final String SELECT_ALL_ITEM_TEXT = NbBundle.getMessage(ProjectSelectRootMethodsPanel.class, (String)"SelectRootMethodsPanel_SelectAllItemText");
    protected static final Dimension PREFERRED_TOPTREE_DIMENSION = new Dimension(500, 250);
    private HTMLTextArea hintArea;
    private JButton okButton;
    private JCheckBox advancedShowAllProjectsCheckBox;
    private JComboBox treeBuilderList;
    private Project currentProject;
    private RequestProcessor rp = new RequestProcessor("SRM-UI Processor", 1);
    private RootSelectorTree advancedLogicalPackageTree;
    private volatile boolean changingBuilderList = false;
    private boolean globalMode;
    private static final String HELP_CTX_KEY = "ProjectSelectRootMethodsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProjectSelectRootMethodsPanel.HelpCtx");

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static synchronized ProjectSelectRootMethodsPanel getDefault() {
        if (instance == null) {
            instance = new ProjectSelectRootMethodsPanel();
        }
        return instance;
    }

    private ProjectSelectRootMethodsPanel() {
        this.initComponents(this);
    }

    public static boolean canBeShown() {
        return RootSelectorTree.canBeShown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getRootMethods(Project project, final ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.currentProject = project;
        this.advancedLogicalPackageTree.reset();
        this.setGlobalMode(project == null);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProjectSelectRootMethodsPanel.this.refreshBuilderList();
            }
        };
        try {
            this.advancedLogicalPackageTree.addPropertyChangeListener("SELECTION_TREE_VIEW_LIST", propertyChangeListener);
            this.updateSelector(new Runnable(){

                public void run() {
                    ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setContext(ProjectSelectRootMethodsPanel.this.getContext());
                    ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setSelection(sourceCodeSelectionArray);
                }
            });
            if (this.advancedLogicalPackageTree.getBuilderTypes().isEmpty()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"SelectRootMethodsPanel_NoSelectionProviders");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray2 = null;
                return sourceCodeSelectionArray2;
            }
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_Title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
            Object[] objectArray = this.getAdditionalOptions();
            if (objectArray != null && objectArray.length > 0) {
                dialogDescriptor.setAdditionalOptions(objectArray);
            }
            Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
            dialog.pack();
            dialog.setVisible(true);
            this.currentProject = null;
            if (dialogDescriptor.getValue().equals(this.okButton)) {
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray3;
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray4 = sourceCodeSelectionArray3 = this.advancedLogicalPackageTree.getSelection();
                return sourceCodeSelectionArray4;
            }
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray5 = null;
            return sourceCodeSelectionArray5;
        }
        finally {
            this.advancedLogicalPackageTree.removePropertyChangeListener("SELECTION_TREE_VIEW_LIST", propertyChangeListener);
        }
    }

    protected void initComponents(Container container) {
        this.okButton = new JButton(OK_BUTTON_TEXT);
        ProgressDisplayer progressDisplayer = new ProgressDisplayer(){
            ProfilerProgressDisplayer pd = null;

            public synchronized void showProgress(String string) {
                this.pd = ProfilerProgressDisplayer.showProgress(string);
            }

            public synchronized void showProgress(String string, ProgressDisplayer.ProgressController progressController) {
                this.pd = ProfilerProgressDisplayer.showProgress(string, (Cancellable)progressController);
            }

            public synchronized void showProgress(String string, String string2, ProgressDisplayer.ProgressController progressController) {
                this.pd = ProfilerProgressDisplayer.showProgress(string, string2, (Cancellable)progressController);
            }

            public synchronized boolean isOpened() {
                return this.pd != null;
            }

            public synchronized void close() {
                if (this.pd != null) {
                    this.pd.close();
                    this.pd = null;
                }
            }
        };
        this.advancedLogicalPackageTree = new RootSelectorTree(progressDisplayer, RootSelectorTree.DEFAULT_FILTER);
        this.advancedShowAllProjectsCheckBox = new JCheckBox();
        this.advancedShowAllProjectsCheckBox.setVisible(true);
        this.treeBuilderList = new JComboBox();
        this.treeBuilderList.addItemListener(new ItemListener(){

            public void itemStateChanged(final ItemEvent itemEvent) {
                if (ProjectSelectRootMethodsPanel.this.changingBuilderList) {
                    return;
                }
                if (itemEvent.getStateChange() == 1) {
                    ProjectSelectRootMethodsPanel.this.rp.post(new Runnable(){

                        public void run() {
                            ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setBuilderType((SelectionTreeBuilder.Type)itemEvent.getItem());
                        }
                    });
                }
            }
        });
        container.setLayout(new GridBagLayout());
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.advancedLogicalPackageTree.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        JScrollPane jScrollPane = new JScrollPane((Component)this.advancedLogicalPackageTree);
        jScrollPane.setPreferredSize(PREFERRED_TOPTREE_DIMENSION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)jScrollPane, gridBagConstraints);
        this.advancedShowAllProjectsCheckBox.setText(NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_ShowAllProjectsLabel"));
        this.advancedShowAllProjectsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectSelectRootMethodsPanel.this.rp.post(new Runnable(){

                    public void run() {
                        ProjectSelectRootMethodsPanel.this.refreshBuilderList();
                        ProjectSelectRootMethodsPanel.this.updateSelectorProjects();
                    }
                });
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JLabel(NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_SelectViewLabel")));
        jPanel.add(this.treeBuilderList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        container.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        container.add((Component)this.advancedShowAllProjectsCheckBox, gridBagConstraints);
        String string = this.getHintString();
        if (string != null && string.length() > 0) {
            Color color = UIManager.getColor("Panel.background");
            Color color2 = UIUtils.getSafeColor((int)(color.getRed() - 10), (int)(color.getGreen() - 10), (int)(color.getBlue() - 10));
            this.hintArea.setText(string);
            this.hintArea.setEnabled(false);
            this.hintArea.setDisabledTextColor(Color.darkGray);
            this.hintArea.setBackground(color2);
            this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, color2));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            container.add((Component)this.hintArea, gridBagConstraints);
        }
    }

    private Object[] getAdditionalOptions() {
        return null;
    }

    private void setGlobalMode(boolean bl) {
        this.advancedShowAllProjectsCheckBox.setSelected(bl);
        this.advancedShowAllProjectsCheckBox.setEnabled(!bl);
        this.globalMode = bl;
    }

    private String getHintString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBuilderList() {
        List list = this.advancedLogicalPackageTree.getBuilderTypes();
        if (list == null || list.isEmpty()) {
            return;
        }
        try {
            this.changingBuilderList = true;
            this.treeBuilderList.setModel(new DefaultComboBoxModel<SelectionTreeBuilder.Type>(list.toArray(new SelectionTreeBuilder.Type[list.size()])));
            this.treeBuilderList.setSelectedIndex(0);
            this.advancedLogicalPackageTree.setBuilderType((SelectionTreeBuilder.Type)this.treeBuilderList.getItemAt(0));
        }
        finally {
            this.changingBuilderList = false;
        }
    }

    private Project[] relevantProjects() {
        Project[] projectArray;
        if (this.advancedShowAllProjectsCheckBox.isSelected()) {
            projectArray = OpenProjects.getDefault().getOpenProjects();
        } else {
            Project[] projectArray2 = new Project[1];
            projectArray = projectArray2;
            projectArray2[0] = this.currentProject;
        }
        return projectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector(Runnable runnable) {
        ProgressHandle progressHandle = IDEUtils.indeterminateProgress(NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_ParsingProjectStructureMessage"), 500);
        try {
            this.treeBuilderList.setEnabled(false);
            this.advancedLogicalPackageTree.setEnabled(false);
            this.advancedShowAllProjectsCheckBox.setEnabled(false);
            this.okButton.setEnabled(false);
            runnable.run();
        }
        catch (Throwable throwable) {
            progressHandle.finish();
            this.okButton.setEnabled(true);
            this.advancedShowAllProjectsCheckBox.setEnabled(!this.globalMode);
            this.advancedLogicalPackageTree.setEnabled(true);
            this.treeBuilderList.setEnabled(true);
            throw throwable;
        }
        progressHandle.finish();
        this.okButton.setEnabled(true);
        this.advancedShowAllProjectsCheckBox.setEnabled(!this.globalMode);
        this.advancedLogicalPackageTree.setEnabled(true);
        this.treeBuilderList.setEnabled(true);
    }

    private void updateSelectorProjects() {
        this.updateSelector(new Runnable(){

            public void run() {
                ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setContext(ProjectSelectRootMethodsPanel.this.getContext());
            }
        });
    }

    private Lookup getContext() {
        return Lookups.fixed((Object[])this.relevantProjects());
    }
}

