/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SnapshotCustomizer
extends ValidityAwarePanel
implements ActionListener,
ChangeListener,
DocumentListener {
    private static final String TAKE_LABEL_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_TakeLabelText");
    private static final String PROFILING_DATA_RADIO_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_ProfilingDataRadioText");
    private static final String HEAPDUMP_RADIO_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_HeapDumpRadioText");
    private static final String SAVE_LABEL_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_SaveLabelText");
    private static final String TO_PROJECT_RADIO_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_ToProjectRadioText");
    private static final String TO_DIRECTORY_RADIO_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_ToDirectoryRadioText");
    private static final String BROWSE_BUTTON_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_BrowseButtonText");
    private static final String RESET_RESULTS_CHECKBOX_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_ResetResultsCheckboxText");
    private static final String SELECT_SNAPSHOT_DIALOG_CAPTION = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_SelectSnapshotDialogCaption");
    private static final String SAVE_FIELD_ACCESS_NAME = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_SaveFieldAccessName");
    private static int defaultTextComponentHeight = -1;
    private static JFileChooser fileChooser;
    private JButton saveToFileButton;
    private JCheckBox resetResultsCheckbox;
    private JLabel saveLabel;
    private JLabel takeLabel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel secondLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel thirdLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton saveToFileRadio;
    private JRadioButton saveToProjectRadio;
    private JRadioButton takeHeapdumpRadio;
    private JRadioButton takeSnapshotRadio;
    private JTextField saveToFileField;

    public SnapshotCustomizer() {
        this.initComponents();
    }

    public int getPreferredCaptionAreaWidth() {
        return Math.max(this.takeLabel.getPreferredSize().width, this.saveLabel.getPreferredSize().width);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveToFileButton) {
            JFileChooser jFileChooser = this.getFileChooser();
            jFileChooser.setCurrentDirectory(new File(this.saveToFileField.getText()).getParentFile());
            if (jFileChooser.showOpenDialog(null) == 0) {
                this.saveToFileField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SnapshotCustomizer snapshotCustomizer = new SnapshotCustomizer();
        JFrame jFrame = new JFrame("Customize Profiling Point");
        jFrame.getContentPane().add(snapshotCustomizer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth(int n) {
        int n2 = this.getPreferredCaptionAreaWidth();
        int n3 = n - n2;
        int n4 = n3 > 0 ? n3 : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n4, 0, 0));
        this.secondLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n4, 0, 0));
        this.thirdLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n4, 0, 0));
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.saveToProjectRadio) {
            this.updateValidity();
        } else if (changeEvent.getSource() == this.saveToFileRadio) {
            this.saveToFileField.setEnabled(this.saveToFileRadio.isSelected());
            this.saveToFileButton.setEnabled(this.saveToFileRadio.isSelected());
            this.updateValidity();
        }
    }

    void setPPFile(String string) {
        if (string == null) {
            this.saveToFileField.setText("");
        } else {
            this.saveToFileField.setText(string);
        }
    }

    String getPPFile() {
        String string = this.saveToFileField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    void setPPResetResults(boolean bl) {
        this.resetResultsCheckbox.setSelected(bl);
    }

    boolean getPPResetResults() {
        return this.resetResultsCheckbox.isSelected();
    }

    void setPPTarget(boolean bl) {
        this.saveToProjectRadio.setSelected(bl);
        this.saveToFileRadio.setSelected(!bl);
    }

    boolean getPPTarget() {
        return this.saveToProjectRadio.isSelected();
    }

    void setPPType(boolean bl) {
        this.takeSnapshotRadio.setSelected(bl);
        this.takeHeapdumpRadio.setSelected(!bl);
        this.resetResultsCheckbox.setEnabled(bl);
    }

    boolean getPPType() {
        return this.takeSnapshotRadio.isSelected();
    }

    private boolean isDestinationDirectoryValid() {
        File file = new File(this.saveToFileField.getText());
        return file.exists() && file.isDirectory();
    }

    private JFileChooser getFileChooser() {
        if (fileChooser == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(SELECT_SNAPSHOT_DIALOG_CAPTION);
            fileChooser = jFileChooser;
        }
        return fileChooser;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.takeLabel = new JLabel(TAKE_LABEL_TEXT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.takeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.takeSnapshotRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.takeSnapshotRadio, (String)PROFILING_DATA_RADIO_TEXT);
        buttonGroup.add(this.takeSnapshotRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.takeSnapshotRadio, gridBagConstraints);
        this.takeSnapshotRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SnapshotCustomizer.this.resetResultsCheckbox.setEnabled(SnapshotCustomizer.this.takeSnapshotRadio.isSelected());
            }
        });
        this.takeHeapdumpRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.takeHeapdumpRadio, (String)HEAPDUMP_RADIO_TEXT);
        buttonGroup.add(this.takeHeapdumpRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.takeHeapdumpRadio, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)jPanel, gridBagConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.saveLabel = new JLabel(SAVE_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.saveLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.secondLineCaptionSpacer, gridBagConstraints);
        this.saveToProjectRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.saveToProjectRadio, (String)TO_PROJECT_RADIO_TEXT);
        buttonGroup2.add(this.saveToProjectRadio);
        this.saveToProjectRadio.addChangeListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.saveToProjectRadio, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.thirdLineCaptionSpacer, gridBagConstraints);
        this.saveToFileRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.saveToFileRadio, (String)TO_DIRECTORY_RADIO_TEXT);
        buttonGroup2.add(this.saveToFileRadio);
        this.saveToFileRadio.setSelected(true);
        this.saveToFileRadio.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.saveToFileRadio, gridBagConstraints);
        this.saveToFileField = new JTextField(""){

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.saveToFileField.getAccessibleContext().setAccessibleName(TO_DIRECTORY_RADIO_TEXT);
        this.saveToFileField.getAccessibleContext().setAccessibleDescription(SAVE_FIELD_ACCESS_NAME);
        this.saveToFileField.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.saveToFileField, gridBagConstraints);
        this.saveToFileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.saveToFileButton, (String)BROWSE_BUTTON_TEXT);
        this.saveToFileButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this.saveToFileButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)jPanel3, gridBagConstraints);
        this.resetResultsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.resetResultsCheckbox, (String)RESET_RESULTS_CHECKBOX_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.resetResultsCheckbox, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel5, gridBagConstraints);
    }

    private void updateValidity() {
        boolean bl;
        boolean bl2 = this.isDestinationDirectoryValid();
        this.saveToFileField.setForeground(bl2 ? UIManager.getColor("TextField.foreground") : Color.RED);
        boolean bl3 = bl = this.saveToProjectRadio.isSelected() || bl2;
        if (bl != this.areSettingsValid()) {
            this.fireValidityChanged(bl);
        }
    }
}

