/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.openide.ErrorManager;

public abstract class TimedGlobalProfilingPoint
extends GlobalProfilingPoint {
    static final String PROPERTY_TIME = "p_timecond";
    private TimeCondition condition = new TimeCondition();

    TimedGlobalProfilingPoint(String string, Project project, ProfilingPointFactory profilingPointFactory) {
        super(string, project, profilingPointFactory);
    }

    public void setCondition(TimeCondition timeCondition) {
        if (this.condition.equals(timeCondition)) {
            return;
        }
        TimeCondition timeCondition2 = this.condition;
        this.condition = timeCondition;
        this.getChangeSupport().firePropertyChange(PROPERTY_TIME, timeCondition2, timeCondition);
    }

    public TimeCondition getCondition() {
        return this.condition;
    }

    public static class TimeCondition {
        public static final String PROPERTY_TIMECOND_STARTTIME = "p_timecond_starttime";
        public static final String PROPERTY_TIMECOND_REPEATS = "p_timecond_repeats";
        public static final String PROPERTY_TIMECOND_PERIODTIME = "p_timecond_periodtime";
        public static final String PROPERTY_TIMECOND_PERIODUNITS = "p_timecond_periodunits";
        public static final int UNITS_MINUTES = 1;
        public static final int UNITS_HOURS = 2;
        private boolean repeats;
        private int periodTime;
        private int periodUnits;
        private long scheduledTime;
        private long startTime;

        public TimeCondition() {
            this(System.currentTimeMillis());
        }

        public TimeCondition(long l) {
            this(l, false, 1, 1);
        }

        public TimeCondition(long l, boolean bl, int n, int n2) {
            this.setStartTime(l);
            this.setRepeats(bl);
            this.setPeriodTime(n);
            this.setPeriodUnits(n2);
            this.setScheduledTime(l);
        }

        public void setPeriodTime(int n) {
            this.periodTime = n;
        }

        public int getPeriodTime() {
            return this.periodTime;
        }

        public void setPeriodUnits(int n) {
            this.periodUnits = n;
        }

        public int getPeriodUnits() {
            return this.periodUnits;
        }

        public void setRepeats(boolean bl) {
            this.repeats = bl;
        }

        public boolean getRepeats() {
            return this.repeats;
        }

        public void setStartTime(long l) {
            this.startTime = l;
            this.scheduledTime = l;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TimeCondition)) {
                return false;
            }
            TimeCondition timeCondition = (TimeCondition)object;
            return this.startTime == timeCondition.startTime && this.repeats == timeCondition.repeats && this.periodTime == timeCondition.periodTime && this.periodUnits == timeCondition.periodUnits;
        }

        public static TimeCondition load(Project project, int n, Properties properties) {
            return TimeCondition.load(project, n, null, properties);
        }

        public static TimeCondition load(Project project, int n, String string, Properties properties) {
            String string2 = string == null ? n + "_" : n + "_" + string;
            String string3 = properties.getProperty(string2 + PROPERTY_TIMECOND_STARTTIME, null);
            String string4 = properties.getProperty(string2 + PROPERTY_TIMECOND_REPEATS, null);
            String string5 = properties.getProperty(string2 + PROPERTY_TIMECOND_PERIODTIME, null);
            String string6 = properties.getProperty(string2 + PROPERTY_TIMECOND_PERIODUNITS, null);
            if (string3 == null || string4 == null || string5 == null || string6 == null) {
                return null;
            }
            TimeCondition timeCondition = null;
            try {
                timeCondition = new TimeCondition(Long.parseLong(string3), Boolean.parseBoolean(string4), Integer.parseInt(string5), Integer.parseInt(string6));
            }
            catch (Exception exception) {
                ErrorManager.getDefault().log(65536, exception.getMessage());
            }
            return timeCondition;
        }

        public void store(Project project, int n, Properties properties) {
            this.store(project, n, null, properties);
        }

        public void store(Project project, int n, String string, Properties properties) {
            String string2 = string == null ? n + "_" : n + "_" + string;
            properties.put(string2 + PROPERTY_TIMECOND_STARTTIME, Long.toString(this.startTime));
            properties.put(string2 + PROPERTY_TIMECOND_REPEATS, Boolean.toString(this.repeats));
            properties.put(string2 + PROPERTY_TIMECOND_PERIODTIME, Integer.toString(this.periodTime));
            properties.put(string2 + PROPERTY_TIMECOND_PERIODUNITS, Integer.toString(this.periodUnits));
        }

        void setScheduledTime(long l) {
            this.scheduledTime = l;
        }

        long getScheduledTime() {
            return this.scheduledTime;
        }
    }
}

