/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.LoadGeneratorCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class LoadGenProfilingPoint
extends CodeProfilingPoint.Paired
implements PropertyChangeListener {
    private static final String ONE_HIT_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_OneHitString");
    private static final String N_HITS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_NHitsString");
    private static final String NO_RESULTS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_NoResultsString");
    private static final String ANNOTATION_START_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_AnnotationStartString");
    private static final String ANNOTATION_END_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_AnnotationEndString");
    private static final String REPORT_ACCESS_DESCR = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_ReportAccessDescr");
    private static final String NO_HITS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_NoHitsString");
    private static final String HEADER_TYPE_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderTypeString");
    private static final String HEADER_ENABLED_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderEnabledString");
    private static final String HEADER_PROJECT_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderProjectString");
    private static final String HEADER_LOCATION_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderLocationString");
    private static final String HEADER_START_LOCATION_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderStartLocationString");
    private static final String HEADER_END_LOCATION_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderEndLocationString");
    private static final String HEADER_HITS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderHitsString");
    private static final String HIT_SUCCESS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HitSuccessString");
    private static final String HIT_FAILED_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HitFailedString");
    private static final String DATA_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_DataString");
    private static final Logger LOGGER = Logger.getLogger(LoadGenProfilingPoint.class.getName());
    public static final String PROPERTY_SCRIPTNAME = "p_ScriptName";
    private static final String ANNOTATION_ENABLED = "loadgenProfilingPoint";
    private static final String ANNOTATION_DISABLED = "loadgenProfilingPointD";
    private Annotation endAnnotation;
    private Annotation startAnnotation;
    private final List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private String scriptFileName;
    private WeakReference<Report> reportReference;

    public LoadGenProfilingPoint(String string, CodeProfilingPoint.Location location, CodeProfilingPoint.Location location2, Project project, ProfilingPointFactory profilingPointFactory) {
        super(string, location, location2, project, profilingPointFactory);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    public void setEnabled(boolean bl) {
        LoadGenPlugin loadGenPlugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
        if (loadGenPlugin != null) {
            super.setEnabled(bl);
        } else {
            LOGGER.warning("Can not enable the Load Generator profiling point. The appropriate modules are not installed.");
        }
    }

    public boolean isEnabled() {
        boolean bl = super.isEnabled();
        if (bl) {
            LoadGenPlugin loadGenPlugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
            bl &= loadGenPlugin != null;
        }
        return bl;
    }

    public String getScriptFileName() {
        return this.scriptFileName != null ? this.scriptFileName : "";
    }

    public void setSriptFileName(String string) {
        this.scriptFileName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return !this.results.isEmpty();
        }
    }

    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (LoadGenProfilingPoint.this.hasReport()) {
                    LoadGenProfilingPoint.this.getReport().close();
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.hasReport()) {
            if (propertyChangeEvent.getPropertyName() == "p_name") {
                this.getReport().refreshProperties();
            }
            this.getReport().refreshData();
        }
    }

    public void showResults(URL uRL) {
        Report report = this.getReport();
        report.open();
        report.requestActive();
    }

    protected CodeProfilingPoint.Annotation getEndAnnotation() {
        if (!this.usesEndLocation()) {
            this.endAnnotation = null;
        } else if (this.endAnnotation == null) {
            this.endAnnotation = new Annotation(false);
        }
        return this.endAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                return this.results.size() == 1 ? MessageFormat.format(ONE_HIT_STRING, Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp())) : MessageFormat.format(N_HITS_STRING, this.results.size(), Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp()));
            }
            return NO_RESULTS_STRING;
        }
    }

    protected CodeProfilingPoint.Annotation getStartAnnotation() {
        if (this.startAnnotation == null) {
            this.startAnnotation = new Annotation(true);
        }
        return this.startAnnotation;
    }

    protected void updateCustomizer(ValidityAwarePanel validityAwarePanel) {
        LoadGeneratorCustomizer loadGeneratorCustomizer = (LoadGeneratorCustomizer)validityAwarePanel;
        loadGeneratorCustomizer.setPPName(this.getName());
        loadGeneratorCustomizer.setPPStartLocation(this.getStartLocation());
        loadGeneratorCustomizer.setPPEndLocation(this.getEndLocation());
        loadGeneratorCustomizer.setScriptFile(this.getScriptFileName());
        loadGeneratorCustomizer.setProject(this.getProject());
    }

    protected boolean usesEndLocation() {
        return this.getEndLocation() != null;
    }

    void setValues(ValidityAwarePanel validityAwarePanel) {
        LoadGeneratorCustomizer loadGeneratorCustomizer = (LoadGeneratorCustomizer)validityAwarePanel;
        this.setName(loadGeneratorCustomizer.getPPName());
        this.setStartLocation(loadGeneratorCustomizer.getPPStartLocation());
        this.setEndLocation(loadGeneratorCustomizer.getPPEndLocation());
        this.setSriptFileName(loadGeneratorCustomizer.getScriptFile());
        Utils.checkLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hit(final RuntimeProfilingPoint.HitEvent hitEvent, int n) {
        LoadGenPlugin loadGenPlugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.usesEndLocation() && n == 1) {
                if (loadGenPlugin != null) {
                    loadGenPlugin.stop(this.getScriptFileName());
                    for (Result result : this.results) {
                        if (result.getEndTimestamp() != -1L || result.getThreadID() != hitEvent.getThreadId()) continue;
                        result.setEndTimestamp(hitEvent.getTimestamp());
                        break;
                    }
                }
            } else if (loadGenPlugin != null) {
                loadGenPlugin.start(this.getScriptFileName(), new LoadGenPlugin.Callback(){
                    private long correlationId;
                    {
                        this.correlationId = hitEvent.getTimestamp();
                    }

                    public void afterStart(LoadGenPlugin.Result result) {
                        Result result2 = new Result(hitEvent.getTimestamp(), hitEvent.getThreadId(), result == LoadGenPlugin.Result.SUCCESS);
                        LoadGenProfilingPoint.this.results.add(result2);
                        this.correlationId = hitEvent.getTimestamp();
                        LoadGenProfilingPoint.this.getChangeSupport().firePropertyChange("p_results", false, true);
                    }

                    public void afterStop(LoadGenPlugin.Result result) {
                        for (Result result2 : LoadGenProfilingPoint.this.results) {
                            if (result2.getTimestamp() != this.correlationId) continue;
                            result2.setEndTimestamp(this.correlationId);
                            result2.setStopTime();
                            break;
                        }
                        LoadGenProfilingPoint.this.getChangeSupport().firePropertyChange("p_results", false, true);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean bl = this.results.size() > 0;
            this.results.clear();
            if (bl) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private Report getReport() {
        if (this.hasReport()) {
            return (Report)((Object)this.reportReference.get());
        }
        Report report = new Report();
        this.reportReference = new WeakReference<Report>(report);
        return report;
    }

    private boolean hasReport() {
        return this.reportReference != null && this.reportReference.get() != null;
    }

    private class Report
    extends TopComponent {
        private static final String START_LOCATION_URLMASK = "file:/1";
        private static final String END_LOCATION_URLMASK = "file:/2";
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refreshData();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshData() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getHeaderName());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderType());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderEnabled());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderProject());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderStartLocation());
            stringBuilder.append("<br>");
            if (LoadGenProfilingPoint.this.usesEndLocation()) {
                stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                stringBuilder.append(this.getHeaderEndLocation());
                stringBuilder.append("<br>");
            }
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(stringBuilder.toString());
            StringBuilder stringBuilder2 = new StringBuilder();
            Object object = LoadGenProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (LoadGenProfilingPoint.this.results.size() == 0) {
                    stringBuilder2.append("&nbsp;&nbsp;&lt;" + NO_HITS_STRING + "&gt;");
                } else {
                    if (LoadGenProfilingPoint.this.results.size() > 1) {
                        Collections.sort(LoadGenProfilingPoint.this.results, new Comparator<Result>(){

                            @Override
                            public int compare(Result result, Result result2) {
                                return Long.valueOf(result.getTimestamp()).compareTo(result2.getTimestamp());
                            }
                        });
                    }
                    for (int i = 0; i < LoadGenProfilingPoint.this.results.size(); ++i) {
                        stringBuilder2.append("&nbsp;&nbsp;");
                        stringBuilder2.append(this.getDataResultItem(i));
                        stringBuilder2.append("<br>");
                    }
                }
            }
            this.dataArea.setText(stringBuilder2.toString());
        }

        void refreshProperties() {
            this.setName(LoadGenProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)LoadGenProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(REPORT_ACCESS_DESCR, this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int n) {
            Object object = LoadGenProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)LoadGenProfilingPoint.this.results.get(n);
                String string = Utils.formatProfilingPointTimeHiRes(result.getTimestamp());
                if (result.isSuccess()) {
                    return MessageFormat.format(HIT_SUCCESS_STRING, n + 1, string);
                }
                return MessageFormat.format(HIT_FAILED_STRING, n + 1, string);
            }
        }

        private String getHeaderEnabled() {
            return MessageFormat.format(HEADER_ENABLED_STRING, LoadGenProfilingPoint.this.isEnabled());
        }

        private String getHeaderEndLocation() {
            CodeProfilingPoint.Location location = LoadGenProfilingPoint.this.getEndLocation();
            File file = new File(location.getFile());
            String string = file.getName();
            int n = location.getLine();
            String string2 = "<a href='file:/2'>";
            return MessageFormat.format(HEADER_END_LOCATION_STRING, string2 + string, n) + "</a>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = LoadGenProfilingPoint.this.resultsSync;
            synchronized (object) {
                return MessageFormat.format(HEADER_HITS_STRING, LoadGenProfilingPoint.this.results.size());
            }
        }

        private String getHeaderName() {
            return "<h2><b>" + LoadGenProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return MessageFormat.format(HEADER_PROJECT_STRING, ProjectUtils.getInformation((Project)LoadGenProfilingPoint.this.getProject()).getDisplayName());
        }

        private String getHeaderStartLocation() {
            CodeProfilingPoint.Location location = LoadGenProfilingPoint.this.getStartLocation();
            File file = new File(location.getFile());
            String string = file.getName();
            int n = location.getLine();
            String string2 = "<a href='file:/1'>";
            return LoadGenProfilingPoint.this.usesEndLocation() ? MessageFormat.format(HEADER_START_LOCATION_STRING, string2 + string, n) + "</a>" : MessageFormat.format(HEADER_LOCATION_STRING, string2 + string, n) + "</a>";
        }

        private String getHeaderType() {
            return MessageFormat.format(HEADER_TYPE_STRING, LoadGenProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel.setOpaque(true);
            jPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL uRL) {
                    String string = uRL.toString();
                    if (Report.START_LOCATION_URLMASK.equals(string)) {
                        Utils.openLocation(LoadGenProfilingPoint.this.getStartLocation());
                    } else if (LoadGenProfilingPoint.this.usesEndLocation()) {
                        Utils.openLocation(LoadGenProfilingPoint.this.getEndLocation());
                    }
                }
            };
            JScrollPane jScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            jScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            jPanel.add((Component)jScrollPane, "North");
            this.dataArea = new HTMLTextArea();
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder titledBorder = new TitledBorder(DATA_STRING);
            titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
            titledBorder.setTitleColor(UIManager.getColor("Label.foreground"));
            jScrollPane2.setBorder(titledBorder);
            jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder());
            jScrollPane2.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel.add((Component)jScrollPane2, "Center");
            this.add(jPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private static class Result {
        private final int threadId;
        private final long timestamp;
        private boolean success = false;
        private long endTimestamp = -1L;
        private long startTime;
        private long stopTime;

        public Result(long l, int n, boolean bl) {
            this.timestamp = l;
            this.threadId = n;
            this.success = bl;
            this.startTime = System.currentTimeMillis();
            this.stopTime = 0L;
        }

        public long getDuration() {
            return this.stopTime > this.startTime ? this.stopTime - this.startTime : -1L;
        }

        public void setEndTimestamp(long l) {
            this.endTimestamp = l;
        }

        public long getEndTimestamp() {
            return this.endTimestamp;
        }

        public void setStopTime() {
            this.stopTime = System.currentTimeMillis();
        }

        public boolean isSuccess() {
            return this.success;
        }

        public int getThreadID() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private boolean isStartAnnotation;

        public Annotation(boolean bl) {
            this.isStartAnnotation = bl;
        }

        public String getAnnotationType() {
            return LoadGenProfilingPoint.this.isEnabled() ? LoadGenProfilingPoint.ANNOTATION_ENABLED : LoadGenProfilingPoint.ANNOTATION_DISABLED;
        }

        public String getShortDescription() {
            if (!LoadGenProfilingPoint.this.usesEndLocation()) {
                return LoadGenProfilingPoint.this.getName();
            }
            return this.isStartAnnotation ? MessageFormat.format(ANNOTATION_START_STRING, LoadGenProfilingPoint.this.getName()) : MessageFormat.format(ANNOTATION_END_STRING, LoadGenProfilingPoint.this.getName());
        }
    }
}

