/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.Collection;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;
import org.netbeans.modules.profiler.heapwalk.memorylint.RuleRegistry;
import org.netbeans.modules.profiler.heapwalk.memorylint.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryLint {
    private BoundedRangeModel progress;
    private Heap heap;
    private HierarchicalModel globalProgress;
    private StringBuffer results = new StringBuffer();
    private StringHelper stringHelper;
    private volatile boolean interrupted;

    public MemoryLint(Heap heap) {
        this.heap = heap;
        this.globalProgress = new HierarchicalModel(1, 1000);
    }

    public BoundedRangeModel getGlobalProgress() {
        return this.globalProgress;
    }

    public Heap getHeap() {
        return this.heap;
    }

    public boolean isInterruped() {
        return this.interrupted;
    }

    public String getResults() {
        return this.results.toString();
    }

    public String getRootIncommingString(Instance instance) {
        Instance instance2;
        String string = null;
        while ((instance2 = instance.getNearestGCRootPointer()) != null) {
            String string2 = this.getFullName(instance, instance2);
            if (string == null) {
                string = "<< " + string2;
            }
            if (!string2.startsWith("java.") && !string2.startsWith("javax.")) {
                return string2;
            }
            if (instance2.isGCRoot()) break;
            instance = instance2;
        }
        return string == null ? "unknown" : string;
    }

    public StringHelper getStringHelper() {
        if (this.stringHelper == null) {
            this.stringHelper = new StringHelper(this.heap);
        }
        return this.stringHelper;
    }

    public void appendResults(String string) {
        this.results.append(string).append('\n');
    }

    public static Collection<Rule> createRules() {
        return RuleRegistry.getRegisteredRules();
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void process(Collection<Rule> collection) {
        int n = collection.size();
        this.globalProgress.setSteps(n);
        for (Rule rule : collection) {
            rule.prepare(this);
            this.progress = this.globalProgress.getNextDelegate();
            this.results.append(rule.resultsHeader());
            rule.perform();
            this.results.append("<hr>");
            if (!this.isInterruped()) continue;
            break;
        }
    }

    BoundedRangeModel getProgress() {
        return this.progress;
    }

    private String getFullName(Instance instance, Instance instance2) {
        ObjectFieldValue objectFieldValue = this.getInField(instance, instance2);
        if (objectFieldValue == null) {
            return instance2.getJavaClass().getName();
        }
        if (objectFieldValue.getField().isStatic()) {
            return objectFieldValue.getField().getDeclaringClass().getName() + ";" + objectFieldValue.getField().getName();
        }
        return instance2.getJavaClass().getName() + ":" + objectFieldValue.getField().getName();
    }

    private ObjectFieldValue getInField(Instance instance, Instance instance2) {
        List list = instance2.getFieldValues();
        for (Object object : list) {
            if (!(object instanceof ObjectFieldValue) || !instance.equals(((ObjectFieldValue)object).getInstance())) continue;
            return (ObjectFieldValue)object;
        }
        if (instance2.getJavaClass().getName().equals("java.lang.Class")) {
            JavaClass javaClass = this.heap.getJavaClassByID(instance2.getInstanceId());
            list = javaClass.getStaticFieldValues();
            for (FieldValue fieldValue : list) {
                if (!(fieldValue instanceof ObjectFieldValue) || !instance.equals(((ObjectFieldValue)fieldValue).getInstance())) continue;
                return (ObjectFieldValue)fieldValue;
            }
        }
        return null;
    }

    private static class HierarchicalModel
    extends DefaultBoundedRangeModel
    implements ChangeListener {
        BoundedRangeModel delegate = new DefaultBoundedRangeModel(0, 0, 0, 1);
        int each;
        int step = -1;

        HierarchicalModel(int n, int n2) {
            super(0, 0, 0, n * n2);
            this.each = n2;
            this.delegate.addChangeListener(this);
        }

        public void setSteps(int n) {
            this.setRangeProperties(0, 0, 0, n * this.each, false);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateValue();
        }

        BoundedRangeModel getNextDelegate() {
            ++this.step;
            this.delegate.setRangeProperties(0, 0, 0, 1, false);
            this.updateValue();
            return this.delegate;
        }

        private void updateValue() {
            int n = this.getValue();
            this.setValue(this.step * this.each + this.each * this.delegate.getValue() / this.delegate.getMaximum());
        }
    }
}

