/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.DataOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SelfSamplerAction
extends AbstractAction
implements AWTEventListener {
    private static final String ACTION_NAME_START = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStart");
    private static final String ACTION_NAME_STOP = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStop");
    private static final String THREAD_NAME = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ThreadName");
    private static final String DEBUG_ARG = "-Xdebug";
    private static final Logger LOGGER = Logger.getLogger(SelfSamplerAction.class.getName());
    private static final int SAMPLER_RATE = 10;
    private static final double MAX_AVERAGE = 30.0;
    private static final double MAX_STDDEVIATION = 40.0;
    private final AtomicReference<Controller> RUNNING = new AtomicReference();
    private Boolean debugMode;
    private String lastReason;

    private SelfSamplerAction() {
        this.putValue("Name", ACTION_NAME_START);
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/openSnapshot.png", (boolean)false));
        if (System.getProperty(SelfSamplerAction.class.getName() + ".sniff") != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
    }

    public static final SelfSamplerAction getInstance() {
        return Singleton.INSTANCE;
    }

    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Controller controller = new Controller(THREAD_NAME);
        if (this.RUNNING.compareAndSet(null, controller)) {
            this.putValue("Name", ACTION_NAME_STOP);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/modifyProfiling.png", (boolean)false));
            controller.run();
        } else {
            controller = this.RUNNING.getAndSet(null);
            if (controller != null) {
                this.putValue("Name", ACTION_NAME_START);
                this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/openSnapshot.png", (boolean)false));
                controller.actionPerformed(new ActionEvent(this, 0, "show"));
            }
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 65406) {
            this.actionPerformed(new ActionEvent(this, aWTEvent.getID(), "shortcut"));
            keyEvent.consume();
        }
    }

    public Object getValue(String string) {
        Object object = super.getValue(string);
        if (object == null && string.startsWith("logger-") && this.isRunMode()) {
            return new Controller(string);
        }
        return object;
    }

    private synchronized boolean isDebugged() {
        if (this.debugMode == null) {
            this.debugMode = Boolean.FALSE;
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list = runtimeMXBean.getInputArguments();
            if (list.contains(DEBUG_ARG)) {
                this.debugMode = Boolean.TRUE;
            }
        }
        return this.debugMode;
    }

    private boolean isRunMode() {
        int n;
        boolean bl = true;
        String string = null;
        if (this.isDebugged()) {
            string = "running in debug mode";
            bl = false;
        }
        if (bl && (n = NetBeansProfiler.getDefaultNB().getProfilingState()) != 16 && n != 1) {
            string = "active profiling session";
            bl = false;
        }
        if (bl) {
            try {
                Class.forName("org.netbeans.lib.profiler.server.ProfilerServer", false, ClassLoader.getSystemClassLoader());
                string = "running under profiler";
                bl = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!bl && string != this.lastReason) {
            LOGGER.log(Level.INFO, "Slowness detector disabled - " + string);
        }
        this.lastReason = string;
        return bl;
    }

    private static final class Controller
    implements Runnable,
    ActionListener {
        private final String name;
        private StackTraceSnapshotBuilder builder;
        private Timer timer;
        private long startTime;
        private long samples;
        private long laststamp;
        private double max;
        private double min = 9.223372036854776E18;
        private double sum;
        private double devSquaresSum;

        public Controller(String string) {
            this.name = string;
        }

        private synchronized StackTraceSnapshotBuilder getBuilder() {
            if (this.builder == null) {
                this.builder = new StackTraceSnapshotBuilder();
                this.builder.setIgnoredThreads(Collections.singleton(this.name));
            }
            return this.builder;
        }

        private void updateStats(long l) {
            if (this.laststamp != 0L) {
                double d = (double)(l - this.laststamp) / 1000000.0;
                ++this.samples;
                this.sum += d;
                this.devSquaresSum += (d - 10.0) * (d - 10.0);
                if (d > this.max) {
                    this.max = d;
                } else if (d < this.min) {
                    this.min = d;
                }
            }
            this.laststamp = l;
        }

        public void run() {
            final StackTraceSnapshotBuilder stackTraceSnapshotBuilder = this.getBuilder();
            final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            this.startTime = System.currentTimeMillis();
            this.timer = new Timer(this.name);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    try {
                        ThreadInfo[] threadInfoArray = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE);
                        long l = System.nanoTime();
                        stackTraceSnapshotBuilder.addStacktrace(threadInfoArray, l);
                        Controller.this.updateStats(l);
                    }
                    catch (Throwable throwable) {
                        Exceptions.printStackTrace((Throwable)throwable);
                    }
                }
            }, 10L, 10L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object[] objectArray;
                this.timer.cancel();
                if ("cancel".equals(actionEvent.getActionCommand())) {
                    return;
                }
                double d = this.sum / (double)this.samples;
                double d2 = Math.sqrt(this.devSquaresSum / (double)this.samples);
                boolean bl = "write".equals(actionEvent.getActionCommand());
                if (bl) {
                    objectArray = new Object[]{this.startTime, "Samples", this.samples, "Average", d, "Minimum", this.min, "Maximum", this.max, "Std. deviation", d2};
                    Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Snapshot statistics", objectArray);
                    if (d > 30.0 || d2 > 40.0) {
                        return;
                    }
                }
                objectArray = this.getBuilder().createSnapshot(this.startTime);
                LoadedSnapshot loadedSnapshot = new LoadedSnapshot((ResultsSnapshot)objectArray, ProfilingSettingsPresets.createCPUPreset(), null, null);
                if (bl) {
                    DataOutputStream dataOutputStream = (DataOutputStream)actionEvent.getSource();
                    loadedSnapshot.save(dataOutputStream);
                    return;
                }
                loadedSnapshot.setSaved(true);
                ResultsManager.getDefault().openSnapshot(loadedSnapshot);
            }
            catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
                return;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            finally {
                this.getBuilder().reset();
            }
        }
    }

    private static final class Singleton {
        static final SelfSamplerAction INSTANCE = new SelfSamplerAction();

        private Singleton() {
        }
    }
}

