/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.MemoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.SurvivingGenerationsGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.ThreadsGraphPanel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class TelemetryWindow
extends TopComponent {
    private static final String THREADS_STATISTICS_TAB_NAME = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ThreadsStatisticsTabName");
    private static final String MEMORY_HEAP_TAB_NAME = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryHeapTabName");
    private static final String MEMORY_GC_TAB_NAME = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryGCTabName");
    private static final String THREADS_STATISTICS_TAB_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ThreadsStatisticsTabDescr");
    private static final String MEMORY_HEAP_TAB_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryHeapTabDescr");
    private static final String MEMORY_GC_TAB_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryGCTabDescr");
    private static final String TELEMETRY_ACCESS_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_TelemetryAccessDescr");
    private static final String HELP_CTX_KEY = "TelemetryWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TelemetryWindow.HelpCtx");
    private static TelemetryWindow defaultInstance;
    private static final Image windowIcon;
    private final GraphTab generationsPanel;
    private final GraphTab heapPanel;
    private final GraphTab threadsStatsPanel;
    private final JTabbedPane tabs;
    private final MemoryGraphPanel heapGraph;
    private final SurvivingGenerationsGraphPanel generationsGraph;
    private final ThreadsGraphPanel threadsStatsGraph;
    private Component lastFocusOwner;

    public TelemetryWindow() {
        this.setName(NbBundle.getMessage(TelemetryWindow.class, (String)"LAB_TelemetryWindowName"));
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(TELEMETRY_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.setTabPlacement(3);
        this.add(this.tabs, "Center");
        this.heapGraph = MemoryGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.generationsGraph = SurvivingGenerationsGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.threadsStatsGraph = ThreadsGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.heapPanel = new GraphTab((GraphPanel)this.heapGraph);
        this.generationsPanel = new GraphTab((GraphPanel)this.generationsGraph);
        this.threadsStatsPanel = new GraphTab((GraphPanel)this.threadsStatsGraph);
        this.tabs.addTab(MEMORY_HEAP_TAB_NAME, null, this.heapPanel, MEMORY_HEAP_TAB_DESCR);
        this.tabs.addTab(MEMORY_GC_TAB_NAME, null, this.generationsPanel, MEMORY_GC_TAB_DESCR);
        this.tabs.addTab(THREADS_STATISTICS_TAB_NAME, null, this.threadsStatsPanel, THREADS_STATISTICS_TAB_DESCR);
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TelemetryWindow.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TelemetryWindow.this.moveToNextSubTab();
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
    }

    public static TelemetryWindow getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new TelemetryWindow();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            IDEUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.threadsStatsGraph != null) {
            this.threadsStatsGraph.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public void showGC() {
        this.tabs.setSelectedComponent(this.generationsPanel);
        this.open();
        this.requestActive();
    }

    public void showHeap() {
        this.tabs.setSelectedComponent(this.heapPanel);
        this.open();
        this.requestActive();
    }

    public void showThreads() {
        this.tabs.setSelectedComponent(this.threadsStatsPanel);
        this.open();
        this.requestActive();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    static {
        windowIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/telemetryWindow.png");
    }

    private static final class GraphTab
    extends JPanel
    implements SaveViewAction.ViewProvider,
    ExportAction.ExportProvider {
        private static final String timestamp = "Timestamp";
        private static final String heapSize = "Heap_Size_in_Bytes";
        private static final String usedHeap = "Used_Heap_in_Bytes";
        private static final String survivingGenerations = "Surviving_Generations";
        private static final String timeInGC = "Relative_Time_Spent_in_GC";
        private static final String threadsCount = "Number_of_Threads";
        private static final String loadedClasses = "Loaded_Classes_Count";
        private final GraphPanel panel;
        private final ExportAction exportActionButton;

        public GraphTab(GraphPanel graphPanel) {
            this.panel = graphPanel;
            this.setLayout(new BorderLayout());
            JToolBar jToolBar = new JToolBar(){

                public Component add(Component component) {
                    if (component instanceof JButton) {
                        UIUtils.fixButtonUI((AbstractButton)((JButton)component));
                    }
                    return super.add(component);
                }
            };
            this.exportActionButton = new ExportAction(this, null);
            jToolBar.setFloatable(false);
            jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            jToolBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 0));
            jToolBar.add(this.exportActionButton);
            jToolBar.add(new SaveViewAction(this));
            jToolBar.addSeparator();
            for (Action action : graphPanel.getActions()) {
                jToolBar.add(action);
            }
            this.add((Component)jToolBar, "North");
            this.add((Component)graphPanel, "Center");
        }

        public BufferedImage getViewImage(boolean bl) {
            return UIUtils.createScreenshot((Component)this.panel);
        }

        public String getViewName() {
            if (this.panel instanceof MemoryGraphPanel) {
                return "memory-heap";
            }
            if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                return "memory-gc";
            }
            if (this.panel instanceof ThreadsGraphPanel) {
                return "threads-statistics";
            }
            return null;
        }

        public boolean fitsVisibleArea() {
            return true;
        }

        public boolean hasView() {
            return true;
        }

        private void exportCSVData(String string, ExportDataDumper exportDataDumper) {
            VMTelemetryDataManager vMTelemetryDataManager = Profiler.getDefault().getVMTelemetryManager();
            String string2 = "\r\n";
            String string3 = "\"";
            int n = vMTelemetryDataManager.getItemCount();
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            long[] lArray3 = new long[n];
            String string4 = timestamp;
            String string5 = new String();
            String string6 = new String();
            System.arraycopy(vMTelemetryDataManager.timeStamps, 0, lArray, 0, n);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.totalMemory, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.usedMemory, 0, lArray3, 0, n);
                string5 = heapSize;
                string6 = usedHeap;
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nSurvivingGenerations, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.relativeGCTimeInPerMil, 0, lArray3, 0, n);
                string5 = survivingGenerations;
                string6 = timeInGC;
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nUserThreads, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.loadedClassesCount, 0, lArray3, 0, n);
                string5 = threadsCount;
                string6 = loadedClasses;
            }
            exportDataDumper.dumpData(new StringBuffer(string3 + string4 + string3 + string + string3 + string5 + string3 + string + string3 + string6 + string3 + string2));
            Date date = new Date();
            for (int i = 0; i < n; ++i) {
                date.setTime(lArray[i]);
                exportDataDumper.dumpData(new StringBuffer(string3 + DateFormat.getDateTimeInstance().format(date) + string3 + string + string3 + lArray2[i] + string3 + string + string3 + lArray3[i] + string3 + string2));
            }
            exportDataDumper.close();
        }

        private void exportHTMLData(ExportDataDumper exportDataDumper) {
            VMTelemetryDataManager vMTelemetryDataManager = Profiler.getDefault().getVMTelemetryManager();
            int n = vMTelemetryDataManager.getItemCount();
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            long[] lArray3 = new long[n];
            String string = NbBundle.getMessage(TelemetryWindow.class, (String)timestamp);
            String string2 = new String();
            String string3 = new String();
            String string4 = new String();
            System.arraycopy(vMTelemetryDataManager.timeStamps, 0, lArray, 0, n);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.totalMemory, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.usedMemory, 0, lArray3, 0, n);
                string4 = MEMORY_HEAP_TAB_NAME;
                string2 = NbBundle.getMessage(TelemetryWindow.class, (String)heapSize);
                string3 = NbBundle.getMessage(TelemetryWindow.class, (String)usedHeap);
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nSurvivingGenerations, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.relativeGCTimeInPerMil, 0, lArray3, 0, n);
                string4 = MEMORY_GC_TAB_NAME;
                string2 = NbBundle.getMessage(TelemetryWindow.class, (String)survivingGenerations);
                string3 = NbBundle.getMessage(TelemetryWindow.class, (String)timeInGC);
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nUserThreads, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.loadedClassesCount, 0, lArray3, 0, n);
                string4 = THREADS_STATISTICS_TAB_NAME;
                string2 = NbBundle.getMessage(TelemetryWindow.class, (String)threadsCount);
                string3 = NbBundle.getMessage(TelemetryWindow.class, (String)loadedClasses);
            }
            StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string4 + "</TITLE></HEAD><BODY><table border=\"1\"><tr>");
            stringBuffer.append("<th>" + string + "</th><th>" + string2 + "</th><th>" + string3 + "</th></tr>");
            exportDataDumper.dumpData(stringBuffer);
            Date date = new Date();
            for (int i = 0; i < n; ++i) {
                date.setTime(lArray[i]);
                exportDataDumper.dumpData(new StringBuffer("<tr><td>" + DateFormat.getDateTimeInstance().format(date) + "</td><td align=right>" + lArray2[i] + "</td><td align=right>" + lArray3[i] + "</td></tr>"));
            }
            exportDataDumper.dumpDataAndClose(new StringBuffer("</table></BODY></HTML>"));
        }

        private void exportXMLData(ExportDataDumper exportDataDumper) {
            VMTelemetryDataManager vMTelemetryDataManager = Profiler.getDefault().getVMTelemetryManager();
            int n = vMTelemetryDataManager.getItemCount();
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            long[] lArray3 = new long[n];
            String string = NbBundle.getMessage(TelemetryWindow.class, (String)timestamp);
            String string2 = new String();
            String string3 = new String();
            String string4 = new String();
            System.arraycopy(vMTelemetryDataManager.timeStamps, 0, lArray, 0, n);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.totalMemory, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.usedMemory, 0, lArray3, 0, n);
                string4 = MEMORY_HEAP_TAB_NAME;
                string2 = heapSize;
                string3 = usedHeap;
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nSurvivingGenerations, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.relativeGCTimeInPerMil, 0, lArray3, 0, n);
                string4 = MEMORY_GC_TAB_NAME;
                string2 = survivingGenerations;
                string3 = timeInGC;
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nUserThreads, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.loadedClassesCount, 0, lArray3, 0, n);
                string4 = THREADS_STATISTICS_TAB_NAME;
                string2 = threadsCount;
                string3 = loadedClasses;
            }
            String string5 = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string5 + "<ExportedView Name=\"" + string4 + "\">" + string5);
            stringBuffer.append("<TableData NumRows=\"" + n + "\" NumColumns=\"3\">" + string5 + " <TableHeader>");
            stringBuffer.append(" <TableColumn>" + string + " </TableColumn>" + string5 + " <TableColumn>" + string2 + " </TableColumn>" + string5 + " <TableColumn>" + string3 + " </TableColumn>" + string5);
            stringBuffer.append(" </TableHeader>" + string5 + " <TableBody>" + string5);
            exportDataDumper.dumpData(stringBuffer);
            Date date = new Date();
            for (int i = 0; i < n; ++i) {
                date.setTime(lArray[i]);
                stringBuffer = new StringBuffer("  <TableRow>" + string5 + "   <TableCell>" + DateFormat.getDateTimeInstance().format(date) + "</TableCell>" + string5);
                stringBuffer.append("   <TableCell>" + lArray2[i] + "</TableCell>" + string5);
                stringBuffer.append("   <TableCell>" + lArray3[i] + "</TableCell>" + string5 + "  </TableRow>" + string5);
                exportDataDumper.dumpData(stringBuffer);
            }
            exportDataDumper.dumpDataAndClose(new StringBuffer(" </TableBody>" + string5 + "</TableData>" + string5 + "</ExportedView>"));
        }

        public void exportData(int n, ExportDataDumper exportDataDumper) {
            if (this.panel instanceof MemoryGraphPanel || this.panel instanceof SurvivingGenerationsGraphPanel || this.panel instanceof ThreadsGraphPanel) {
                switch (n) {
                    case 1: {
                        this.exportCSVData(",", exportDataDumper);
                        break;
                    }
                    case 2: {
                        this.exportCSVData(";", exportDataDumper);
                        break;
                    }
                    case 3: {
                        this.exportXMLData(exportDataDumper);
                        break;
                    }
                    case 4: {
                        this.exportHTMLData(exportDataDumper);
                    }
                }
            }
        }

        public boolean hasExportableView() {
            return Profiler.getDefault().getVMTelemetryManager().getItemCount() > 0;
        }

        public boolean hasLoadedSnapshot() {
            return false;
        }
    }
}

