/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.dd.api.web.WebFragmentProvider;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.netbeans.modules.j2ee.ddloaders.multiview.DDMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataLoader;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DDFragmentDataObject
extends DDDataObject {
    private transient WebApp webApp;
    private static final long serialVersionUID = 8857563089355069363L;
    private static final Logger LOG = Logger.getLogger(DDMultiViewDataObject.class.getName());

    public DDFragmentDataObject(FileObject fileObject, DDDataLoader dDDataLoader) throws DataObjectExistsException {
        super(fileObject, dDDataLoader);
    }

    public WebApp getWebApp() {
        if (this.webApp == null) {
            try {
                this.webApp = this.createWebFrag();
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "getWebApp failed", iOException);
            }
        }
        return this.webApp;
    }

    private WebApp createWebFrag() throws IOException {
        WebFragment webFragment = WebFragmentProvider.getDefault().getWebFragmentRoot(this.getPrimaryFile());
        if (webFragment != null) {
            this.setSaxError(webFragment.getError());
        }
        return webFragment;
    }

    protected void parseDocument() throws IOException {
        if (this.webApp == null) {
            try {
                this.webApp = WebFragmentProvider.getDefault().getWebFragmentRoot(this.getPrimaryFile());
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "parseDocument failed", iOException);
            }
        }
    }

    protected String getPrefixMark() {
        return "<web-fragment";
    }

    protected boolean isModelCreated() {
        return this.webApp != null;
    }

    public boolean isDeleteAllowed() {
        return true;
    }

    protected void validateDocument() throws IOException {
        InputSource inputSource = new InputSource(this.createReader());
        try {
            SAXParseException sAXParseException = WebParseUtils.parse((InputSource)inputSource);
            if (sAXParseException != null) {
                throw sAXParseException;
            }
        }
        catch (SAXException sAXException) {
            LOG.log(Level.SEVERE, "Parsing failed!", sAXException);
            throw new IOException("Parsing failed: " + sAXException);
        }
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        return new DesignMultiViewDesc[]{new DDDataObject.DDView(this, "Overview"), new DDDataObject.DDView(this, "Servlets"), new DDDataObject.DDView(this, "Filters"), new DDDataObject.DDView(this, "Pages"), new DDDataObject.DDView(this, "References"), new DDDataObject.DDView(this, "Security")};
    }
}

