/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.TextItemEditorModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.EntityOverviewForm;
import org.netbeans.modules.xml.multiview.ItemCheckBoxHelper;
import org.netbeans.modules.xml.multiview.ItemComboBoxHelper;
import org.netbeans.modules.xml.multiview.ItemEditorHelper;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;

public class EntityOverviewPanel
extends EntityOverviewForm {
    private XmlMultiViewDataSynchronizer synchronizer;
    private Entity entity;
    private static final String PK_COMPOUND = Utils.getBundleMessage("LBL_Compound_PK");
    private EntityHelper entityHelper;

    public EntityOverviewPanel(SectionNodeView sectionNodeView, final Entity entity, final EntityHelper entityHelper) {
        super(sectionNodeView);
        this.entityHelper = entityHelper;
        this.synchronizer = ((EjbJarMultiViewDataObject)sectionNodeView.getDataObject()).getModelSynchronizer();
        JTextField jTextField = this.getEjbNameTextField();
        JTextField jTextField2 = this.getPersistenceTypeTextField();
        JTextField jTextField3 = this.getAbstractSchemaNameTextField();
        JLabel jLabel = this.getPrimaryKeyFieldLabel();
        final JComboBox jComboBox = this.getPrimaryKeyFieldComboBox();
        final JComboBox jComboBox2 = this.getPrimaryKeyClassComboBox();
        JTextField jTextField4 = this.getPrimaryKeyClassTextField();
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)jTextField, (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(this.synchronizer, false){

            protected String getValue() {
                return entity.getEjbName();
            }

            protected void setValue(String string) {
                entity.setEjbName(string);
            }
        }));
        jTextField.setEditable(false);
        jTextField2.setEditable(false);
        this.entity = entity;
        String string = this.entity.getPersistenceType();
        boolean bl = "Container".equals(string);
        jTextField2.setText(string + (bl ? " (CMP)" : " (BMP)"));
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)jTextField3, (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(this.synchronizer, true){

            protected String getValue() {
                return entity.getAbstractSchemaName();
            }

            protected void setValue(String string) {
                entity.setAbstractSchemaName(string);
            }
        }));
        jTextField3.setEditable(false);
        if (bl) {
            jLabel.setVisible(true);
            jComboBox.setVisible(true);
            jComboBox2.setVisible(true);
            jTextField4.setVisible(false);
            this.initPrimaryKeyFieldComboBox();
            final ItemComboBoxHelper itemComboBoxHelper = new ItemComboBoxHelper(this.synchronizer, jComboBox){

                public String getItemValue() {
                    String string = entity.getPrimkeyField();
                    return string == null ? PK_COMPOUND : string;
                }

                public void setItemValue(String string) {
                    try {
                        entityHelper.setPrimkeyField(string == PK_COMPOUND ? null : string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Utils.notifyError(classNotFoundException);
                    }
                }
            };
            this.addRefreshable((Refreshable)itemComboBoxHelper);
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = jComboBox.getSelectedIndex();
                    if (n == 0) {
                        jComboBox2.setEnabled(true);
                        jComboBox2.setSelectedItem(entity.getPrimKeyClass());
                    } else {
                        jComboBox2.setEnabled(false);
                    }
                    jComboBox2.setSelectedItem(entity.getPrimKeyClass());
                }
            });
            jComboBox2.setEnabled(jComboBox.getSelectedIndex() == 0);
            jComboBox2.addItem("boolean");
            jComboBox2.addItem("byte");
            jComboBox2.addItem("char");
            jComboBox2.addItem("double");
            jComboBox2.addItem("float");
            jComboBox2.addItem("int");
            jComboBox2.addItem("long");
            jComboBox2.addItem("java.lang.Boolean");
            jComboBox2.addItem("java.lang.Byte");
            jComboBox2.addItem("java.lang.Character");
            jComboBox2.addItem("java.lang.Double");
            jComboBox2.addItem("java.lang.Float");
            jComboBox2.addItem("java.lang.Integer");
            jComboBox2.addItem("java.lang.Long");
            jComboBox2.addItem("java.lang.Object");
            jComboBox2.addItem("java.lang.String");
            jComboBox2.addItem("java.math.BigDecimal");
            this.addRefreshable((Refreshable)new ItemComboBoxHelper(this.synchronizer, jComboBox2){

                public String getItemValue() {
                    return entity.getPrimKeyClass();
                }

                public void setItemValue(String string) {
                    if (!Utils.isValidPackageName(string)) {
                        itemComboBoxHelper.refresh();
                    }
                }
            });
        } else {
            jLabel.setVisible(false);
            jComboBox.setVisible(false);
            jComboBox2.setVisible(false);
            jTextField4.setVisible(true);
            this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)jTextField4, (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(this.synchronizer, false){

                protected String getValue() {
                    return entity.getPrimKeyClass();
                }

                protected void setValue(String string) {
                    entity.setPrimKeyClass(string);
                }
            }));
        }
        this.addRefreshable((Refreshable)new ItemCheckBoxHelper(this.synchronizer, this.getReentrantCheckBox()){

            public boolean getItemValue() {
                return entity.isReentrant();
            }

            public void setItemValue(boolean bl) {
                entity.setReentrant(bl);
            }
        });
    }

    private void initPrimaryKeyFieldComboBox() {
        JComboBox jComboBox = this.getPrimaryKeyFieldComboBox();
        CmpField[] cmpFieldArray = this.entityHelper.cmpFields.getCmpFields();
        String[] stringArray = new String[cmpFieldArray.length + 1];
        stringArray[0] = PK_COMPOUND;
        for (int i = 0; i < cmpFieldArray.length; ++i) {
            stringArray[i + 1] = cmpFieldArray[i].getFieldName();
        }
        jComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    public void dataModelPropertyChange(Object object, String string, Object object2, Object object3) {
        super.dataModelPropertyChange(object, string, object2, object3);
    }

    public void refreshView() {
        this.initPrimaryKeyFieldComboBox();
        super.refreshView();
        this.getReentrantCheckBox().setSelected(this.entity.isReentrant());
    }
}

