/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsRegistryReader {
    private static String vendorsList = "Sun|Nokia|Motorola|Siemens|Ericsson|Samsung|Vodafone|Sprint";
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int NATIVE_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    private static final int VALUES_NUMBER = 2;
    private static final int MAX_KEY_LENGTH = 3;
    private static final int MAX_VALUE_NAME_LENGTH = 4;
    private static final int KEY_QUERY_VALUE = 1;
    private static final int KEY_ENUMERATE_SUB_KEYS = 8;
    private static Class WindowsPreferences;
    private static boolean ok;
    private static Method WindowsRegOpenKey;
    private static Method WindowsRegCloseKey;
    private static Method WindowsRegQueryValueEx;
    private static Method WindowsRegQueryInfoKey;
    private static Method WindowsRegEnumKeyEx;
    private static Method WindowsRegEnumValue;

    public static Set<File> traverseRegistry() {
        HashSet<File> hashSet = new HashSet<File>();
        if (ok && Utilities.isWindows()) {
            WindowsRegistryReader.traverseRegistry(-2147483646, hashSet);
            WindowsRegistryReader.traverseRegistry(-2147483647, hashSet);
        }
        return hashSet;
    }

    private WindowsRegistryReader() {
    }

    private static void traverseRegistry(int n, Set<File> set) {
        block5: {
            StringBuffer stringBuffer = new StringBuffer(vendorsList);
            for (String[] stringArray : Lookup.getDefault().lookup(new Lookup.Template(CustomCLDCPlatformConfigurator.class)).allInstances()) {
                String string = stringArray.getRegistryProviderName();
                if (string == null) continue;
                stringBuffer.append('|').append(string);
            }
            Pattern pattern = Pattern.compile(stringBuffer.toString(), 2);
            try {
                String[] stringArray;
                stringArray = WindowsRegistryReader.getChildren(n, "Software");
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] == null || !pattern.matcher(stringArray[i]).find()) continue;
                        WindowsRegistryReader.traverseRegistry(n, "Software\\" + stringArray[i], set);
                    }
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)throwable;
            }
        }
    }

    private static void traverseRegistry(int n, String string, Set<File> set) {
        if (string.length() > 256) {
            return;
        }
        try {
            String[] stringArray;
            String[] stringArray2 = WindowsRegistryReader.getKeys(n, string);
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i] == null) continue;
                    try {
                        File file;
                        String string2 = WindowsRegistryReader.get(n, string, stringArray2[i]);
                        if (string2 == null || string2.length() <= 3 || !(file = new File(string2)).isDirectory() || !file.isAbsolute()) continue;
                        set.add(file);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if ((stringArray = WindowsRegistryReader.getChildren(n, string)) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    WindowsRegistryReader.traverseRegistry(n, string + '\\' + stringArray[i], set);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(int n, String string, String string2) {
        int n2 = WindowsRegistryReader.WindowsRegOpenKey(n, WindowsRegistryReader.toByteArray(string), 1)[0];
        if (n2 == 0) {
            return null;
        }
        try {
            byte[] byArray = WindowsRegistryReader.WindowsRegQueryValueEx(n2, WindowsRegistryReader.toByteArray(string2));
            String string3 = byArray == null ? null : WindowsRegistryReader.toJavaValueString(byArray);
            return string3;
        }
        finally {
            WindowsRegistryReader.WindowsRegCloseKey(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getKeys(int n, String string) {
        int n2 = WindowsRegistryReader.WindowsRegOpenKey(n, WindowsRegistryReader.toByteArray(string), 1)[0];
        if (n2 == 0) {
            return null;
        }
        try {
            int[] nArray = WindowsRegistryReader.WindowsRegQueryInfoKey(n2);
            if (nArray[1] != 0) {
                String[] stringArray = null;
                return stringArray;
            }
            int n3 = nArray[4];
            int n4 = nArray[2];
            if (n4 == 0) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] stringArray = new String[n4];
            for (int i = 0; i < n4; ++i) {
                stringArray[i] = WindowsRegistryReader.byteArrayToString(WindowsRegistryReader.WindowsRegEnumValue(n2, i, n3 + 1));
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            WindowsRegistryReader.WindowsRegCloseKey(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getChildren(int n, String string) {
        int n2 = WindowsRegistryReader.WindowsRegOpenKey(n, WindowsRegistryReader.toByteArray(string), 9)[0];
        if (n2 == 0) {
            return null;
        }
        try {
            int[] nArray = WindowsRegistryReader.WindowsRegQueryInfoKey(n2);
            if (nArray[1] != 0) {
                String[] stringArray = null;
                return stringArray;
            }
            int n3 = nArray[3];
            int n4 = nArray[0];
            if (n4 == 0) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] stringArray = new String[n4];
            for (int i = 0; i < n4; ++i) {
                stringArray[i] = WindowsRegistryReader.byteArrayToString(WindowsRegistryReader.WindowsRegEnumKeyEx(n2, i, n3 + 1));
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            WindowsRegistryReader.WindowsRegCloseKey(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method findMethod(String string, Class[] classArray) {
        if (ok) {
            try {
                Object object = vendorsList;
                synchronized (object) {
                    if (WindowsPreferences == null) {
                        WindowsPreferences = Class.forName("java.util.prefs.WindowsPreferences");
                    }
                }
                object = WindowsPreferences.getDeclaredMethod(string, classArray);
                ((Method)object).setAccessible(true);
                return object;
            }
            catch (Exception exception) {
                ok = false;
            }
        }
        return null;
    }

    private static int[] WindowsRegOpenKey(int n, byte[] byArray, int n2) {
        try {
            return (int[])WindowsRegOpenKey.invoke(null, new Integer(n), byArray, new Integer(n2));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception.getLocalizedMessage());
        }
    }

    private static int WindowsRegCloseKey(int n) {
        try {
            return (Integer)WindowsRegCloseKey.invoke(null, new Integer(n));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception.getLocalizedMessage());
        }
    }

    private static byte[] WindowsRegQueryValueEx(int n, byte[] byArray) {
        try {
            return (byte[])WindowsRegQueryValueEx.invoke(null, new Integer(n), byArray);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception.getLocalizedMessage());
        }
    }

    private static int[] WindowsRegQueryInfoKey(int n) {
        try {
            return (int[])WindowsRegQueryInfoKey.invoke(null, new Integer(n));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception.getLocalizedMessage());
        }
    }

    private static byte[] WindowsRegEnumKeyEx(int n, int n2, int n3) {
        try {
            return (byte[])WindowsRegEnumKeyEx.invoke(null, new Integer(n), new Integer(n2), new Integer(n3));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception.getLocalizedMessage());
        }
    }

    private static byte[] WindowsRegEnumValue(int n, int n2, int n3) {
        try {
            return (byte[])WindowsRegEnumValue.invoke(null, new Integer(n), new Integer(n2), new Integer(n3));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception.getLocalizedMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String toJavaValueString(byte[] byArray) {
        String string = WindowsRegistryReader.byteArrayToString(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int n2;
            block8: {
                block6: {
                    int n3;
                    block7: {
                        n2 = string.charAt(n);
                        if (n2 != 47) break block6;
                        n3 = 32;
                        if (string.length() <= n + 1) break block7;
                        char c = string.charAt(n + 1);
                        n3 = c;
                        if (c != 'u') break block7;
                        if (string.length() < n + 6) {
                            return stringBuffer.toString();
                        }
                        n2 = (char)Integer.parseInt(string.substring(n + 2, n + 6), 16);
                        n += 5;
                        break block8;
                    }
                    if (string.length() > n + 1 && string.charAt(n + 1) >= 'A' && n3 <= 90) {
                        n2 = n3;
                        ++n;
                        break block8;
                    } else if (string.length() > n + 1 && n3 == 47) {
                        n2 = 92;
                        ++n;
                    }
                    break block8;
                }
                if (n2 == 92) {
                    n2 = 47;
                }
            }
            stringBuffer.append((char)n2);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static byte[] toByteArray(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[string.length()] = 0;
        return byArray;
    }

    private static String byteArrayToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new String(byArray, 0, byArray.length - 1);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(WindowsRegistryReader.traverseRegistry());
    }

    static {
        ok = true;
        WindowsRegOpenKey = WindowsRegistryReader.findMethod("WindowsRegOpenKey", new Class[]{Integer.TYPE, byte[].class, Integer.TYPE});
        WindowsRegCloseKey = WindowsRegistryReader.findMethod("WindowsRegCloseKey", new Class[]{Integer.TYPE});
        WindowsRegQueryValueEx = WindowsRegistryReader.findMethod("WindowsRegQueryValueEx", new Class[]{Integer.TYPE, byte[].class});
        WindowsRegQueryInfoKey = WindowsRegistryReader.findMethod("WindowsRegQueryInfoKey", new Class[]{Integer.TYPE});
        WindowsRegEnumKeyEx = WindowsRegistryReader.findMethod("WindowsRegEnumKeyEx", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
        WindowsRegEnumValue = WindowsRegistryReader.findMethod("WindowsRegEnumValue", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
    }
}

