/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.highlights;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.highlights.HighlightLayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.WeakSet;

public final class HighlighterImpl
implements PropertyChangeListener,
ChangeListener {
    private static HighlighterImpl INSTANCE = new HighlighterImpl();
    private Map comp2FO;
    private Map fo2Comp;
    private Object tag = new Object();

    public static HighlighterImpl getDefault() {
        return INSTANCE;
    }

    public HighlighterImpl() {
        this.comp2FO = new WeakHashMap();
        this.fo2Comp = new WeakHashMap();
    }

    private HighlightLayer getLayer(JTextComponent jTextComponent) {
        return (HighlightLayer)((Object)jTextComponent.getClientProperty(this.tag));
    }

    synchronized void assureRegistered(JTextComponent jTextComponent) {
        if (jTextComponent == null || this.getLayer(jTextComponent) != null) {
            return;
        }
        this.comp2FO.put(jTextComponent, null);
        jTextComponent.addPropertyChangeListener(this);
        this.updateFileObjectMapping(jTextComponent);
        HighlightLayer highlightLayer = new HighlightLayer();
        jTextComponent.putClientProperty(this.tag, (Object)highlightLayer);
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        if (editorUI != null) {
            editorUI.addLayer((DrawLayer)highlightLayer, 3000);
        }
    }

    private synchronized void updateFileObjectMapping(JTextComponent jTextComponent) {
        Collection collection;
        Document document = jTextComponent.getDocument();
        Object object = document.getProperty("stream");
        FileObject fileObject = this.comp2FO.put(jTextComponent, null);
        if (fileObject != null && (collection = (Collection)this.fo2Comp.get(fileObject)) != null) {
            collection.remove(jTextComponent);
        }
        if (object != null && object instanceof DataObject) {
            collection = ((DataObject)object).getPrimaryFile();
            this.comp2FO.put(jTextComponent, collection);
            this.getComponents((FileObject)collection).add(jTextComponent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            this.updateFileObjectMapping((JTextComponent)propertyChangeEvent.getSource());
        }
        final Object object = propertyChangeEvent.getSource();
        if ("UI".equals(propertyChangeEvent.getPropertyName()) && object instanceof JTextComponent) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    JTextComponent jTextComponent = (JTextComponent)object;
                    HighlighterImpl highlighterImpl = HighlighterImpl.this;
                    synchronized (highlighterImpl) {
                        HighlightLayer highlightLayer = HighlighterImpl.this.getLayer(jTextComponent);
                        if (highlightLayer == null) {
                            return;
                        }
                        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
                        if (editorUI != null && editorUI.findLayer("highlight-layer") == null) {
                            editorUI.addLayer((DrawLayer)highlightLayer, 3000);
                        }
                    }
                }
            });
        }
    }

    private Collection getComponents(FileObject fileObject) {
        Collection collection = (Collection)this.fo2Comp.get(fileObject);
        if (collection == null) {
            collection = new WeakSet();
            this.fo2Comp.put(fileObject, collection);
        }
        return collection;
    }

    public synchronized void setHighlights(FileObject fileObject, String string, Collection collection) {
        for (JTextComponent jTextComponent : this.getComponents(fileObject)) {
            HighlightLayer highlightLayer = this.getLayer(jTextComponent);
            if (highlightLayer == null) continue;
            highlightLayer.setHighlights(string, collection);
            jTextComponent.repaint();
            Caret caret = jTextComponent.getCaret();
            if (!(caret instanceof BaseCaret)) continue;
            ((BaseCaret)caret).refresh();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.assureRegistered(Registry.getMostActiveComponent());
    }
}

