/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.editor.SyncDocumentRegion;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenamePerformer
implements DocumentListener,
KeyListener {
    private SyncDocumentRegion region;
    private Document doc;
    private JTextComponent target;
    private AttributeSet attribs = null;
    private AttributeSet attribsLeft = null;
    private AttributeSet attribsRight = null;
    private AttributeSet attribsMiddle = null;
    private AttributeSet attribsAll = null;
    private AttributeSet attribsSlave = null;
    private AttributeSet attribsSlaveLeft = null;
    private AttributeSet attribsSlaveRight = null;
    private AttributeSet attribsSlaveMiddle = null;
    private AttributeSet attribsSlaveAll = null;
    private boolean inSync;
    private static final AttributeSet defaultSyncedTextBlocksHighlight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.red});

    private InstantRenamePerformer(JTextComponent jTextComponent, Set<OffsetRange> set, int n) throws BadLocationException {
        this.target = jTextComponent;
        this.doc = jTextComponent.getDocument();
        MutablePositionRegion object = null;
        ArrayList<MutablePositionRegion> arrayList = new ArrayList<MutablePositionRegion>();
        for (OffsetRange object2 : set) {
            Position position;
            Position position2 = NbDocument.createPosition((Document)this.doc, (int)object2.getStart(), (Position.Bias)Position.Bias.Backward);
            MutablePositionRegion mutablePositionRegion = new MutablePositionRegion(position2, position = NbDocument.createPosition((Document)this.doc, (int)object2.getEnd(), (Position.Bias)Position.Bias.Forward));
            if (this.isIn(mutablePositionRegion, n)) {
                object = mutablePositionRegion;
                continue;
            }
            arrayList.add(mutablePositionRegion);
        }
        if (object == null) {
            Logger.getLogger(InstantRenamePerformer.class.getName()).warning("No highlight contains the caret (" + n + "; highlights=" + set + ")");
            if (arrayList.size() > 0) {
                object = (MutablePositionRegion)arrayList.get(0);
                int n2 = Integer.MAX_VALUE;
                for (MutablePositionRegion mutablePositionRegion : arrayList) {
                    int n3 = n < mutablePositionRegion.getStartOffset() ? mutablePositionRegion.getStartOffset() - n : n - mutablePositionRegion.getEndOffset();
                    if (n3 >= n2) continue;
                    object = mutablePositionRegion;
                    n2 = n3;
                }
            } else {
                return;
            }
        }
        arrayList.add(0, object);
        this.region = new SyncDocumentRegion(this.doc, arrayList);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).addPostModificationDocumentListener((DocumentListener)this);
        }
        jTextComponent.addKeyListener(this);
        jTextComponent.putClientProperty(InstantRenamePerformer.class, this);
        this.requestRepaint();
        jTextComponent.select(object.getStartOffset(), object.getEndOffset());
    }

    private static InstantRenamePerformer getPerformerFromComponent(JTextComponent jTextComponent) {
        return (InstantRenamePerformer)jTextComponent.getClientProperty(InstantRenamePerformer.class);
    }

    public static void performInstantRename(JTextComponent jTextComponent, Set<OffsetRange> set, int n) throws BadLocationException {
        InstantRenamePerformer instantRenamePerformer = InstantRenamePerformer.getPerformerFromComponent(jTextComponent);
        if (instantRenamePerformer != null) {
            instantRenamePerformer.release();
        }
        new InstantRenamePerformer(jTextComponent, set, n);
    }

    private boolean isIn(MutablePositionRegion mutablePositionRegion, int n) {
        return mutablePositionRegion.getStartOffset() <= n && n <= mutablePositionRegion.getEndOffset();
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.inSync = false;
        this.requestRepaint();
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        if (this.doc.getProperty("doc-replace-selection-property") != null) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.inSync = false;
        this.requestRepaint();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && keyEvent.getModifiers() == 0 || keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0) {
            this.release();
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    void release() {
        this.target.putClientProperty(InstantRenamePerformer.class, null);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).removePostModificationDocumentListener((DocumentListener)this);
        }
        this.target.removeKeyListener(this);
        this.target = null;
        this.region = null;
        this.requestRepaint();
        this.doc = null;
    }

    private void requestRepaint() {
        if (this.region == null) {
            OffsetsBag offsetsBag = InstantRenamePerformer.getHighlightsBag(this.doc);
            offsetsBag.clear();
        } else {
            Object object;
            if (this.attribs == null) {
                this.attribs = InstantRenamePerformer.getSyncedTextBlocksHighlight("synchronized-text-blocks-ext");
                object = (Color)this.attribs.getAttribute(StyleConstants.Foreground);
                Color color = (Color)this.attribs.getAttribute(StyleConstants.Background);
                this.attribsLeft = InstantRenamePerformer.createAttribs(StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                this.attribsRight = InstantRenamePerformer.createAttribs(StyleConstants.Background, color, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                this.attribsMiddle = InstantRenamePerformer.createAttribs(StyleConstants.Background, color, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                this.attribsAll = InstantRenamePerformer.createAttribs(StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                this.attribsSlave = InstantRenamePerformer.getSyncedTextBlocksHighlight("synchronized-text-blocks-ext-slave");
                Color color2 = (Color)this.attribsSlave.getAttribute(StyleConstants.Foreground);
                Color color3 = (Color)this.attribsSlave.getAttribute(StyleConstants.Background);
                this.attribsSlaveLeft = InstantRenamePerformer.createAttribs(StyleConstants.Background, color3, EditorStyleConstants.LeftBorderLineColor, color2, EditorStyleConstants.TopBorderLineColor, color2, EditorStyleConstants.BottomBorderLineColor, color2);
                this.attribsSlaveRight = InstantRenamePerformer.createAttribs(StyleConstants.Background, color3, EditorStyleConstants.RightBorderLineColor, color2, EditorStyleConstants.TopBorderLineColor, color2, EditorStyleConstants.BottomBorderLineColor, color2);
                this.attribsSlaveMiddle = InstantRenamePerformer.createAttribs(StyleConstants.Background, color3, EditorStyleConstants.TopBorderLineColor, color2, EditorStyleConstants.BottomBorderLineColor, color2);
                this.attribsSlaveAll = InstantRenamePerformer.createAttribs(StyleConstants.Background, color3, EditorStyleConstants.LeftBorderLineColor, color2, EditorStyleConstants.RightBorderLineColor, color2, EditorStyleConstants.TopBorderLineColor, color2, EditorStyleConstants.BottomBorderLineColor, color2);
            }
            object = new OffsetsBag(this.doc);
            for (int i = 0; i < this.region.getRegionCount(); ++i) {
                int n = this.region.getRegion(i).getStartOffset();
                int n2 = this.region.getRegion(i).getEndOffset();
                int n3 = this.region.getRegion(i).getLength();
                if (n3 == 1) {
                    object.addHighlight(n, n2, i == 0 ? this.attribsAll : this.attribsSlaveAll);
                    continue;
                }
                if (n3 <= 1) continue;
                object.addHighlight(n, n + 1, i == 0 ? this.attribsLeft : this.attribsSlaveLeft);
                object.addHighlight(n2 - 1, n2, i == 0 ? this.attribsRight : this.attribsSlaveRight);
                if (n3 <= 2) continue;
                object.addHighlight(n + 1, n2 - 1, i == 0 ? this.attribsMiddle : this.attribsSlaveMiddle);
            }
            OffsetsBag offsetsBag = InstantRenamePerformer.getHighlightsBag(this.doc);
            offsetsBag.setHighlights(object);
        }
    }

    private static AttributeSet getSyncedTextBlocksHighlight(String string) {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings != null ? fontColorSettings.getFontColors(string) : null;
        return attributeSet == null ? defaultSyncedTextBlocksHighlight : attributeSet;
    }

    private static AttributeSet createAttribs(Object ... objectArray) {
        assert (objectArray.length % 2 == 0) : "There must be even number of prameters. They are key-value pairs of attributes that will be inserted into the set.";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = objectArray.length / 2 - 1; i >= 0; --i) {
            Object object = objectArray[2 * i];
            Object object2 = objectArray[2 * i + 1];
            if (object == null || object2 == null) continue;
            arrayList.add(object);
            arrayList.add(object2);
        }
        return AttributesUtilities.createImmutable((Object[])arrayList.toArray());
    }

    public static OffsetsBag getHighlightsBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(InstantRenamePerformer.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(InstantRenamePerformer.class, offsetsBag);
            FileObject fileObject = DataLoadersBridge.getDefault().getFileObject(document);
            if (fileObject instanceof FileObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "Instant Rename Highlights Bag", new Object[]{fileObject, offsetsBag});
            }
        }
        return offsetsBag;
    }
}

