/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.editor.InstantRenamePerformer;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenameAction
extends BaseAction {
    public InstantRenameAction() {
        super("in-place-refactoring", 10);
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        try {
            final int n = jTextComponent.getCaretPosition();
            String string = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)jTextComponent), (int)n);
            if (string == null) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(InstantRenameAction.class, (String)"InstantRenameDenied"));
                return;
            }
            if (IndexingManager.getDefault().isIndexing()) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(InstantRenameAction.class, (String)"scanning-in-progress"));
                return;
            }
            Source source = Source.create((FileObject)DataLoadersBridge.getDefault().getFileObject(jTextComponent));
            if (source == null) {
                return;
            }
            final boolean[] blArray = new boolean[1];
            final String[] stringArray = new String[1];
            final Set[] setArray = new Set[1];
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult(jTextComponent.getCaretPosition());
                    if (!(result instanceof ParserResult)) {
                        return;
                    }
                    ParserResult parserResult = (ParserResult)result;
                    Document document = jTextComponent.getDocument();
                    BaseDocument baseDocument = (BaseDocument)document;
                    List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
                    Language language = null;
                    for (Language stringArray2 : list) {
                        if (stringArray2.getInstantRenamer() == null) continue;
                        language = stringArray2;
                        break;
                    }
                    if (language != null) {
                        InstantRenamer instantRenamer = language.getInstantRenamer();
                        assert (instantRenamer != null);
                        String[] stringArray3 = new String[1];
                        if (instantRenamer == null || !instantRenamer.isRenameAllowed(parserResult, n, stringArray3)) {
                            blArray[0] = false;
                            stringArray[0] = stringArray3[0];
                            return;
                        }
                        blArray[0] = true;
                        Set<OffsetRange> set = instantRenamer.getRenameRegions(parserResult, n);
                        if (set != null && set.size() > 0) {
                            setArray[0] = set;
                        }
                    }
                }
            });
            if (blArray[0]) {
                if (setArray[0] != null) {
                    this.doInstantRename(setArray[0], jTextComponent, n, string);
                } else {
                    this.doFullRename(DataLoadersBridge.getDefault().getCookie(jTextComponent, EditorCookie.class), DataLoadersBridge.getDefault().getNodeDelegate(jTextComponent));
                }
            } else {
                if (stringArray[0] == null) {
                    stringArray[0] = NbBundle.getMessage(InstantRenameAction.class, (String)"InstantRenameDenied");
                }
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)stringArray[0]);
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        catch (ParseException parseException) {
            ErrorManager.getDefault().notify((Throwable)parseException);
        }
    }

    protected Class getShortDescriptionBundleClass() {
        return InstantRenameAction.class;
    }

    private void doInstantRename(Set<OffsetRange> set, JTextComponent jTextComponent, int n, String string) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(jTextComponent, set, n);
    }

    private void doFullRename(EditorCookie editorCookie, Node node) {
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)editorCookie);
        instanceContent.add((Object)node);
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
        action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }
}

