/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedElement;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;

public class PhpWhereUsedQueryPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    private WhereUsedQuery refactoring;
    private WhereUsedSupport usages;

    public PhpWhereUsedQueryPlugin(WhereUsedQuery whereUsedQuery) {
        this.refactoring = whereUsedQuery;
        this.usages = (WhereUsedSupport)whereUsedQuery.getRefactoringSource().lookup(WhereUsedSupport.class);
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.isFindUsages() || this.isFindDirectSubclassesOnly()) {
            Set<FileObject> set = this.usages.getRelevantFiles();
            this.fireProgressListenerStart(1, set.size());
            for (FileObject object2 : set) {
                if (object2 == null) continue;
                if (this.isFindDirectSubclassesOnly()) {
                    this.usages.collectDirectSubclasses(object2);
                } else {
                    this.usages.collectUsages(object2);
                }
                this.fireProgressListenerStep();
            }
            WhereUsedSupport.Results results = this.usages.getResults();
            Collection<WhereUsedElement> collection = results.getResultElements();
            for (WhereUsedElement whereUsedElement : collection) {
                refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)whereUsedElement);
            }
            this.fireProgressListenerStop();
        }
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchInComments() {
        return this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS");
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }
}

