/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.j2ee.ejbjarproject.ui.wizards.SettingsPanel;
import org.netbeans.modules.java.api.common.project.ui.wizards.FolderList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 17605310116880120L;
    private final Panel firer;
    private WizardDescriptor wizardDescriptor;
    private File oldProjectLocation;
    private final DocumentListener configAndLibrariesListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            PanelSourceFolders.this.dataChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            PanelSourceFolders.this.dataChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            PanelSourceFolders.this.dataChanged();
        }
    };
    private JButton jButtonConfigFilesLocation;
    private JButton jButtonLibraries;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jTextFieldConfigFiles;
    private JTextField jTextFieldLibraries;
    private JPanel sourcePanel;
    private JPanel testsPanel;

    public PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(PanelSourceFolders.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_ImportEJBModule"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel);
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
        this.jTextFieldConfigFiles.getDocument().addDocumentListener(this.configAndLibrariesListener);
        this.jTextFieldLibraries.getDocument().addDocumentListener(this.configAndLibrariesListener);
    }

    public void initValues(FileObject fileObject) {
        Object object;
        ((FolderList)this.sourcePanel).setLastUsedDir(FileUtil.toFile((FileObject)fileObject));
        ((FolderList)this.testsPanel).setLastUsedDir(FileUtil.toFile((FileObject)fileObject));
        FileObject fileObject2 = FileSearchUtility.guessConfigFilesPath((FileObject)fileObject, (String)"ejb-jar.xml");
        if (fileObject2 != null) {
            object = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
            this.jTextFieldConfigFiles.setText((String)object);
        }
        object = FileSearchUtility.guessLibrariesFolder((FileObject)fileObject);
        if (object != null) {
            String string = FileUtil.toFile((FileObject)object).getAbsolutePath();
            this.jTextFieldLibraries.setText(string);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("files".equals(propertyChangeEvent.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        File file = (File)wizardDescriptor.getProperty("sourceRoot");
        ((FolderList)this.sourcePanel).setProjectFolder(file);
        ((FolderList)this.testsPanel).setProjectFolder(file);
        if (!file.equals(this.oldProjectLocation)) {
            File[] fileArray;
            File[] fileArray2 = (File[])wizardDescriptor.getProperty("javaRoot");
            if (fileArray2 != null) {
                ((FolderList)this.sourcePanel).setFiles(fileArray2);
            }
            if ((fileArray = (File[])wizardDescriptor.getProperty("testRoot")) != null) {
                ((FolderList)this.testsPanel).setFiles(fileArray);
            }
            this.initValues(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
            this.oldProjectLocation = file;
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        File[] fileArray = ((FolderList)this.sourcePanel).getFiles();
        File[] fileArray2 = ((FolderList)this.testsPanel).getFiles();
        wizardDescriptor.putProperty("javaRoot", (Object)fileArray);
        wizardDescriptor.putProperty("testRoot", (Object)fileArray2);
        wizardDescriptor.putProperty("configFilesFolder", (Object)this.getConfigFiles());
        wizardDescriptor.putProperty("libFolder", (Object)this.getLibraries());
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        File file2 = this.getConfigFiles();
        if (file2 == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_BlankConfigurationFilesFolder"));
            return false;
        }
        File[] fileArray = ((FolderList)this.sourcePanel).getFiles();
        if (fileArray.length == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_BlankSourceFilesFolder"));
            return false;
        }
        File[] fileArray2 = ((FolderList)this.testsPanel).getFiles();
        String string = PanelSourceFolders.checkValidity(file, file2, this.getLibraries(), fileArray, fileArray2);
        if (string == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        return false;
    }

    static String checkValidity(File file, File file2, File file3, File[] fileArray, File[] fileArray2) {
        String string;
        int n;
        FileObject fileObject;
        String string2 = file.getAbsolutePath();
        if (!(file2 == null || (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2))) != null && fileObject.isFolder())) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalConfigurationFilesFolder");
        }
        if (!(file3 == null || (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file3))) != null && fileObject.isFolder())) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalLibrariesFolder");
        }
        if (fileArray.length == 0) {
            return " ";
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (!fileArray[n].isDirectory() || !fileArray[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalSources"), fileArray[n].getAbsolutePath());
            }
            string = fileArray[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (n = 0; n < fileArray2.length; ++n) {
            if (!fileArray2[n].isDirectory() || !fileArray2[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalTests"), fileArray[n].getAbsolutePath());
            }
            string = fileArray2[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private void searchClassFiles(File[] fileArray) throws WizardValidationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        for (int i = 0; i < fileArray.length; ++i) {
            object4 = FileUtil.toFileObject((File)fileArray[i]);
            if (object4 == null) continue;
            object3 = object4.getData(true);
            while (!bl && object3.hasMoreElements()) {
                object2 = object3.nextElement();
                assert (object2 instanceof FileObject) : "Instance of FileObject: " + object2;
                object = (FileObject)object2;
                bl = "class".equals(object.getExt());
            }
        }
        if (bl) {
            String string = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DeleteOption");
            object4 = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_KeepOption");
            object3 = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_CancelOption");
            object2 = new NotifyDescriptor((Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{string, object4, object3}, null);
            object = DialogDisplayer.getDefault().notify(object2);
            if (string.equals(object)) {
                this.deleteClassFiles(fileArray);
            } else if (!object4.equals(object)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void deleteClassFiles(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            FileObject fileObject = FileUtil.toFileObject((File)fileArray[i]);
            Enumeration enumeration = fileObject.getData(true);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                assert (e instanceof FileObject) : "Instance of FileObject: " + e;
                FileObject fileObject2 = (FileObject)e;
                try {
                    if (!"class".equals(fileObject2.getExt())) continue;
                    fileObject2.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.sourcePanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_SourceRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"));
        this.testsPanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_TestRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveTestFolder"));
        this.jLabel1 = new JLabel();
        this.jTextFieldConfigFiles = new JTextField();
        this.jButtonConfigFilesLocation = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldLibraries = new JTextField();
        this.jButtonLibraries = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_PanelSourceFolders"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_SourceDirectoriesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSN_jLabel3"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSD_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.sourcePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.testsPanel, gridBagConstraints);
        this.jLabel1.setLabelFor(this.jTextFieldConfigFiles);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbjarproject/ui/wizards/Bundle").getString("LBL_IW_ConfigFilesFolder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jTextFieldConfigFiles, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonConfigFilesLocation, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbjarproject/ui/wizards/Bundle").getString("LBL_NWP1_BrowseLocation_Button_w"));
        this.jButtonConfigFilesLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelSourceFolders.this.jButtonConfigFilesLocationActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jButtonConfigFilesLocation, gridBagConstraints);
        this.jLabel2.setLabelFor(this.jTextFieldLibraries);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbjarproject/ui/wizards/Bundle").getString("LBL_IW_LibrariesLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jTextFieldLibraries, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonLibraries, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbjarproject/ui/wizards/Bundle").getString("LBL_NWP1_BrowseLocation_Button"));
        this.jButtonLibraries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelSourceFolders.this.jButtonLibrariesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jButtonLibraries, gridBagConstraints);
    }

    private void jButtonLibrariesActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.jTextFieldLibraries.getText().length() > 0 && this.getLibraries().exists()) {
            jFileChooser.setSelectedFile(this.getLibraries());
        } else {
            jFileChooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("projdir"));
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextFieldLibraries.setText(file.getAbsolutePath());
        }
    }

    private void jButtonConfigFilesLocationActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.jTextFieldConfigFiles.getText().length() > 0 && this.getConfigFiles().exists()) {
            jFileChooser.setSelectedFile(this.getConfigFiles());
        } else {
            jFileChooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("projdir"));
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextFieldConfigFiles.setText(file.getAbsolutePath());
        }
    }

    private File getAsFile(String string) {
        if (string != null && string.trim().length() > 0) {
            return FileUtil.normalizeFile((File)new File(string));
        }
        return null;
    }

    public File getConfigFiles() {
        return this.getAsFile(this.jTextFieldConfigFiles.getText());
    }

    public File getLibraries() {
        return this.getAsFile(this.jTextFieldLibraries.getText());
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void readSettings(Object object) {
            this.settings = (WizardDescriptor)object;
            this.component.read(this.settings);
            Object object2 = this.component.getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.settings.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(PanelSourceFolders.class);
        }

        private void fireChangeEvent() {
            this.changeSupport.fireChange();
        }
    }
}

