/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.jruby.util.ByteList;
import org.jvyamlb.Positionable;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.PositionedScalarNode;
import org.jvyamlb.nodes.PositionedSequenceNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(ParserResult parserResult) {
        YamlParserResult yamlParserResult = (YamlParserResult)parserResult;
        if (yamlParserResult != null) {
            return yamlParserResult.getItems();
        }
        return Collections.emptyList();
    }

    List<? extends StructureItem> scanStructure(YamlParserResult yamlParserResult) {
        List<Node> list = yamlParserResult.getRootNodes();
        if (list.size() > 0) {
            return YamlStructureItem.initialize(yamlParserResult, list);
        }
        return Collections.emptyList();
    }

    public Map<String, List<OffsetRange>> folds(ParserResult parserResult) {
        YamlParserResult yamlParserResult = (YamlParserResult)parserResult;
        if (yamlParserResult == null) {
            return Collections.emptyMap();
        }
        List<? extends StructureItem> list = yamlParserResult.getItems();
        if (list.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        hashMap.put("codeblocks", arrayList);
        BaseDocument baseDocument = (BaseDocument)yamlParserResult.getSnapshot().getSource().getDocument(false);
        if (baseDocument != null) {
            for (StructureItem structureItem : list) {
                try {
                    this.addBlocks(yamlParserResult, baseDocument, arrayList, structureItem);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                    break;
                }
            }
        }
        return hashMap;
    }

    private void addBlocks(YamlParserResult yamlParserResult, BaseDocument baseDocument, List<OffsetRange> list, StructureItem structureItem) throws BadLocationException {
        int n = baseDocument.getLength();
        int n2 = Math.min((int)structureItem.getPosition(), n);
        int n3 = Math.min((int)structureItem.getEndPosition(), n);
        int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
        if (n2 >= n3 || n4 == Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3)) {
            return;
        }
        list.add(new OffsetRange(n4, n3));
        for (StructureItem structureItem2 : structureItem.getNestedItems()) {
            int n5 = (int)structureItem2.getPosition();
            int n6 = (int)structureItem2.getEndPosition();
            if (n5 < n2 || n6 > n3) continue;
            this.addBlocks(yamlParserResult, baseDocument, list, structureItem2);
        }
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class YamlStructureItem
    implements StructureItem,
    Comparable<YamlStructureItem> {
        private final String name;
        private List<YamlStructureItem> children;
        private final Node node;
        private final long begin;
        private final long end;

        YamlStructureItem(Node node, String string, long l, long l2) {
            this.node = node;
            this.name = string;
            this.begin = l;
            this.end = l2;
        }

        YamlStructureItem(Node node, String string, OffsetRange offsetRange) {
            this(node, string, offsetRange.getStart(), offsetRange.getEnd());
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            String string = this.getName();
            try {
                return XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                Exceptions.printStackTrace((Throwable)charConversionException);
                return string;
            }
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.ATTRIBUTE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return this.getNestedItems().size() == 0;
        }

        private static List<? extends StructureItem> initialize(YamlParserResult yamlParserResult, List<Node> list) {
            IdentityHashMap<Object, Boolean> identityHashMap = new IdentityHashMap<Object, Boolean>(100);
            ArrayList<YamlStructureItem> arrayList = new ArrayList<YamlStructureItem>();
            for (Node node : list) {
                YamlStructureItem yamlStructureItem = new YamlStructureItem(node, null, OffsetRange.NONE);
                YamlStructureItem.initializeChildren(yamlParserResult, yamlStructureItem, identityHashMap, 0);
                arrayList.addAll(yamlStructureItem.children);
            }
            return arrayList;
        }

        private static void initializeChildren(YamlParserResult yamlParserResult, YamlStructureItem yamlStructureItem, IdentityHashMap<Object, Boolean> identityHashMap, int n) {
            Object object;
            Object object2;
            Node node;
            Object object3;
            Iterator<YamlStructureItem> iterator;
            if (n > 20) {
                yamlStructureItem.children = Collections.emptyList();
                return;
            }
            Node node2 = yamlStructureItem.node;
            Object object5 = node2.getValue();
            if (object5 == null) {
                yamlStructureItem.children = Collections.emptyList();
                return;
            }
            boolean bl = false;
            if (identityHashMap.containsKey(object5)) {
                bl = true;
            }
            identityHashMap.put(object5, Boolean.TRUE);
            if (object5 instanceof Map) {
                iterator = (Map)object5;
                ArrayList<YamlStructureItem> object42 = new ArrayList<YamlStructureItem>();
                yamlStructureItem.children = object42;
                object3 = iterator.entrySet();
                node = object3.iterator();
                while (node.hasNext()) {
                    List list;
                    Object object4;
                    PositionedSequenceNode positionedSequenceNode;
                    object2 = node.next();
                    object = object2.getKey();
                    if (object instanceof PositionedSequenceNode) {
                        Object object6;
                        Object object7;
                        Object object82;
                        positionedSequenceNode = (PositionedSequenceNode)object;
                        object4 = positionedSequenceNode.getValue();
                        assert (object4 instanceof List);
                        list = (List)object4;
                        for (Object object82 : list) {
                            object7 = object82.getValue();
                            if (object7 instanceof List || object7 instanceof Map) {
                                object42.add(new YamlStructureItem((Node)object82, "list item", yamlParserResult.getAstRange((Node)object82)));
                                continue;
                            }
                            object6 = object7.toString();
                            object42.add(new YamlStructureItem((Node)object82, (String)object6, yamlParserResult.getAstRange((Node)object82)));
                        }
                        Iterator<Object> iterator2 = object2.getValue();
                        if (!(iterator2 instanceof PositionedSequenceNode)) continue;
                        positionedSequenceNode = (PositionedSequenceNode)iterator2;
                        object4 = positionedSequenceNode.getValue();
                        assert (object4 instanceof List);
                        list = (List)object4;
                        object82 = list.iterator();
                        while (object82.hasNext()) {
                            object7 = (Node)object82.next();
                            object6 = object7.getValue();
                            if (object6 instanceof List || object6 instanceof Map) {
                                object42.add(new YamlStructureItem((Node)object7, "list item", yamlParserResult.getAstRange((Node)object7)));
                                continue;
                            }
                            String string = object6.toString();
                            object42.add(new YamlStructureItem((Node)object7, string, yamlParserResult.getAstRange((Node)object7)));
                        }
                        continue;
                    }
                    assert (object instanceof PositionedScalarNode);
                    positionedSequenceNode = (PositionedScalarNode)object;
                    object4 = positionedSequenceNode.getValue().toString();
                    list = (Node)object2.getValue();
                    if (list == null) continue;
                    int n2 = yamlParserResult.convertByteToUtf8(((Positionable)list).getRange().end.offset);
                    if (list.getValue() instanceof ByteList && ((ByteList)list.getValue()).length() == 0) {
                        n2 = yamlParserResult.convertByteToUtf8(positionedSequenceNode.getRange().end.offset);
                    }
                    object42.add(new YamlStructureItem((Node)list, (String)object4, yamlParserResult.convertByteToUtf8(positionedSequenceNode.getRange().start.offset), n2));
                }
                Collections.sort(object42);
            } else if (object5 instanceof List) {
                iterator = (List)object5;
                ArrayList<YamlStructureItem> arrayList = new ArrayList<YamlStructureItem>(iterator.size());
                yamlStructureItem.children = arrayList;
                object3 = iterator.iterator();
                while (object3.hasNext()) {
                    node = (Node)object3.next();
                    object2 = node.getValue();
                    if (object2 instanceof List || object2 instanceof Map) {
                        arrayList.add(new YamlStructureItem(node, "list item", yamlParserResult.getAstRange(node)));
                        continue;
                    }
                    object = object2.toString();
                    arrayList.add(new YamlStructureItem(node, (String)object, yamlParserResult.getAstRange(node)));
                }
            } else {
                yamlStructureItem.children = Collections.emptyList();
            }
            if (yamlStructureItem.children.size() > 0) {
                for (YamlStructureItem yamlStructureItem2 : yamlStructureItem.children) {
                    if (bl) {
                        yamlStructureItem2.children = Collections.emptyList();
                        continue;
                    }
                    YamlStructureItem.initializeChildren(yamlParserResult, yamlStructureItem2, identityHashMap, n + 1);
                }
            }
        }

        public List<? extends StructureItem> getNestedItems() {
            assert (this.children != null);
            return this.children;
        }

        public long getPosition() {
            return this.begin;
        }

        public long getEndPosition() {
            return this.end;
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        @Override
        public int compareTo(YamlStructureItem yamlStructureItem) {
            return (int)(this.begin - yamlStructureItem.begin);
        }
    }
}

