/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.cookies.ErrorLocator;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.RefreshDialog;
import org.netbeans.modules.xml.multiview.ui.RefreshSaveDialog;
import org.netbeans.modules.xml.multiview.ui.SectionNodePanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.RequestProcessor;

public abstract class SectionInnerPanel
extends JPanel
implements LinkCookie,
ErrorLocator {
    private SectionView sectionView;
    private List refreshableList = new LinkedList();
    private boolean localFocusListenerInitialized = false;
    private FocusListener localFocusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            FocusListener[] focusListenerArray = SectionInnerPanel.this.getFocusListeners();
            for (int i = 0; i < focusListenerArray.length; ++i) {
                focusListenerArray[i].focusGained(focusEvent);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            SectionInnerPanel.this.processFocusEvent(focusEvent);
        }
    };
    private RequestProcessor.Task refreshTask = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            SectionInnerPanel.this.refreshView();
        }
    });
    private static final int REFRESH_DELAY = 50;
    private FlushFocusListener activeListener = null;
    private boolean closing = false;

    public SectionInnerPanel(SectionView sectionView) {
        this.sectionView = sectionView;
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
        if (!this.localFocusListenerInitialized) {
            this.localFocusListenerInitialized = true;
            SectionInnerPanel sectionInnerPanel = this;
            FocusListener focusListener2 = this.localFocusListener;
            this.addFocusListenerRecursively(sectionInnerPanel, focusListener2);
        }
    }

    private void addFocusListenerRecursively(Container container, FocusListener focusListener) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component.isFocusable() && !(component instanceof JLabel)) {
                component.addFocusListener(focusListener);
            }
            if (!(component instanceof Container) || component instanceof SectionNodePanel) continue;
            this.addFocusListenerRecursively((Container)component, focusListener);
        }
    }

    public SectionView getSectionView() {
        return this.sectionView;
    }

    public abstract void setValue(JComponent var1, Object var2);

    public void documentChanged(JTextComponent jTextComponent, String string) {
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    public final void addModifier(JTextComponent jTextComponent) {
        jTextComponent.addFocusListener(new ModifyFocusListener(jTextComponent));
    }

    public final void addModifier(JTextComponent jTextComponent, boolean bl) {
        jTextComponent.addFocusListener(new ModifyFocusListener(jTextComponent, bl));
    }

    public final void addModifier(JComboBox jComboBox) {
        jComboBox.addFocusListener(new ComboBoxModifyFocusListener(jComboBox));
    }

    public final void addModifier(JComboBox jComboBox, boolean bl) {
        jComboBox.addFocusListener(new ComboBoxModifyFocusListener(jComboBox, bl));
    }

    public final void addModifier(JRadioButton jRadioButton) {
        jRadioButton.addFocusListener(new RadioButtonModifyFocusListener(jRadioButton));
    }

    public final void addModifier(JCheckBox jCheckBox) {
        jCheckBox.addFocusListener(new CheckBoxModifyFocusListener(jCheckBox));
    }

    public final void addImmediateModifier(JCheckBox jCheckBox) {
        jCheckBox.addActionListener(new CheckBoxActionListener(jCheckBox));
    }

    public final void addImmediateModifier(JRadioButton jRadioButton) {
        jRadioButton.addActionListener(new RadioButtonActionListener(jRadioButton));
    }

    public final void addImmediateModifier(JComboBox jComboBox) {
        jComboBox.addActionListener(new ComboBoxActionListener(jComboBox));
    }

    public final void addImmediateModifier(JTextComponent jTextComponent) {
        jTextComponent.getDocument().addDocumentListener(new TextListener(jTextComponent, true));
    }

    public final void addValidatee(JTextComponent jTextComponent) {
        jTextComponent.getDocument().addDocumentListener(new TextListener(jTextComponent));
        jTextComponent.addFocusListener(new ValidateFocusListener(jTextComponent));
    }

    protected void scheduleRefreshView() {
        this.refreshTask.schedule(50);
    }

    public void refreshView() {
        Iterator iterator = this.refreshableList.iterator();
        while (iterator.hasNext()) {
            ((Refreshable)iterator.next()).refresh();
        }
    }

    protected void addRefreshable(Refreshable refreshable) {
        this.refreshableList.add(refreshable);
    }

    public void dataModelPropertyChange(Object object, String string, Object object2, Object object3) {
        this.scheduleRefreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canClose() {
        this.closing = true;
        try {
            if (this.activeListener != null) {
                boolean bl = this.activeListener.flushData();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closing = false;
        }
    }

    protected void signalUIChange() {
    }

    protected void startUIChange() {
    }

    protected void endUIChange() {
    }

    private class CheckBoxModifyFocusListener
    extends FlushFocusListener {
        private boolean orgValue;
        private final JCheckBox checkBox;

        public CheckBoxModifyFocusListener(JCheckBox jCheckBox) {
            this.checkBox = jCheckBox;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.orgValue = this.checkBox.isSelected();
            SectionInnerPanel.this.activeListener = this;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!SectionInnerPanel.this.closing) {
                this.flushData();
                SectionInnerPanel.this.activeListener = null;
            }
        }

        public boolean flushData() {
            if (this.checkBox.isSelected() != this.orgValue) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.checkBox, this.checkBox.isSelected());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canClose() {
            SectionInnerPanel.this.closing = true;
            try {
                if (SectionInnerPanel.this.activeListener != null) {
                    boolean bl = SectionInnerPanel.this.activeListener.flushData();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                SectionInnerPanel.this.closing = false;
            }
        }
    }

    private class RadioButtonActionListener
    extends FlushActionListener {
        private final JRadioButton radioButton;

        public RadioButtonActionListener(JRadioButton jRadioButton) {
            this.radioButton = jRadioButton;
        }

        public void doSetValue(ActionEvent actionEvent) {
            SectionInnerPanel.this.setValue(this.radioButton, this.radioButton.isSelected());
        }
    }

    private class CheckBoxActionListener
    extends FlushActionListener {
        private final JCheckBox checkBox;

        public CheckBoxActionListener(JCheckBox jCheckBox) {
            this.checkBox = jCheckBox;
        }

        public void doSetValue(ActionEvent actionEvent) {
            SectionInnerPanel.this.setValue(this.checkBox, this.checkBox.isSelected());
        }
    }

    private class ComboBoxActionListener
    extends FlushActionListener {
        private final JComboBox comboBox;

        public ComboBoxActionListener(JComboBox jComboBox) {
            this.comboBox = jComboBox;
        }

        public void doSetValue(ActionEvent actionEvent) {
            SectionInnerPanel.this.setValue(this.comboBox, this.comboBox.getSelectedItem());
        }
    }

    private abstract class FlushActionListener
    implements ActionListener {
        private FlushActionListener() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            SectionInnerPanel.this.startUIChange();
            this.doSetValue(actionEvent);
            SectionInnerPanel.this.signalUIChange();
            SectionInnerPanel.this.endUIChange();
        }

        public abstract void doSetValue(ActionEvent var1);
    }

    private class RadioButtonModifyFocusListener
    extends FlushFocusListener {
        private boolean orgValue;
        private final JRadioButton radioButton;

        public RadioButtonModifyFocusListener(JRadioButton jRadioButton) {
            this.radioButton = jRadioButton;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.orgValue = this.radioButton.isSelected();
            SectionInnerPanel.this.activeListener = this;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!SectionInnerPanel.this.closing) {
                this.flushData();
                SectionInnerPanel.this.activeListener = null;
            }
        }

        public boolean flushData() {
            if (this.radioButton.isSelected() != this.orgValue) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.radioButton, this.radioButton.isSelected());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            }
            return true;
        }
    }

    private class ComboBoxModifyFocusListener
    extends FlushFocusListener {
        private Object orgValue;
        private final JComboBox comboBox;
        private boolean test;

        public ComboBoxModifyFocusListener(JComboBox jComboBox) {
            this(jComboBox, true);
        }

        public ComboBoxModifyFocusListener(JComboBox jComboBox, boolean bl) {
            this.comboBox = jComboBox;
            this.test = bl;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.orgValue = this.comboBox.getSelectedItem();
            SectionInnerPanel.this.activeListener = this;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!SectionInnerPanel.this.closing) {
                this.flushData();
                SectionInnerPanel.this.activeListener = null;
            }
        }

        public boolean flushData() {
            boolean bl;
            Object object = this.comboBox.getSelectedItem();
            boolean bl2 = object == null ? this.orgValue == null : (bl = object.equals(this.orgValue));
            if (!this.test || !bl) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.comboBox, this.comboBox.getSelectedItem());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            }
            return true;
        }
    }

    private class ModifyFocusListener
    extends FlushFocusListener {
        private String orgValue;
        private final JTextComponent tc;
        private boolean test;

        public ModifyFocusListener(JTextComponent jTextComponent) {
            this(jTextComponent, true);
        }

        public ModifyFocusListener(JTextComponent jTextComponent, boolean bl) {
            this.tc = jTextComponent;
            this.test = bl;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.orgValue = this.tc.getText();
            SectionInnerPanel.this.activeListener = this;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!SectionInnerPanel.this.closing) {
                this.flushData();
                SectionInnerPanel.this.activeListener = null;
            }
        }

        public boolean flushData() {
            if (!this.test || !this.tc.getText().equals(this.orgValue)) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.tc, this.tc.getText());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            }
            return true;
        }
    }

    private class ValidateFocusListener
    extends FlushFocusListener {
        private String orgValue;
        private boolean viewIsBuggy;
        private final JTextComponent tc;
        private boolean disable;

        public ValidateFocusListener(JTextComponent jTextComponent) {
            this.tc = jTextComponent;
        }

        public void focusGained(FocusEvent focusEvent) {
            SectionInnerPanel.this.activeListener = this;
            this.orgValue = this.tc.getText();
            this.viewIsBuggy = SectionInnerPanel.this.sectionView.getErrorPanel().getError() != null;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!SectionInnerPanel.this.closing) {
                if (!this.flushData()) {
                    Utils.runInAwtDispatchThread(new Runnable(){

                        public void run() {
                            ValidateFocusListener.this.tc.requestFocus();
                        }
                    });
                } else {
                    this.disable = false;
                    SectionInnerPanel.this.activeListener = null;
                }
            }
        }

        public boolean flushData() {
            Error error = SectionInnerPanel.this.sectionView.getErrorPanel().getError();
            if (error != null && error.isEditError() && this.tc == error.getFocusableComponent()) {
                if (1 == error.getSeverityLevel() && !this.disable) {
                    RefreshSaveDialog refreshSaveDialog = new RefreshSaveDialog(SectionInnerPanel.this.sectionView.getErrorPanel());
                    Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)refreshSaveDialog);
                    dialog.setVisible(true);
                    Integer n = (Integer)refreshSaveDialog.getValue();
                    if (n.equals(RefreshSaveDialog.OPTION_FIX)) {
                        this.disable = true;
                        return false;
                    }
                    if (n.equals(RefreshSaveDialog.OPTION_REFRESH)) {
                        SectionInnerPanel.this.rollbackValue(this.tc);
                        SectionInnerPanel.this.sectionView.checkValidity();
                    } else {
                        SectionInnerPanel.this.startUIChange();
                        SectionInnerPanel.this.setValue(this.tc, this.tc.getText());
                        SectionInnerPanel.this.signalUIChange();
                        SectionInnerPanel.this.endUIChange();
                        SectionInnerPanel.this.sectionView.checkValidity();
                    }
                } else if (!this.disable) {
                    RefreshDialog refreshDialog = new RefreshDialog(SectionInnerPanel.this.sectionView.getErrorPanel());
                    Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)refreshDialog);
                    dialog.setVisible(true);
                    Integer n = (Integer)refreshDialog.getValue();
                    if (n.equals(RefreshDialog.OPTION_FIX)) {
                        this.disable = true;
                        return false;
                    }
                    if (n.equals(RefreshDialog.OPTION_REFRESH)) {
                        SectionInnerPanel.this.rollbackValue(this.tc);
                        SectionInnerPanel.this.sectionView.checkValidity();
                    }
                }
            } else if (!this.tc.getText().equals(this.orgValue)) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.tc, this.tc.getText());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
                SectionInnerPanel.this.sectionView.checkValidity();
            } else if (this.viewIsBuggy) {
                SectionInnerPanel.this.sectionView.checkValidity();
            }
            this.disable = false;
            return true;
        }
    }

    private abstract class FlushFocusListener
    extends FocusAdapter {
        private FlushFocusListener() {
        }

        public abstract boolean flushData();
    }

    private class TextListener
    implements DocumentListener {
        private JTextComponent tc;
        private boolean setValue = false;

        TextListener(JTextComponent jTextComponent) {
            this(jTextComponent, false);
        }

        TextListener(JTextComponent jTextComponent, boolean bl) {
            this.tc = jTextComponent;
            this.setValue = bl;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            if (this.setValue) {
                SectionInnerPanel.this.startUIChange();
                SectionInnerPanel.this.setValue(this.tc, this.tc.getText());
                SectionInnerPanel.this.signalUIChange();
                SectionInnerPanel.this.endUIChange();
            } else {
                SectionInnerPanel.this.documentChanged(this.tc, this.tc.getText());
            }
        }
    }
}

