/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.ErrorPanel;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;

public abstract class PanelView
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(PanelView.class.getName());
    private Node root;
    transient boolean sectionHeaderClicked;
    transient PopupAdapter popupListener;
    private transient ExplorerManager manager;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient ErrorPanel errorPanel;

    public PanelView() {
        this.initComponents();
    }

    public void initComponents() {
    }

    void attachErrorPanel(ErrorPanel errorPanel) {
        this.errorPanel = errorPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    protected abstract Error validateView();

    public final void checkValidity() {
        Error error = this.validateView();
        if (error != null) {
            this.errorPanel.setError(error);
        } else {
            this.errorPanel.clearError();
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node node) {
        this.root = node;
    }

    public void setSectionHeaderClicked(boolean bl) {
        this.sectionHeaderClicked = bl;
    }

    public boolean isSectionHeaderClicked() {
        return this.sectionHeaderClicked;
    }

    public void setPopupAllowed(boolean bl) {
        if (this.popupListener == null && bl) {
            this.popupListener = new PopupAdapter();
            this.addMouseListener((MouseListener)((Object)this.popupListener));
            return;
        }
        if (this.popupListener != null && !bl) {
            this.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
            return;
        }
    }

    public abstract void showSelection(Node[] var1);

    public boolean setManagerExploredContextAndSelection(Node node, Node[] nodeArray) {
        try {
            this.getExplorerManager().setExploredContextAndSelection(node, nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
        return true;
    }

    public boolean setManagerSelection(Node[] nodeArray) {
        try {
            this.getExplorerManager().setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.log(Level.WARNING, "Failed to select the given nodes.", illegalArgumentException);
            return false;
        }
        return true;
    }

    protected boolean selectionAccept(Node[] nodeArray) {
        return true;
    }

    public void open() {
    }

    public boolean canClose() {
        return true;
    }

    public void addNotify() {
        super.addNotify();
    }

    public ExplorerManager getExplorerManager() {
        return ExplorerManager.find((Component)this);
    }

    private class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = PanelView.this.getRoot().getContextMenu();
            jPopupMenu.show(PanelView.this, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

