/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionDataFiltersSupport {
    private final Lock lock = new Lock();
    private final List<DataFilter> filters = new ArrayList<DataFilter>();
    private final Collection<DataFilterListener> listeners = new ArrayList<DataFilterListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(DataFilter dataFilter, boolean bl) {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.filters.add(dataFilter)) {
                this.notifyListeners(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFilter(DataFilter dataFilter) {
        Lock lock = this.lock;
        synchronized (lock) {
            boolean bl = this.filters.remove(dataFilter);
            if (bl) {
                this.notifyListeners(false);
            }
            return bl;
        }
    }

    public List<DataFilter> getFilters() {
        return this.filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DataFilter> Collection<T> getDataFilter(Class<T> clazz) {
        DataFilter[] dataFilterArray;
        Object object = this.lock;
        synchronized (object) {
            dataFilterArray = this.filters.toArray(new DataFilter[0]);
        }
        object = new ArrayList();
        for (DataFilter dataFilter : dataFilterArray) {
            if (dataFilter.getClass() == clazz) {
                object.add(clazz.cast(dataFilter));
                continue;
            }
            try {
                Class<T> clazz2 = dataFilter.getClass().asSubclass(clazz);
                object.add(clazz.cast(dataFilter));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAll() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.filters.clear();
            this.notifyListeners(false);
        }
    }

    public void cleanAll(Class clazz) {
        this.cleanAll(clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAll(Class clazz, boolean bl) {
        Lock lock = this.lock;
        synchronized (lock) {
            ArrayList<DataFilter> arrayList = new ArrayList<DataFilter>();
            for (DataFilter dataFilter : this.filters) {
                if (dataFilter.getClass() != clazz) continue;
                arrayList.add(dataFilter);
            }
            this.filters.removeAll(arrayList);
            if (bl) {
                this.notifyListeners(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataFilterListener(DataFilterListener dataFilterListener) {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.listeners.contains(dataFilterListener)) {
                return;
            }
            this.listeners.add(dataFilterListener);
            dataFilterListener.dataFiltersChanged(this.filters, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataFilterListener(DataFilterListener dataFilterListener) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.listeners.remove(dataFilterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.listeners.clear();
        }
    }

    private void notifyListeners(boolean bl) {
        for (DataFilterListener dataFilterListener : this.listeners) {
            dataFilterListener.dataFiltersChanged(this.filters, bl);
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

