/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.execution.SubstitutableTarget;
import org.netbeans.modules.dlight.api.impl.DLightSessionInternalReference;
import org.netbeans.modules.dlight.api.impl.DLightTargetAccessor;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.impl.ServiceInfoDataStorageImpl;
import org.netbeans.modules.dlight.management.api.DLightSessionIOProvider;
import org.netbeans.modules.dlight.management.api.ExecutionContext;
import org.netbeans.modules.dlight.management.api.ExecutionContextListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.management.api.impl.DataFiltersManager;
import org.netbeans.modules.dlight.management.api.impl.DataProvidersManager;
import org.netbeans.modules.dlight.management.api.impl.DataStorageManager;
import org.netbeans.modules.dlight.management.api.impl.SessionDataFiltersSupport;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.spi.dataprovider.DataProviderFactory;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorDataProviderAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorRepairActionProviderAccessor;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightSession
implements DLightTargetListener,
DataFilterManager,
DLightSessionIOProvider,
DLightSessionInternalReference {
    private long startTimestamp = 0L;
    private static int sessionCount = 0;
    private static final Logger log = DLightLogger.getLogger(DLightSession.class);
    private List<ExecutionContext> contexts = new ArrayList<ExecutionContext>();
    private List<SessionStateListener> sessionStateListeners = null;
    private List<IndicatorDataProvider<?>> idps;
    private final List<IndicatorNotificationsListener> indicatorNotificationListeners = Collections.synchronizedList(new ArrayList());
    private List<DataStorage> storages = null;
    private ServiceInfoDataStorage serviceInfoDataStorage = null;
    private List<DataCollector<?>> collectors = null;
    private Map<String, Map<String, Visualizer<?>>> visualizers = null;
    private SessionState state = SessionState.CONFIGURATION;
    private final int sessionID;
    private String description = null;
    private List<ExecutionContextListener> contextListeners;
    private boolean isActive;
    private final String name;
    private boolean closeOnExit = false;
    private final SessionDataFiltersSupport dataFiltersSupport;
    private InputOutput io;

    public final long getStartTime() {
        return this.startTimestamp;
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.startTimestamp = 0L;
                this.serviceInfoDataStorage.put("service.storage.session_start_time.nanoseconds", this.startTimestamp + "");
                this.targetStarted(dLightTargetChangeEvent.target);
                break;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
    }

    DLightSession(String string) {
        this.name = string;
        this.sessionID = sessionCount++;
        this.dataFiltersSupport = new SessionDataFiltersSupport();
    }

    void cleanVisualizers() {
        if (this.visualizers == null) {
            return;
        }
        this.visualizers.clear();
        this.visualizers = null;
    }

    List<ExecutionContext> getExecutionContexts() {
        return this.contexts;
    }

    void addExecutionContext(ExecutionContext executionContext) {
        this.contexts.add(executionContext);
        executionContext.validateTools();
    }

    void setExecutionContext(ExecutionContext executionContext) {
        this.clearExecutionContext();
        this.addExecutionContext(executionContext);
    }

    void clearExecutionContext() {
        this.assertState(SessionState.CONFIGURATION);
        for (ExecutionContext executionContext : this.contexts) {
            executionContext.clear();
        }
        this.contexts.clear();
    }

    public void addSessionStateListener(SessionStateListener sessionStateListener) {
        if (this.sessionStateListeners == null) {
            this.sessionStateListeners = new ArrayList<SessionStateListener>();
        }
        if (!this.sessionStateListeners.contains(sessionStateListener)) {
            this.sessionStateListeners.add(sessionStateListener);
        }
    }

    public void removeSessionStateListener(SessionStateListener sessionStateListener) {
        if (this.sessionStateListeners == null) {
            return;
        }
        this.sessionStateListeners.remove(sessionStateListener);
    }

    public SessionState getState() {
        return this.state;
    }

    public synchronized String getDescription() {
        if (this.description == null) {
            String string;
            if (this.contexts.isEmpty()) {
                string = DLightSession.loc("DLightSession.description.noTargets", new String[0]);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (ExecutionContext executionContext : this.contexts) {
                    stringBuilder.append(executionContext.getTarget().toString()).append("; ");
                }
                string = stringBuilder.toString();
            }
            this.description = DLightSession.loc("DLightSession.description", String.valueOf(this.sessionID), string);
        }
        return this.description;
    }

    public String getDisplayName() {
        return this.name == null ? this.getDescription() : this.name;
    }

    boolean isRunning() {
        return this.state == SessionState.RUNNING;
    }

    boolean hasVisualizer(String string, String string2) {
        if (this.visualizers == null || !this.visualizers.containsKey(string)) {
            return false;
        }
        Map<String, Visualizer<?>> map = this.visualizers.get(string);
        return map.containsKey(string2);
    }

    List<Visualizer<?>> getVisualizers() {
        if (this.visualizers == null) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<String, Map<String, Visualizer<?>>> entry : this.visualizers.entrySet()) {
            for (Map.Entry<String, Visualizer<?>> entry2 : entry.getValue().entrySet()) {
                arrayList.add(entry2.getValue());
            }
        }
        return arrayList;
    }

    Visualizer<?> getVisualizer(String string, String string2) {
        if (this.visualizers == null || !this.visualizers.containsKey(string)) {
            return null;
        }
        Map<String, Visualizer<?>> map = this.visualizers.get(string);
        return map.get(string2);
    }

    Visualizer<?> putVisualizer(String string, String string2, Visualizer<?> visualizer) {
        Map<String, Visualizer<?>> map;
        if (this.visualizers == null) {
            this.visualizers = new HashMap();
        }
        if ((map = this.visualizers.get(string)) == null) {
            map = new HashMap();
            this.visualizers.put(string, map);
        }
        Visualizer<?> visualizer2 = map.put(string2, visualizer);
        return visualizer2;
    }

    public void revalidate() {
        for (ExecutionContext executionContext : this.contexts) {
            executionContext.validateTools();
        }
    }

    void closeOnExit() {
        this.closeOnExit = true;
    }

    synchronized void stop() {
        if (this.state == SessionState.ANALYZE) {
            return;
        }
        this.setState(SessionState.ANALYZE);
        for (ExecutionContext executionContext : this.contexts) {
            final DLightTarget dLightTarget = executionContext.getTarget();
            dLightTarget.removeTargetListener((DLightTargetListener)this);
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    DLightTargetAccessor.getDefault().getDLightTargetExecution(dLightTarget).terminate(dLightTarget);
                }
            }, (String)("Stop DLight session's target " + dLightTarget.toString()));
        }
    }

    void start() {
        Runnable runnable = new Runnable(){

            public void run() {
                ExecutionContext executionContext2;
                DataStorageManager.getInstance().clearActiveStorages(DLightSession.this);
                if (DLightSession.this.storages != null) {
                    DLightSession.this.storages.clear();
                }
                DLightSession.this.serviceInfoDataStorage = (ServiceInfoDataStorage)new ServiceInfoDataStorageImpl();
                if (DLightSession.this.collectors != null) {
                    DLightSession.this.collectors.clear();
                }
                for (ExecutionContext executionContext2 : DLightSession.this.contexts) {
                    DLightSession.this.prepareContext(executionContext2);
                }
                DLightSession.this.setState(SessionState.STARTING);
                boolean bl = false;
                executionContext2 = DLightTargetAccessor.getDefault();
                for (ExecutionContext executionContext3 : DLightSession.this.contexts) {
                    DLightTarget dLightTarget = executionContext3.getTarget();
                    if (!bl) {
                        dLightTarget.addTargetListener((DLightTargetListener)DLightSession.this);
                        bl = true;
                    }
                    DLightTarget.ExecutionEnvVariablesProvider executionEnvVariablesProvider = executionContext3.getDLightTargetExecutionEnvProvider();
                    DLightSession.this.io = executionContext2.getDLightTargetExecution(dLightTarget).start(dLightTarget, executionEnvVariablesProvider);
                }
            }
        };
        DLightExecutorService.submit((Runnable)runnable, (String)"DLight session");
    }

    public void addDataFilterListener(DataFilterListener dataFilterListener) {
        this.dataFiltersSupport.addDataFilterListener(dataFilterListener);
    }

    public void removeDataFilterListener(DataFilterListener dataFilterListener) {
        this.dataFiltersSupport.removeDataFilterListener(dataFilterListener);
    }

    public DLightSessionIOProvider getDLigthSessionIOProvider() {
        return this;
    }

    @Override
    public InputOutput getInputOutput() {
        if (this.state == SessionState.CONFIGURATION) {
            return null;
        }
        return this.io;
    }

    public void addDataFilter(final DataFilter dataFilter, final boolean bl) {
        if (EventQueue.isDispatchThread()) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    DLightSession.this.addDataFilterImpl(dataFilter, bl);
                }
            }, (String)"DLigthSession.addDataFIlter should be invoked in Non-AWT thread");
        } else {
            this.addDataFilterImpl(dataFilter, bl);
        }
    }

    private final void addDataFilterImpl(DataFilter dataFilter, boolean bl) {
        if (dataFilter instanceof TimeIntervalDataFilter) {
            this.dataFiltersSupport.cleanAll(TimeIntervalDataFilter.class, false);
        }
        this.dataFiltersSupport.addFilter(dataFilter, bl);
        if (!bl) {
            for (Visualizer<?> visualizer : this.getVisualizers()) {
                visualizer.refresh();
            }
        }
    }

    public void cleanAllDataFilter() {
        this.dataFiltersSupport.cleanAll();
        for (Visualizer<?> visualizer : this.getVisualizers()) {
            visualizer.refresh();
        }
    }

    public void cleanAllDataFilter(Class<?> clazz) {
        this.dataFiltersSupport.cleanAll(clazz);
        for (Visualizer<?> visualizer : this.getVisualizers()) {
            visualizer.refresh();
        }
    }

    public <T extends DataFilter> Collection<T> getDataFilter(Class<T> clazz) {
        return this.dataFiltersSupport.getDataFilter(clazz);
    }

    public boolean removeDataFilter(DataFilter dataFilter) {
        return this.dataFiltersSupport.removeFilter(dataFilter);
    }

    public final void addIndicatorNotificationListener(IndicatorNotificationsListener indicatorNotificationsListener) {
        if (indicatorNotificationsListener == null) {
            return;
        }
        if (!this.indicatorNotificationListeners.contains(indicatorNotificationsListener)) {
            this.indicatorNotificationListeners.add(indicatorNotificationsListener);
        }
        if (this.idps == null || this.idps.isEmpty()) {
            return;
        }
        for (IndicatorDataProvider<?> indicatorDataProvider : this.idps) {
            IndicatorDataProviderAccessor.getDefault().addIndicatorDataProviderListener(indicatorDataProvider, indicatorNotificationsListener);
        }
    }

    public final boolean removeIndicatorNotificationListener(IndicatorNotificationsListener indicatorNotificationsListener) {
        if (indicatorNotificationsListener == null) {
            return false;
        }
        return this.indicatorNotificationListeners.remove(indicatorNotificationsListener);
    }

    private boolean prepareContext(ExecutionContext executionContext) {
        DLightTarget.Info info;
        Object object;
        DLightTarget dLightTarget = executionContext.getTarget();
        executionContext.validateTools(executionContext.getDLightConfiguration().getConfigurationOptions(false).validateToolsRequiredUserInteraction());
        ArrayList<DLightTool> arrayList = new ArrayList<DLightTool>();
        StringBuilder stringBuilder = new StringBuilder();
        for (DLightTool object52 : executionContext.getTools()) {
            arrayList.add(object52);
            stringBuilder.append(object52.getName() + ":");
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        DataCollector<?> object6 = null;
        if (this.collectors == null) {
            this.collectors = new ArrayList();
        }
        if (executionContext.getDLightConfiguration().getConfigurationOptions(false).areCollectorsTurnedOn()) {
            for (DLightTool dLightTool : arrayList) {
                object = executionContext.getDLightConfiguration().getConfigurationOptions(false).getCollectors(dLightTool);
                info = object.iterator();
                while (info.hasNext()) {
                    DataCollector dataCollector = (DataCollector)info.next();
                    if (this.collectors.contains(dataCollector) || !dataCollector.getValidationStatus().isValid()) continue;
                    this.collectors.add(dataCollector);
                }
            }
        } else {
            this.collectors.clear();
        }
        ArrayList arrayList2 = new ArrayList();
        StringBuilder stringBuilder2 = new StringBuilder();
        object = new StringBuilder();
        for (DLightTool dLightTool : arrayList) {
            ArrayList<Indicator> arrayList3 = new ArrayList<Indicator>();
            this.idps = executionContext.getDLightConfiguration().getConfigurationOptions(false).getIndicatorDataProviders(dLightTool);
            if (this.idps != null) {
                for (IndicatorDataProvider<?> indicatorDataProvider : this.idps) {
                    if (!indicatorDataProvider.getValidationStatus().isValid()) continue;
                    if (indicatorDataProvider instanceof DLightTarget.ExecutionEnvVariablesProvider) {
                        executionContext.addDLightTargetExecutionEnviromentProvider((DLightTarget.ExecutionEnvVariablesProvider)indicatorDataProvider);
                    }
                    if (indicatorDataProvider instanceof DataCollector) {
                        DataCollector<?> dataCollector = (DataCollector<?>)indicatorDataProvider;
                        if (!this.collectors.contains(dataCollector)) {
                            this.collectors.add(dataCollector);
                        }
                        if (object6 == null && !dataCollector.isAttachable()) {
                            object6 = dataCollector;
                        }
                    } else {
                        arrayList2.add(indicatorDataProvider);
                    }
                    for (IndicatorNotificationsListener indicatorNotificationsListener : this.indicatorNotificationListeners) {
                        IndicatorDataProviderAccessor.getDefault().addIndicatorDataProviderListener(indicatorDataProvider, indicatorNotificationsListener);
                    }
                    stringBuilder2.append(indicatorDataProvider.getName() + ":");
                    List list = DLightToolAccessor.getDefault().getIndicators(dLightTool);
                    for (Indicator indicator : list) {
                        indicator.setIndicatorActionsProviderContext(Lookups.fixed((Object[])new Object[]{executionContext.getDLightConfiguration(), dLightTool}));
                        dLightTarget.addTargetListener((DLightTargetListener)indicator);
                        boolean bl = indicatorDataProvider.subscribe(indicator);
                        if (bl) {
                            if (!arrayList3.contains(indicator)) {
                                arrayList3.add(indicator);
                            }
                            dLightTarget.addTargetListener(indicatorDataProvider);
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("I have subscribed indicator " + indicator + " to indicatorDataProvider " + indicatorDataProvider);
                            }
                        }
                        if (!(indicator instanceof DataFilterListener)) continue;
                        this.addDataFilterListener((DataFilterListener)indicator);
                    }
                }
            }
            List list = DLightToolAccessor.getDefault().getIndicators(dLightTool);
            for (Indicator indicator : list) {
                if (arrayList3.contains(indicator)) continue;
                IndicatorAccessor.getDefault().setRepairActionProviderFor(indicator, IndicatorRepairActionProviderAccessor.getDefault().createNew(executionContext.getDLightConfiguration(), dLightTool, dLightTarget));
            }
        }
        info = DLightTargetAccessor.getDefault().getDLightTargetInfo(dLightTarget);
        for (Map.Entry entry : info.getInfo().entrySet()) {
            this.serviceInfoDataStorage.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.serviceInfoDataStorage.put("service.storage.tools", stringBuilder.toString());
        this.serviceInfoDataStorage.put("service.storage.configuration.name", executionContext.getDLightConfiguration().getConfigurationName());
        this.serviceInfoDataStorage.put("service.storage.idp.names", stringBuilder2.toString());
        this.serviceInfoDataStorage.put("service.storage.collector.names", ((StringBuilder)object).toString());
        if (this.collectors != null && this.collectors.size() > 0) {
            for (DataCollector<?> dataCollector : this.collectors) {
                ((StringBuilder)object).append(dataCollector.getName() + ":");
                Map<DataStorageType, DataStorage> map = DataStorageManager.getInstance().getDataStoragesFor(this, dataCollector);
                if (dataCollector instanceof DLightTarget.ExecutionEnvVariablesProvider) {
                    executionContext.addDLightTargetExecutionEnviromentProvider((DLightTarget.ExecutionEnvVariablesProvider)dataCollector);
                }
                if (map != null && !map.isEmpty()) {
                    if (this.storages == null) {
                        this.storages = new ArrayList<DataStorage>();
                    }
                    for (DataStorage dataStorage : map.values()) {
                        if (this.storages.contains(dataStorage)) continue;
                        dataStorage.attachTo(this.serviceInfoDataStorage);
                        this.storages.add(dataStorage);
                    }
                    dataCollector.init(map, dLightTarget);
                    this.addDataFilterListener((DataFilterListener)dataCollector);
                    if (dataCollector instanceof IndicatorDataProvider) {
                        IndicatorDataProvider indicatorDataProvider = (IndicatorDataProvider)dataCollector;
                        indicatorDataProvider.init(this.serviceInfoDataStorage);
                    }
                    if (object6 == null && !dataCollector.isAttachable()) {
                        object6 = dataCollector;
                    }
                } else {
                    log.severe("Cannot find storage for collector " + dataCollector);
                }
                dLightTarget.addTargetListener(dataCollector);
            }
        }
        for (IndicatorDataProvider indicatorDataProvider : arrayList2) {
            indicatorDataProvider.init(this.serviceInfoDataStorage);
            this.addDataFilterListener((DataFilterListener)indicatorDataProvider);
        }
        Map map = info.getInfo();
        for (Map.Entry entry : map.entrySet()) {
            DataFilter dataFilter = DataFiltersManager.getInstance().createFilter((String)entry.getKey(), (String)entry.getValue());
            if (dataFilter == null) continue;
            this.dataFiltersSupport.addFilter(dataFilter, false);
        }
        if (object6 != null && dLightTarget instanceof SubstitutableTarget) {
            ((SubstitutableTarget)dLightTarget).substitute(object6.getCmd(), object6.getArgs());
        }
        return true;
    }

    public List<DataStorage> getStorages() {
        return this.storages == null ? Collections.emptyList() : this.storages;
    }

    public ServiceInfoDataStorage getServiceInfoDataStorage() {
        return this.serviceInfoDataStorage;
    }

    public DataProvider createDataProvider(DataModelScheme dataModelScheme, DataTableMetadata dataTableMetadata) {
        Collection<DataProviderFactory> collection = DataProvidersManager.getInstance().getDataProviderFactories(dataModelScheme);
        if (collection.size() == 0) {
            return null;
        }
        List<DataStorage> list = this.getStorages();
        for (DataProviderFactory dataProviderFactory : collection) {
            for (DataStorage dataStorage : list) {
                if (!dataProviderFactory.validate(dataStorage) || dataTableMetadata != null && !dataStorage.hasData(dataTableMetadata)) continue;
                DataProvider dataProvider = DataProvidersManager.getInstance().createProvider(dataProviderFactory);
                dataProvider.attachTo(dataStorage);
                dataProvider.attachTo(this.serviceInfoDataStorage);
                dataProvider.dataFiltersChanged(this.dataFiltersSupport.getFilters(), false);
                this.addDataFilterListener((DataFilterListener)dataProvider);
                return dataProvider;
            }
        }
        return null;
    }

    public VisualizerDataProvider createVisualizerDataProvider(DataModelScheme dataModelScheme) {
        VisualizerDataProvider visualizerDataProvider = DataProvidersManager.getInstance().getDataProviderFor(dataModelScheme);
        if (visualizerDataProvider != null && !(visualizerDataProvider instanceof DataProvider)) {
            visualizerDataProvider.attachTo(this.serviceInfoDataStorage);
            return visualizerDataProvider;
        }
        return null;
    }

    void close() {
        this.setState(SessionState.CLOSED);
        if (this.sessionStateListeners != null) {
            this.sessionStateListeners.clear();
            this.sessionStateListeners = null;
        }
        this.dataFiltersSupport.removeAllListeners();
        if (!EventQueue.isDispatchThread()) {
            DataStorageManager.getInstance().closeSession(this);
            this.cleanVisualizers();
        } else {
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    DataStorageManager.getInstance().closeSession(DLightSession.this);
                    DLightSession.this.cleanVisualizers();
                }
            }, (String)("DLight Session " + this.getDisplayName() + " is closing.."));
        }
    }

    private void targetStarted(DLightTarget dLightTarget) {
        this.setState(SessionState.RUNNING);
    }

    private void targetFinished(DLightTarget dLightTarget) {
        this.setState(SessionState.ANALYZE);
        dLightTarget.removeTargetListener((DLightTargetListener)this);
        if (this.closeOnExit) {
            this.close();
        }
    }

    private void setState(SessionState sessionState) {
        SessionState sessionState2 = this.state;
        this.state = sessionState;
        if (this.sessionStateListeners != null) {
            for (SessionStateListener sessionStateListener : this.sessionStateListeners.toArray(new SessionStateListener[0])) {
                sessionStateListener.sessionStateChanged(this, sessionState2, sessionState);
            }
        }
    }

    public void addExecutionContextListener(ExecutionContextListener executionContextListener) {
        if (this.contextListeners == null) {
            this.contextListeners = new ArrayList<ExecutionContextListener>();
        }
        if (!this.contextListeners.contains(executionContextListener)) {
            this.contextListeners.add(executionContextListener);
        }
        this.updateContextListeners();
    }

    public void removeExecutionContextListener(ExecutionContextListener executionContextListener) {
        if (this.contextListeners == null) {
            return;
        }
        this.contextListeners.remove(executionContextListener);
        this.updateContextListeners();
    }

    private void updateContextListeners() {
        for (ExecutionContext executionContext : this.contexts) {
            executionContext.setListeners(this.contextListeners);
        }
    }

    public List<DLightTool> getTools() {
        ArrayList<DLightTool> arrayList = new ArrayList<DLightTool>();
        for (ExecutionContext executionContext : this.contexts) {
            arrayList.addAll(executionContext.getTools());
        }
        return arrayList;
    }

    DLightTool getToolByName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot use NULL as a tool name ");
        }
        for (ExecutionContext executionContext : this.contexts) {
            DLightTool dLightTool = executionContext.getToolByName(string);
            if (dLightTool == null) continue;
            return dLightTool;
        }
        return null;
    }

    DLightTool getToolByID(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot use NULL as a tool name ");
        }
        for (ExecutionContext executionContext : this.contexts) {
            DLightTool dLightTool = executionContext.getToolByID(string);
            if (dLightTool == null) continue;
            return dLightTool;
        }
        return null;
    }

    public List<Indicator<?>> getIndicators() {
        ArrayList arrayList = new ArrayList();
        for (ExecutionContext executionContext : this.contexts) {
            arrayList.addAll(executionContext.getIndicators());
        }
        return arrayList;
    }

    boolean containsIndicator(Indicator<?> indicator) {
        return this.getIndicators().contains(indicator);
    }

    private void assertState(SessionState sessionState) {
        if (this.state != sessionState) {
            throw new IllegalStateException("Session is in illegal state " + (Object)((Object)this.state) + "; Must be in " + (Object)((Object)sessionState));
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    void setActive(boolean bl) {
        this.isActive = bl;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(DLightSession.class, (String)string, (Object[])stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionState {
        CONFIGURATION,
        STARTING,
        RUNNING,
        PAUSED,
        ANALYZE,
        CLOSED;

    }
}

