/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.hints;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceOldSyntaxHint
implements Fix {
    protected final Document doc;
    protected final ArrayList<PPLine> lineList;
    protected PPBlockInfo block;

    public ReplaceOldSyntaxHint(Document document, ArrayList<PPLine> arrayList, PPBlockInfo pPBlockInfo) {
        this.doc = document;
        this.lineList = arrayList;
        this.block = pPBlockInfo;
    }

    protected boolean isNegative(List<PPToken> list) {
        return list.size() > 1 && list.get(1).getType() == 289;
    }

    protected List<String> extractAbilities(List<PPToken> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PPToken pPToken : list) {
            if (pPToken.getType() != 279) continue;
            arrayList.add(pPToken.getText());
        }
        return arrayList;
    }

    public synchronized ChangeInfo implement() {
        NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            public void run() {
                try {
                    PPLine pPLine = ReplaceOldSyntaxHint.this.lineList.get(ReplaceOldSyntaxHint.this.block.getStartLine() - 1);
                    List list = pPLine.getTokens();
                    boolean bl = ReplaceOldSyntaxHint.this.isNegative(list);
                    List<String> list2 = ReplaceOldSyntaxHint.this.extractAbilities(list);
                    PPBlockInfo pPBlockInfo = ReplaceOldSyntaxHint.this.findContraryBlock(bl, list2);
                    if (pPBlockInfo != null && pPBlockInfo.getStartLine() < ReplaceOldSyntaxHint.this.block.getStartLine()) {
                        PPBlockInfo pPBlockInfo2 = pPBlockInfo;
                        pPBlockInfo = ReplaceOldSyntaxHint.this.block;
                        ReplaceOldSyntaxHint.this.block = pPBlockInfo2;
                        bl ^= true;
                    }
                    if (pPBlockInfo != null) {
                        ReplaceOldSyntaxHint.this.doc.insertString(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, pPBlockInfo.getEndLine()), "//#endif", null);
                        ReplaceOldSyntaxHint.this.doc.insertString(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, pPBlockInfo.getStartLine()), "//#else", null);
                        ReplaceOldSyntaxHint.this.doc.remove(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, ReplaceOldSyntaxHint.this.block.getEndLine()), 1);
                    } else {
                        ReplaceOldSyntaxHint.this.doc.insertString(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, ReplaceOldSyntaxHint.this.block.getEndLine()), "//#endif", null);
                    }
                    ReplaceOldSyntaxHint.this.doc.insertString(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, ReplaceOldSyntaxHint.this.block.getStartLine()), "//#if " + ReplaceOldSyntaxHint.this.constructCondition(bl, list2), null);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                RecommentAction.actionPerformed(ReplaceOldSyntaxHint.this.doc);
            }
        });
        return null;
    }

    protected String constructCondition(boolean bl, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" || ");
            }
            stringBuffer.append(string);
        }
        return bl ? "!(" + stringBuffer.toString() + ")" : stringBuffer.toString();
    }

    protected int removeLine(Document document, int n) throws BadLocationException {
        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)(n - 1));
        document.remove(n2, Utilities.getRowEnd((BaseDocument)((BaseDocument)document), (int)n2) - n2);
        return n2;
    }

    private PPBlockInfo checkContraryBlock(PPBlockInfo pPBlockInfo, boolean bl, List<String> list) {
        List<String> list2;
        PPLine pPLine;
        List list3;
        while (pPBlockInfo != null && pPBlockInfo.getType() != 13) {
            pPBlockInfo = pPBlockInfo.getParent();
        }
        if (pPBlockInfo != null && pPBlockInfo.getType() == 13 && bl != this.isNegative(list3 = (pPLine = this.lineList.get(pPBlockInfo.getStartLine() - 1)).getTokens()) && (list2 = this.extractAbilities(list3)).size() == list.size() && list2.containsAll(list)) {
            return pPBlockInfo;
        }
        return null;
    }

    protected PPBlockInfo findContraryBlock(boolean bl, List<String> list) {
        PPBlockInfo pPBlockInfo;
        if (this.block.getStartLine() > 1 && (pPBlockInfo = this.checkContraryBlock(this.lineList.get(this.block.getStartLine() - 2).getBlock(), bl, list)) != null) {
            return pPBlockInfo;
        }
        if (this.block.getEndLine() < this.lineList.size() && (pPBlockInfo = this.checkContraryBlock(this.lineList.get(this.block.getEndLine()).getBlock(), bl, list)) != null) {
            return pPBlockInfo;
        }
        return null;
    }

    public String getText() {
        return NbBundle.getMessage(ReplaceOldSyntaxHint.class, (String)"HintReplaceOldSyntax");
    }
}

