/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.mobility.editor.actions.PreprocessorEditorContextAction;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateIfElseBlockAction
extends PreprocessorEditorContextAction {
    public static final String NAME = "create-if-else-block-action";

    public CreateIfElseBlockAction() {
        super(NAME);
    }

    @Override
    public boolean isEnabled(ProjectConfigurationsHelper projectConfigurationsHelper, ArrayList<PPLine> arrayList, JTextComponent jTextComponent) {
        return projectConfigurationsHelper != null && projectConfigurationsHelper.isPreprocessorOn() && projectConfigurationsHelper.getConfigurations().size() > 1 && !this.overlapsBlockBorders(jTextComponent, arrayList) && !this.overlapsGuardedBlocks(jTextComponent);
    }

    @Override
    public String getPopupMenuText(ProjectConfigurationsHelper projectConfigurationsHelper, ArrayList<PPLine> arrayList, JTextComponent jTextComponent) {
        return this.getBlock(jTextComponent, arrayList) != null ? NbBundle.getMessage(CreateIfElseBlockAction.class, (String)"LBL_Create_Nested_If_Else_Block") : NbBundle.getMessage(CreateIfElseBlockAction.class, (String)"LBL_Create_If_Else_Block");
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        ProjectConfigurationProvider projectConfigurationProvider = J2MEProjectUtils.getConfigProviderForDoc((Document)jTextComponent.getDocument());
        if (projectConfigurationProvider == null) {
            return;
        }
        NbDocument.runAtomic((StyledDocument)((StyledDocument)jTextComponent.getDocument()), (Runnable)new Runnable(){

            public void run() {
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(CreateIfElseBlockAction.this.getSelectionStartLine(jTextComponent) - 1));
                    int n2 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(CreateIfElseBlockAction.this.getSelectionEndLine(jTextComponent) - 1)));
                    String string = baseDocument.getText(n, n2 - n);
                    baseDocument.insertString(n2, "\n//#else\n" + string + "\n//#endif", null);
                    baseDocument.insertString(n, "//#if \n", null);
                    jTextComponent.setSelectionStart(n + 6);
                    jTextComponent.setSelectionEnd(n + 6);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                RecommentAction.actionPerformed(jTextComponent);
            }
        });
        Completion.get().showCompletion();
    }
}

