/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.mobility.editor.actions.PreprocessorEditorContextAction;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDebugBlockAction
extends PreprocessorEditorContextAction {
    public static final String NAME = "create-debug-block-action";

    public CreateDebugBlockAction() {
        super(NAME);
    }

    @Override
    public boolean isEnabled(ProjectConfigurationsHelper projectConfigurationsHelper, ArrayList<PPLine> arrayList, JTextComponent jTextComponent) {
        return projectConfigurationsHelper != null && projectConfigurationsHelper.isPreprocessorOn() && projectConfigurationsHelper.getConfigurations().size() > 1 && !this.overlapsBlockBorders(jTextComponent, arrayList) && !this.overlapsGuardedBlocks(jTextComponent);
    }

    public String getPopupMenuText(ProjectConfigurationsHelper projectConfigurationsHelper, ArrayList arrayList, JTextComponent jTextComponent) {
        return NbBundle.getMessage(CreateDebugBlockAction.class, (String)"LBL_Create_Debug_Block");
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        NbDocument.runAtomic((StyledDocument)((StyledDocument)jTextComponent.getDocument()), (Runnable)new Runnable(){

            public void run() {
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(CreateDebugBlockAction.this.getSelectionStartLine(jTextComponent) - 1));
                    int n2 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(CreateDebugBlockAction.this.getSelectionEndLine(jTextComponent) - 1)));
                    baseDocument.insertString(n2, "\n//#enddebug", null);
                    baseDocument.insertString(n, "//#mdebug\n", null);
                    jTextComponent.setSelectionEnd(jTextComponent.getSelectionStart());
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                RecommentAction.actionPerformed(jTextComponent);
            }
        });
    }
}

