/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.spi.support;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class DefaultClientSelectionPanel
extends InvokeOperationCookie.ClientSelectionPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private FileObject targetFile;
    private Node selectedMethod;
    private BeanTreeView treeView;
    private NodeChangeListener nodeChangeListener;
    private JLabel jLblTreeView;

    public DefaultClientSelectionPanel(FileObject fileObject) {
        this.targetFile = fileObject;
        this.manager = new ExplorerManager();
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(DefaultClientSelectionPanel.class, (String)"LBL_AvailableWebServices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DefaultClientSelectionPanel.class, (String)"ACSD_AvailableWebServicesTree"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefaultClientSelectionPanel.class, (String)"ACSD_AvailableWebServicesTree"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        if (this.nodeChangeListener == null) {
            this.nodeChangeListener = new NodeChangeListener();
        }
        this.manager.addPropertyChangeListener((PropertyChangeListener)this.nodeChangeListener);
        this.manager.setRootContext(this.getRootContext());
        this.treeView.expandAll();
    }

    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this.nodeChangeListener);
        super.removeNotify();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Node[] nodeArray;
        if (propertyChangeEvent.getSource() == this.manager && "selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = this.manager.getSelectedNodes()) != null && nodeArray.length > 0) {
            Node node = nodeArray[0];
            if (this.isClientNode(node)) {
                this.selectedMethod = node;
                this.setSelectionValid(true);
            } else {
                this.selectedMethod = null;
                this.setSelectionValid(false);
            }
        }
    }

    public Lookup getSelectedClient() {
        return this.selectedMethod.getLookup();
    }

    public final FileObject getTargetFile() {
        return this.targetFile;
    }

    protected abstract Node getRootContext();

    protected abstract boolean isClientNode(Node var1);

    protected BeanTreeView getTreeView() {
        return this.treeView;
    }

    private class NodeChangeListener
    implements PropertyChangeListener {
        private NodeChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray;
            if (propertyChangeEvent.getSource() == DefaultClientSelectionPanel.this.manager && "selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = DefaultClientSelectionPanel.this.manager.getSelectedNodes()) != null && nodeArray.length > 0) {
                Node node = nodeArray[0];
                if (DefaultClientSelectionPanel.this.isClientNode(node)) {
                    DefaultClientSelectionPanel.this.selectedMethod = node;
                    DefaultClientSelectionPanel.this.setSelectionValid(true);
                } else {
                    DefaultClientSelectionPanel.this.selectedMethod = null;
                    DefaultClientSelectionPanel.this.setSelectionValid(false);
                }
            }
        }
    }
}

