/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.netbeans.spi.xml.cookies.Util;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class TransformableSupport
implements TransformableCookie {
    private final Source source;
    private static TransformerFactory transformerFactory;

    public TransformableSupport(Source source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
    }

    public void transform(Source source, Result result, CookieObserver cookieObserver) throws TransformerException {
        try {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformableSupport.transform");
                Util.THIS.debug("   transformSource = " + source.getSystemId());
                Util.THIS.debug("   outputResult = " + result.getSystemId());
            }
            Source source2 = this.source;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("   xmlSource = " + source2.getSystemId());
            }
            Transformer transformer = TransformableSupport.newTransformer(source);
            if (cookieObserver != null) {
                Object object;
                ProtectionDomain protectionDomain = transformer.getClass().getProtectionDomain();
                CodeSource codeSource = protectionDomain.getCodeSource();
                if (codeSource == null) {
                    cookieObserver.receive(new CookieMessage(Util.THIS.getString("BK000", transformer.getClass().getName())));
                } else {
                    object = codeSource.getLocation();
                    cookieObserver.receive(new CookieMessage(Util.THIS.getString("BK001", object, transformer.getClass().getName())));
                }
                object = new Proxy(cookieObserver);
                transformer.setErrorListener((ErrorListener)object);
            }
            transformer.transform(source2, result);
        }
        catch (Exception exception) {
            Throwable throwable;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    EXCEPTION during transformation: " + exception.getClass().getName(), exception);
                Util.THIS.debug("    exception's message = " + exception.getLocalizedMessage());
                throwable = TransformableSupport.unwrapException(exception);
                Util.THIS.debug("    wrapped exception = " + throwable.getLocalizedMessage());
            }
            throwable = null;
            DefaultXMLProcessorDetail defaultXMLProcessorDetail = null;
            if (exception instanceof TransformerException) {
                throwable = (TransformerException)exception;
                if (cookieObserver != null && exception instanceof TransformerConfigurationException) {
                    defaultXMLProcessorDetail = new DefaultXMLProcessorDetail((TransformerException)throwable);
                }
            } else if (exception instanceof SAXParseException) {
                throwable = new TransformerException(exception);
                if (cookieObserver != null) {
                    defaultXMLProcessorDetail = new DefaultXMLProcessorDetail((SAXParseException)exception);
                }
            } else {
                throwable = new TransformerException(exception);
                if (cookieObserver != null) {
                    defaultXMLProcessorDetail = new DefaultXMLProcessorDetail((TransformerException)throwable);
                }
            }
            if (cookieObserver != null && defaultXMLProcessorDetail != null) {
                CookieMessage cookieMessage = new CookieMessage(TransformableSupport.message(exception), 3, defaultXMLProcessorDetail);
                cookieObserver.receive(cookieMessage);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("--> throw transExcept: " + throwable);
            }
            throw throwable;
        }
    }

    private static Throwable unwrapException(Throwable throwable) {
        Throwable throwable2 = null;
        if (throwable instanceof TransformerException) {
            throwable2 = ((TransformerException)throwable).getException();
        } else if (throwable instanceof SAXException) {
            throwable2 = ((SAXException)throwable).getException();
        } else {
            return throwable;
        }
        if (throwable2 == null) {
            return throwable;
        }
        return TransformableSupport.unwrapException(throwable2);
    }

    private static URIResolver getURIResolver() {
        UserCatalog userCatalog = UserCatalog.getDefault();
        URIResolver uRIResolver = userCatalog == null ? null : userCatalog.getURIResolver();
        return uRIResolver;
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(TransformableSupport.getURIResolver());
        }
        return transformerFactory;
    }

    private static Transformer newTransformer(Source source) throws TransformerConfigurationException {
        return TransformableSupport.getTransformerFactory().newTransformer(source);
    }

    private static String message(Throwable throwable) {
        String string = throwable.getLocalizedMessage();
        return string != null ? string : new ExceptionWriter(throwable).toString();
    }

    private static class Proxy
    implements ErrorListener {
        private final CookieObserver peer;

        public Proxy(CookieObserver cookieObserver) {
            if (cookieObserver == null) {
                throw new NullPointerException();
            }
            this.peer = cookieObserver;
        }

        public void error(TransformerException transformerException) throws TransformerException {
            this.report(2, transformerException);
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            this.report(3, transformerException);
            throw transformerException;
        }

        public void warning(TransformerException transformerException) throws TransformerException {
            this.report(1, transformerException);
        }

        private void report(int n, TransformerException transformerException) throws TransformerException {
            Throwable throwable;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("[TransformableSupport::Proxy]: report [" + n + "]: ", transformerException);
                Util.THIS.debug("    exception's message = " + transformerException.getLocalizedMessage());
                throwable = TransformableSupport.unwrapException(transformerException);
                Util.THIS.debug("    wrapped exception = " + throwable.getLocalizedMessage());
            }
            throwable = TransformableSupport.unwrapException(transformerException);
            CookieMessage cookieMessage = new CookieMessage(TransformableSupport.message(throwable), n, new DefaultXMLProcessorDetail(transformerException));
            this.peer.receive(cookieMessage);
        }
    }

    private static class ExceptionWriter
    extends PrintWriter {
        private int counter = 4;
        private Throwable t;

        public ExceptionWriter(Throwable throwable) {
            super(new StringWriter());
            this.t = throwable;
        }

        public void println(String string) {
            if (this.counter-- > 0) {
                super.println(string);
            }
        }

        public void println(Object object) {
            if (this.counter-- > 0) {
                super.println(object);
            }
        }

        public String toString() {
            this.t.printStackTrace(this);
            this.flush();
            return ((StringWriter)this.out).getBuffer().toString();
        }
    }
}

